/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.qpid.server.License;

public class ConfiguredObjectRegistrationGenerator
extends AbstractProcessor {
    public static final String MANAGED_OBJECT_CANONICAL_NAME = "org.apache.qpid.server.model.ManagedObject";
    private Map<String, Set<String>> _managedObjectClasses = new HashMap<String, Set<String>>();
    private Map<String, String> _typeMap = new HashMap<String, String>();
    private Map<String, String> _categoryMap = new HashMap<String, String>();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(MANAGED_OBJECT_CANONICAL_NAME);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(MANAGED_OBJECT_CANONICAL_NAME);
        try {
            for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
                Set<String> classNames;
                if (!element.getKind().equals((Object)ElementKind.INTERFACE) && !element.getKind().equals((Object)ElementKind.CLASS)) continue;
                PackageElement packageElement = elementUtils.getPackageOf(element);
                String packageName = packageElement.getQualifiedName().toString();
                String className = element.getSimpleName().toString();
                AnnotationMirror annotation = this.getAnnotation(element, annotationElement);
                AnnotationValue registerValue = this.getAnnotationValue(annotation, "register");
                if (registerValue != null && !((Boolean)registerValue.getValue()).booleanValue()) continue;
                AnnotationValue typeValue = this.getAnnotationValue(annotation, "type");
                if (typeValue != null) {
                    this._typeMap.put(packageName + "." + className, (String)typeValue.getValue());
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "looking for " + packageName + "." + className);
                    this._categoryMap.put(packageName + "." + className, this.getCategory((TypeElement)element));
                }
                if ((classNames = this._managedObjectClasses.get(packageName)) == null) {
                    classNames = new HashSet<String>();
                    this._managedObjectClasses.put(packageName, classNames);
                }
                classNames.add(className);
            }
            for (Map.Entry entry : this._managedObjectClasses.entrySet()) {
                this.generateRegistrationFile((String)entry.getKey(), (Set)entry.getValue());
            }
            this._managedObjectClasses.clear();
            this._typeMap.clear();
            this._categoryMap.clear();
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error: " + e.getLocalizedMessage());
        }
        return false;
    }

    private AnnotationValue getAnnotationValue(AnnotationMirror annotation, String attribute) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotation.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(attribute)) continue;
            return entry.getValue();
        }
        return null;
    }

    private AnnotationMirror getAnnotation(Element e, TypeElement annotationElement) {
        for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().equals(annotationElement)) continue;
            return annotationMirror;
        }
        return null;
    }

    private String getCategory(TypeElement e) {
        TypeElement parent;
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(MANAGED_OBJECT_CANONICAL_NAME);
        String category = null;
        List<? extends AnnotationMirror> annotationMirrors = e.getAnnotationMirrors();
        if (annotationMirrors != null) {
            block0: for (AnnotationMirror annotationMirror : annotationMirrors) {
                if (!annotationMirror.getAnnotationType().asElement().equals(annotationElement)) continue;
                category = e.getSimpleName().toString().toLowerCase();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().toString().equals("category")) continue;
                    if (Boolean.TRUE.equals(entry.getValue().getValue())) break block0;
                    category = null;
                    break block0;
                }
            }
        }
        if (category == null) {
            for (TypeMirror typeMirror : e.getInterfaces()) {
                category = this.getCategory((TypeElement)this.processingEnv.getTypeUtils().asElement(typeMirror));
                if (category == null) continue;
                break;
            }
        }
        if (category == null && e.getSuperclass() != null && (parent = (TypeElement)this.processingEnv.getTypeUtils().asElement(e.getSuperclass())) != null) {
            category = this.getCategory(parent);
        }
        return category;
    }

    private void generateRegistrationFile(String packageName, Set<String> classNames) {
        String className = "ConfiguredObjectRegistrationImpl";
        String qualifiedClassName = packageName + "." + "ConfiguredObjectRegistrationImpl";
        try {
            JavaFileObject factoryFile = this.processingEnv.getFiler().createSourceFile(qualifiedClassName, new Element[0]);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(factoryFile.openOutputStream(), "UTF-8"));
            pw.println("/*");
            for (String headerLine : License.LICENSE) {
                pw.println(" *" + headerLine);
            }
            pw.println(" */");
            pw.println();
            pw.print("package ");
            pw.print(packageName);
            pw.println(";");
            pw.println();
            pw.println("import java.util.Collections;");
            pw.println("import java.util.HashSet;");
            pw.println("import java.util.Set;");
            pw.println();
            pw.println("import org.apache.qpid.server.model.ConfiguredObject;");
            pw.println("import org.apache.qpid.server.plugin.ConfiguredObjectRegistration;");
            pw.println("import org.apache.qpid.server.plugin.PluggableService;");
            pw.println();
            pw.println("@PluggableService");
            pw.println("public class ConfiguredObjectRegistrationImpl implements ConfiguredObjectRegistration");
            pw.println("{");
            pw.println("    private final Set<Class<? extends ConfiguredObject>> _implementations;");
            pw.println();
            pw.println("    public ConfiguredObjectRegistrationImpl()");
            pw.println("    {");
            pw.println("        Set<Class<? extends ConfiguredObject>> implementations = new HashSet<>();");
            for (String implementationName : classNames) {
                String qualifiedImplementationName = packageName + "." + implementationName;
                if (this._typeMap.get(qualifiedImplementationName) != null && this._categoryMap.get(qualifiedImplementationName) != null) {
                    pw.println("        if(!Boolean.getBoolean(\"qpid.type.disabled:" + this._categoryMap.get(qualifiedImplementationName) + "." + this._typeMap.get(qualifiedImplementationName) + "\"))");
                    pw.println("        {");
                    pw.println("             implementations.add(" + implementationName + ".class);");
                    pw.println("        }");
                    continue;
                }
                pw.println("        implementations.add(" + implementationName + ".class);");
            }
            pw.println("        _implementations = Collections.unmodifiableSet(implementations);");
            pw.println("    }");
            pw.println();
            pw.println("    public String getType()");
            pw.println("    {");
            pw.println("        return \"" + packageName + "\";");
            pw.println("    }");
            pw.println();
            pw.println("    public Set<Class<? extends ConfiguredObject>> getConfiguredObjectClasses()");
            pw.println("    {");
            pw.println("        return _implementations;");
            pw.println("    }");
            pw.println();
            pw.println("}");
            pw.close();
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write file: " + qualifiedClassName + " - " + e.getLocalizedMessage());
        }
    }
}

