/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.validation;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"org.apache.qpid.server.model.ManagedAttribute", "org.apache.qpid.server.model.DerivedAttribute", "org.apache.qpid.server.model.ManagedStatistic"})
public class AttributeAnnotationValidator
extends AbstractProcessor {
    public static final String MANAGED_ATTRIBUTE_CLASS_NAME = "org.apache.qpid.server.model.ManagedAttribute";
    public static final String DERIVED_ATTRIBUTE_CLASS_NAME = "org.apache.qpid.server.model.DerivedAttribute";
    public static final String MANAGED_STATISTIC_CLASS_NAME = "org.apache.qpid.server.model.ManagedStatistic";
    private static final Set<TypeKind> VALID_PRIMITIVE_TYPES = new HashSet<TypeKind>(Arrays.asList(TypeKind.BOOLEAN, TypeKind.BYTE, TypeKind.CHAR, TypeKind.DOUBLE, TypeKind.FLOAT, TypeKind.INT, TypeKind.LONG, TypeKind.SHORT));

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processAttributes(roundEnv, MANAGED_ATTRIBUTE_CLASS_NAME);
        this.processAttributes(roundEnv, DERIVED_ATTRIBUTE_CLASS_NAME);
        this.processStatistics(roundEnv, MANAGED_STATISTIC_CLASS_NAME);
        return false;
    }

    public void processAttributes(RoundEnvironment roundEnv, String elementName) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(elementName);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            this.checkAnnotationIsOnMethodInInterface(annotationElement, element);
            ExecutableElement methodElement = (ExecutableElement)element;
            this.checkInterfaceExtendsConfiguredObject(annotationElement, methodElement);
            this.checkMethodTakesNoArgs(annotationElement, methodElement);
            this.checkMethodName(annotationElement, methodElement);
            this.checkMethodReturnType(annotationElement, methodElement);
            this.checkTypeAgreesWithName(annotationElement, methodElement);
        }
    }

    public void processStatistics(RoundEnvironment roundEnv, String elementName) {
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement annotationElement = elementUtils.getTypeElement(elementName);
        for (Element element : roundEnv.getElementsAnnotatedWith(annotationElement)) {
            this.checkAnnotationIsOnMethodInInterface(annotationElement, element);
            ExecutableElement methodElement = (ExecutableElement)element;
            this.checkInterfaceExtendsConfiguredObject(annotationElement, methodElement);
            this.checkMethodTakesNoArgs(annotationElement, methodElement);
            this.checkMethodName(annotationElement, methodElement);
            this.checkTypeAgreesWithName(annotationElement, methodElement);
            this.checkMethodReturnTypeIsNumber(annotationElement, methodElement);
        }
    }

    private void checkMethodReturnTypeIsNumber(TypeElement annotationElement, ExecutableElement methodElement) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeMirror numberType = elementUtils.getTypeElement("java.lang.Number").asType();
        if (!typeUtils.isAssignable(methodElement.getReturnType(), numberType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " return type does not extend Number: " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    public void checkTypeAgreesWithName(TypeElement annotationElement, ExecutableElement methodElement) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        String methodName = methodElement.getSimpleName().toString();
        if ((methodName.startsWith("is") || methodName.startsWith("has")) && methodElement.getReturnType().getKind() != TypeKind.BOOLEAN && !typeUtils.isSameType(typeUtils.boxedClass(typeUtils.getPrimitiveType(TypeKind.BOOLEAN)).asType(), methodElement.getReturnType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " return type is not boolean or Boolean: " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    public void checkMethodReturnType(TypeElement annotationElement, ExecutableElement methodElement) {
        if (!this.isValidType(methodElement.getReturnType())) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " cannot be applied to methods with return type " + methodElement.getReturnType().toString(), methodElement);
        }
    }

    public void checkMethodName(TypeElement annotationElement, ExecutableElement methodElement) {
        String methodName = methodElement.getSimpleName().toString();
        if (methodName.length() < 3 || methodName.length() < 4 && !methodName.startsWith("is") || !methodName.startsWith("is") && !methodName.startsWith("get") && !methodName.startsWith("has")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " can only be applied to methods which of the form getXXX(), isXXX() or hasXXX()", methodElement);
        }
    }

    public void checkMethodTakesNoArgs(TypeElement annotationElement, ExecutableElement methodElement) {
        if (!methodElement.getParameters().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " can only be applied to methods which take no parameters", methodElement);
        }
    }

    public void checkInterfaceExtendsConfiguredObject(TypeElement annotationElement, Element e) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        TypeMirror configuredObjectType = this.getErasure("org.apache.qpid.server.model.ConfiguredObject");
        TypeElement parent = (TypeElement)e.getEnclosingElement();
        if (!typeUtils.isAssignable(typeUtils.erasure(parent.asType()), configuredObjectType)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " can only be applied to methods within an interface which extends " + configuredObjectType.toString() + " which does not apply to " + parent.asType().toString(), e);
        }
    }

    public void checkAnnotationIsOnMethodInInterface(TypeElement annotationElement, Element e) {
        if (e.getKind() != ElementKind.METHOD || e.getEnclosingElement().getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@" + annotationElement.getSimpleName() + " can only be applied to methods within an interface", e);
        }
    }

    private boolean isValidType(TypeMirror type) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        Element typeElement = typeUtils.asElement(type);
        if (VALID_PRIMITIVE_TYPES.contains((Object)type.getKind())) {
            return true;
        }
        for (TypeKind primitive : VALID_PRIMITIVE_TYPES) {
            if (!typeUtils.isSameType(type, typeUtils.boxedClass(typeUtils.getPrimitiveType(primitive)).asType())) continue;
            return true;
        }
        if (typeElement.getKind() == ElementKind.ENUM) {
            return true;
        }
        String className = "org.apache.qpid.server.model.ConfiguredObject";
        TypeMirror configuredObjectType = this.getErasure(className);
        if (typeUtils.isAssignable(typeUtils.erasure(type), configuredObjectType)) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.lang.String").asType())) {
            return true;
        }
        if (typeUtils.isSameType(type, elementUtils.getTypeElement("java.util.UUID").asType())) {
            return true;
        }
        TypeMirror erasedType = typeUtils.erasure(type);
        if (typeUtils.isSameType(erasedType, this.getErasure("java.util.List")) || typeUtils.isSameType(erasedType, this.getErasure("java.util.Set")) || typeUtils.isSameType(erasedType, this.getErasure("java.util.Collection"))) {
            for (TypeMirror typeMirror : ((DeclaredType)type).getTypeArguments()) {
                if (this.isValidType(typeMirror)) continue;
                return false;
            }
            return true;
        }
        if (typeUtils.isSameType(erasedType, this.getErasure("java.util.Map"))) {
            List<? extends TypeMirror> args = ((DeclaredType)type).getTypeArguments();
            if (args.size() != 2) {
                throw new IllegalArgumentException("Map types " + type + " must have exactly two type arguments");
            }
            return this.isValidType(args.get(0)) && (this.isValidType(args.get(1)) || typeUtils.isSameType(args.get(1), this.getErasure("java.lang.Object")));
        }
        return false;
    }

    private TypeMirror getErasure(String className) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        Elements elementUtils = this.processingEnv.getElementUtils();
        return typeUtils.erasure(elementUtils.getTypeElement(className).asType());
    }
}

