/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.protocol.ProtocolEngineFactory;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.ProtocolExclusion;
import org.apache.qpid.server.ProtocolInclusion;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.ServerNetworkTransportConfiguration;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.actors.GenericActor;
import org.apache.qpid.server.logging.log4j.LoggingManagementFacade;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.ssl.SSLContextFactory;
import org.apache.qpid.transport.NetworkTransportConfiguration;
import org.apache.qpid.transport.network.IncomingNetworkTransport;
import org.apache.qpid.transport.network.NetworkTransport;
import org.apache.qpid.transport.network.Transport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Broker {
    private static final Logger LOGGER = Logger.getLogger(Broker.class);
    private volatile Thread _shutdownHookThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.removeShutdownHook();
        }
        finally {
            try {
                ApplicationRegistry.remove();
            }
            finally {
                this.clearAMQShortStringCache();
            }
        }
    }

    public void startup() throws Exception {
        this.startup(new BrokerOptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup(BrokerOptions options) throws Exception {
        CurrentActor.set(new BrokerActor(new SystemOutMessageLogger()));
        try {
            this.startupImpl(options);
            this.addShutdownHook();
        }
        finally {
            try {
                CurrentActor.remove();
            }
            finally {
                this.clearAMQShortStringCache();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupImpl(BrokerOptions options) throws Exception {
        String qpidHome = options.getQpidHome();
        File configFile = this.getConfigFile(options.getConfigFile(), "etc/config.xml", qpidHome, true);
        CurrentActor.get().message(BrokerMessages.CONFIG(configFile.getAbsolutePath()));
        File logConfigFile = this.getConfigFile(options.getLogConfigFile(), "etc/log4j.xml", qpidHome, false);
        this.configureLogging(logConfigFile, options.getLogWatchFrequency());
        ServerConfiguration serverConfig = new ServerConfiguration(configFile);
        ApplicationRegistry config = new ApplicationRegistry(serverConfig);
        if (options.getQpidWork() != null) {
            serverConfig.setQpidWork(options.getQpidWork());
        }
        if (options.getQpidHome() != null) {
            serverConfig.setQpidHome(options.getQpidHome());
        }
        this.updateManagementPorts(serverConfig, options.getJmxPortRegistryServer(), options.getJmxPortConnectorServer());
        ApplicationRegistry.initialise(config);
        BrokerMessages.reload();
        CurrentActor.set(new BrokerActor(config.getCompositeStartupMessageLogger()));
        CurrentActor.setDefault(new BrokerActor(config.getRootMessageLogger()));
        GenericActor.setDefaultMessageLogger(config.getRootMessageLogger());
        try {
            String bindAddr;
            HashSet<Integer> include_0_8;
            HashSet<Integer> exclude_0_8;
            HashSet<Integer> include_0_9;
            HashSet<Integer> exclude_0_9;
            HashSet<Integer> include_0_9_1;
            HashSet<Integer> exclude_0_9_1;
            HashSet<Integer> include_0_10;
            HashSet<Integer> exclude_0_10;
            HashSet<Integer> include_1_0;
            HashSet<Integer> exclude_1_0;
            HashSet<Integer> sslPorts;
            HashSet<Integer> ports = new HashSet<Integer>(options.getPorts());
            if (ports.isEmpty()) {
                Broker.parsePortList(ports, serverConfig.getPorts());
            }
            if ((sslPorts = new HashSet<Integer>(options.getSSLPorts())).isEmpty()) {
                Broker.parsePortList(sslPorts, serverConfig.getSSLPorts());
            }
            if ((exclude_1_0 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v1_0))).isEmpty()) {
                Broker.parsePortList(exclude_1_0, serverConfig.getPortExclude10());
            }
            if ((include_1_0 = new HashSet<Integer>(options.getIncludedPorts(ProtocolInclusion.v1_0))).isEmpty()) {
                Broker.parsePortList(include_1_0, serverConfig.getPortInclude10());
            }
            if ((exclude_0_10 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_10))).isEmpty()) {
                Broker.parsePortList(exclude_0_10, serverConfig.getPortExclude010());
            }
            if ((include_0_10 = new HashSet<Integer>(options.getIncludedPorts(ProtocolInclusion.v0_10))).isEmpty()) {
                Broker.parsePortList(include_0_10, serverConfig.getPortInclude010());
            }
            if ((exclude_0_9_1 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_9_1))).isEmpty()) {
                Broker.parsePortList(exclude_0_9_1, serverConfig.getPortExclude091());
            }
            if ((include_0_9_1 = new HashSet<Integer>(options.getIncludedPorts(ProtocolInclusion.v0_9_1))).isEmpty()) {
                Broker.parsePortList(include_0_9_1, serverConfig.getPortInclude091());
            }
            if ((exclude_0_9 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_9))).isEmpty()) {
                Broker.parsePortList(exclude_0_9, serverConfig.getPortExclude09());
            }
            if ((include_0_9 = new HashSet<Integer>(options.getIncludedPorts(ProtocolInclusion.v0_9))).isEmpty()) {
                Broker.parsePortList(include_0_9, serverConfig.getPortInclude09());
            }
            if ((exclude_0_8 = new HashSet<Integer>(options.getExcludedPorts(ProtocolExclusion.v0_8))).isEmpty()) {
                Broker.parsePortList(exclude_0_8, serverConfig.getPortExclude08());
            }
            if ((include_0_8 = new HashSet<Integer>(options.getIncludedPorts(ProtocolInclusion.v0_8))).isEmpty()) {
                Broker.parsePortList(include_0_8, serverConfig.getPortInclude08());
            }
            if ((bindAddr = options.getBind()) == null) {
                bindAddr = serverConfig.getBind();
            }
            InetAddress bindAddress = bindAddr.equals("*") ? null : InetAddress.getByName(bindAddr);
            AmqpProtocolVersion defaultSupportedProtocolReply = serverConfig.getDefaultSupportedProtocolReply();
            if (!serverConfig.getSSLOnly()) {
                Iterator i$ = ports.iterator();
                while (i$.hasNext()) {
                    int port = (Integer)i$.next();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(bindAddress, port);
                    Set<AmqpProtocolVersion> supported = Broker.getSupportedVersions(port, exclude_1_0, exclude_0_10, exclude_0_9_1, exclude_0_9, exclude_0_8, include_1_0, include_0_10, include_0_9_1, include_0_9, include_0_8, serverConfig);
                    ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(serverConfig, inetSocketAddress, "tcp");
                    IncomingNetworkTransport transport = Transport.getIncomingTransportInstance();
                    MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(supported, defaultSupportedProtocolReply);
                    transport.accept((NetworkTransportConfiguration)settings, (ProtocolEngineFactory)protocolEngineFactory, null);
                    ApplicationRegistry.getInstance().addAcceptor(inetSocketAddress, new QpidAcceptor((NetworkTransport)transport, QpidAcceptor.Transport.TCP, supported));
                    CurrentActor.get().message(BrokerMessages.LISTENING("TCP", port));
                }
            }
            if (serverConfig.getEnableSSL()) {
                String keystorePath = serverConfig.getConnectorKeyStorePath();
                String keystorePassword = serverConfig.getConnectorKeyStorePassword();
                String keystoreType = serverConfig.getConnectorKeyStoreType();
                String keyManagerFactoryAlgorithm = serverConfig.getConnectorKeyManagerFactoryAlgorithm();
                SSLContext sslContext = serverConfig.getConnectorTrustStorePath() != null ? SSLContextFactory.buildClientContext((String)serverConfig.getConnectorTrustStorePath(), (String)serverConfig.getConnectorTrustStorePassword(), (String)serverConfig.getConnectorTrustStoreType(), (String)serverConfig.getConnectorTrustManagerFactoryAlgorithm(), (String)keystorePath, (String)keystorePassword, (String)keystoreType, (String)keyManagerFactoryAlgorithm, (String)serverConfig.getCertAlias()) : SSLContextFactory.buildServerContext((String)keystorePath, (String)keystorePassword, (String)keystoreType, (String)keyManagerFactoryAlgorithm);
                Iterator i$ = sslPorts.iterator();
                while (i$.hasNext()) {
                    int sslPort = (Integer)i$.next();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(bindAddress, sslPort);
                    Set<AmqpProtocolVersion> supported = Broker.getSupportedVersions(sslPort, exclude_1_0, exclude_0_10, exclude_0_9_1, exclude_0_9, exclude_0_8, include_1_0, include_0_10, include_0_9_1, include_0_9, include_0_8, serverConfig);
                    ServerNetworkTransportConfiguration settings = new ServerNetworkTransportConfiguration(serverConfig, inetSocketAddress, "tcp");
                    IncomingNetworkTransport transport = Transport.getIncomingTransportInstance();
                    MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory(supported, defaultSupportedProtocolReply);
                    transport.accept((NetworkTransportConfiguration)settings, (ProtocolEngineFactory)protocolEngineFactory, sslContext);
                    ApplicationRegistry.getInstance().addAcceptor(inetSocketAddress, new QpidAcceptor((NetworkTransport)transport, QpidAcceptor.Transport.SSL, supported));
                    CurrentActor.get().message(BrokerMessages.LISTENING("TCP/SSL", sslPort));
                }
            }
            CurrentActor.get().message(BrokerMessages.READY());
        }
        finally {
            CurrentActor.remove();
        }
    }

    private static Set<AmqpProtocolVersion> getSupportedVersions(int port, Set<Integer> exclude_1_0, Set<Integer> exclude_0_10, Set<Integer> exclude_0_9_1, Set<Integer> exclude_0_9, Set<Integer> exclude_0_8, Set<Integer> include_1_0, Set<Integer> include_0_10, Set<Integer> include_0_9_1, Set<Integer> include_0_9, Set<Integer> include_0_8, ServerConfiguration serverConfig) {
        EnumSet<AmqpProtocolVersion> supported = EnumSet.allOf(AmqpProtocolVersion.class);
        if (!(!exclude_1_0.contains(port) && serverConfig.isAmqp10enabled() || include_1_0.contains(port))) {
            supported.remove((Object)AmqpProtocolVersion.v1_0_0);
        }
        if (!(!exclude_0_10.contains(port) && serverConfig.isAmqp010enabled() || include_0_10.contains(port))) {
            supported.remove((Object)AmqpProtocolVersion.v0_10);
        }
        if (!(!exclude_0_9_1.contains(port) && serverConfig.isAmqp091enabled() || include_0_9_1.contains(port))) {
            supported.remove((Object)AmqpProtocolVersion.v0_9_1);
        }
        if (!(!exclude_0_9.contains(port) && serverConfig.isAmqp09enabled() || include_0_9.contains(port))) {
            supported.remove((Object)AmqpProtocolVersion.v0_9);
        }
        if (!(!exclude_0_8.contains(port) && serverConfig.isAmqp08enabled() || include_0_8.contains(port))) {
            supported.remove((Object)AmqpProtocolVersion.v0_8);
        }
        return supported;
    }

    private File getConfigFile(String fileName, String defaultFileName, String qpidHome, boolean throwOnFileNotFound) throws InitException {
        File configFile = null;
        configFile = fileName != null ? new File(fileName) : new File(qpidHome, defaultFileName);
        if (!configFile.exists() && throwOnFileNotFound) {
            String error = "File " + configFile + " could not be found. Check the file exists and is readable.";
            if (qpidHome == null) {
                error = error + "\nNote: " + "QPID_HOME" + " is not set.";
            }
            throw new InitException(error, null);
        }
        return configFile;
    }

    public static void parsePortList(Set<Integer> output, List<?> ports) throws InitException {
        if (ports != null) {
            for (Object o : ports) {
                try {
                    output.add(Integer.parseInt(String.valueOf(o)));
                }
                catch (NumberFormatException e) {
                    throw new InitException("Invalid port: " + o, e);
                }
            }
        }
    }

    private void updateManagementPorts(ServerConfiguration configuration, Integer registryServerPort, Integer connectorServerPort) {
        if (registryServerPort != null) {
            try {
                configuration.setJMXPortRegistryServer(registryServerPort);
            }
            catch (NumberFormatException e) {
                throw new InitException("Invalid management (registry server) port: " + registryServerPort, null);
            }
        }
        if (connectorServerPort != null) {
            try {
                configuration.setJMXPortConnectorServer(connectorServerPort);
            }
            catch (NumberFormatException e) {
                throw new InitException("Invalid management (connector server) port: " + connectorServerPort, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogging(File logConfigFile, int logWatchTime) throws InitException, IOException {
        if (logConfigFile.exists() && logConfigFile.canRead()) {
            CurrentActor.get().message(BrokerMessages.LOG_CONFIG(logConfigFile.getAbsolutePath()));
            if (logWatchTime > 0) {
                System.out.println("log file " + logConfigFile.getAbsolutePath() + " will be checked for changes every " + logWatchTime + " seconds");
                try {
                    LoggingManagementFacade.configureAndWatch(logConfigFile.getPath(), logWatchTime * 1000);
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            } else {
                try {
                    LoggingManagementFacade.configure(logConfigFile.getPath());
                }
                catch (Exception e) {
                    throw new InitException(e.getMessage(), e);
                }
            }
        } else {
            System.err.println("Logging configuration error: unable to read file " + logConfigFile.getAbsolutePath());
            System.err.println("Using the fallback internal fallback-log4j.properties configuration");
            InputStream propsFile = this.getClass().getResourceAsStream("/fallback-log4j.properties");
            if (propsFile == null) {
                throw new IOException("Unable to load the fallback internal fallback-log4j.properties configuration file");
            }
            try {
                Properties fallbackProps = new Properties();
                fallbackProps.load(propsFile);
                PropertyConfigurator.configure((Properties)fallbackProps);
            }
            finally {
                propsFile.close();
            }
        }
    }

    private void addShutdownHook() {
        Thread shutdownHookThread = new Thread(new ShutdownService());
        shutdownHookThread.setName("QpidBrokerShutdownHook");
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
        this._shutdownHookThread = shutdownHookThread;
        LOGGER.debug((Object)"Added shutdown hook");
    }

    private void removeShutdownHook() {
        Thread shutdownThread = this._shutdownHookThread;
        if (shutdownThread != null && Thread.currentThread() != shutdownThread) {
            LOGGER.debug((Object)"Removing shutdown hook");
            this._shutdownHookThread = null;
            boolean removed = false;
            try {
                removed = Runtime.getRuntime().removeShutdownHook(shutdownThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Removed shutdown hook: " + removed));
            }
        } else {
            LOGGER.debug((Object)"Skipping shutdown hook removal as there either isnt one, or we are it.");
        }
    }

    private void clearAMQShortStringCache() {
        AMQShortString.clearLocalCache();
    }

    private class ShutdownService
    implements Runnable {
        private ShutdownService() {
        }

        public void run() {
            LOGGER.debug((Object)"Shutdown hook running");
            Broker.this.shutdown();
        }
    }

    protected static class InitException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        InitException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

