/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.server.Broker;
import org.apache.qpid.server.BrokerOptions;
import org.apache.qpid.server.ProtocolExclusion;
import org.apache.qpid.server.ProtocolInclusion;
import org.apache.qpid.server.registry.ApplicationRegistry;

public class Main {
    private static final Option OPTION_HELP = new Option("h", "help", false, "print this message");
    private static final Option OPTION_VERSION = new Option("v", "version", false, "print the version information and exit");
    private static final Option OPTION_CONFIG_FILE;
    private static final Option OPTION_PORT;
    private static final Option OPTION_SSLPORT;
    private static final Option OPTION_EXCLUDE_1_0;
    private static final Option OPTION_EXCLUDE_0_10;
    private static final Option OPTION_EXCLUDE_0_9_1;
    private static final Option OPTION_EXCLUDE_0_9;
    private static final Option OPTION_EXCLUDE_0_8;
    private static final Option OPTION_INCLUDE_1_0;
    private static final Option OPTION_INCLUDE_0_10;
    private static final Option OPTION_INCLUDE_0_9_1;
    private static final Option OPTION_INCLUDE_0_9;
    private static final Option OPTION_INCLUDE_0_8;
    private static final Option OPTION_JMX_PORT_REGISTRY_SERVER;
    private static final Option OPTION_JMX_PORT_CONNECTOR_SERVER;
    private static final Option OPTION_BIND;
    private static final Option OPTION_LOG_CONFIG_FILE;
    private static final Option OPTION_LOG_WATCH;
    private static final Options OPTIONS;
    protected CommandLine _commandLine;

    public static void main(String[] args) {
        if (System.getProperty("log4j.configuration") == null) {
            System.setProperty("log4j.defaultInitOverride", "true");
        }
        new Main(args);
    }

    public Main(String[] args) {
        if (this.parseCommandline(args)) {
            try {
                this.execute();
            }
            catch (Throwable e) {
                System.err.println("Exception during startup: " + e);
                e.printStackTrace();
                this.shutdown(1);
            }
        }
    }

    protected boolean parseCommandline(String[] args) {
        try {
            this._commandLine = new PosixParser().parse(OPTIONS, args);
            return true;
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", OPTIONS, true);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void execute() throws Exception {
        if (this._commandLine.hasOption(OPTION_HELP.getOpt())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("Qpid", OPTIONS, true);
        } else if (this._commandLine.hasOption(OPTION_VERSION.getOpt())) {
            StringBuilder protocol = new StringBuilder("AMQP version(s) [major.minor]: ");
            boolean first = true;
            for (ProtocolVersion pv : ProtocolVersion.getSupportedProtocolVersions()) {
                if (first) {
                    first = false;
                } else {
                    protocol.append(", ");
                }
                protocol.append(pv.getMajorVersion()).append('-').append(pv.getMinorVersion());
            }
            System.out.println(QpidProperties.getVersionString() + " (" + protocol + ")");
        } else {
            Object[] sslPortStr;
            Object[] portStr;
            String bindAddr;
            String jmxPortConnectorServer;
            String jmxPortRegistryServer;
            String logConfig;
            String logWatchConfig;
            BrokerOptions options = new BrokerOptions();
            String configFile = this._commandLine.getOptionValue(OPTION_CONFIG_FILE.getOpt());
            if (configFile != null) {
                options.setConfigFile(configFile);
            }
            if ((logWatchConfig = this._commandLine.getOptionValue(OPTION_LOG_WATCH.getOpt())) != null) {
                options.setLogWatchFrequency(Integer.parseInt(logWatchConfig));
            }
            if ((logConfig = this._commandLine.getOptionValue(OPTION_LOG_CONFIG_FILE.getOpt())) != null) {
                options.setLogConfigFile(logConfig);
            }
            if ((jmxPortRegistryServer = this._commandLine.getOptionValue(OPTION_JMX_PORT_REGISTRY_SERVER.getOpt())) != null) {
                options.setJmxPortRegistryServer(Integer.parseInt(jmxPortRegistryServer));
            }
            if ((jmxPortConnectorServer = this._commandLine.getOptionValue(OPTION_JMX_PORT_CONNECTOR_SERVER.getLongOpt())) != null) {
                options.setJmxPortConnectorServer(Integer.parseInt(jmxPortConnectorServer));
            }
            if ((bindAddr = this._commandLine.getOptionValue(OPTION_BIND.getOpt())) != null) {
                options.setBind(bindAddr);
            }
            if ((portStr = this._commandLine.getOptionValues(OPTION_PORT.getOpt())) != null) {
                Main.parsePortArray(options, portStr, false);
                for (ProtocolExclusion protocolExclusion : ProtocolExclusion.values()) {
                    Main.parsePortArray(options, (Object[])this._commandLine.getOptionValues(protocolExclusion.getExcludeName()), protocolExclusion);
                }
                for (Enum enum_ : ProtocolInclusion.values()) {
                    Main.parseProtocolInclusions(options, this._commandLine.getOptionValues(((ProtocolInclusion)enum_).getIncludeName()), (ProtocolInclusion)enum_);
                }
            }
            if ((sslPortStr = this._commandLine.getOptionValues(OPTION_SSLPORT.getOpt())) != null) {
                void var12_24;
                void var12_22;
                Main.parsePortArray(options, sslPortStr, true);
                Enum[] arr$ = ProtocolExclusion.values();
                int len$ = arr$.length;
                boolean bl = false;
                while (var12_22 < len$) {
                    ProtocolExclusion protocolExclusion = arr$[var12_22];
                    Main.parsePortArray(options, (Object[])this._commandLine.getOptionValues(protocolExclusion.getExcludeName()), protocolExclusion);
                    ++var12_22;
                }
                arr$ = ProtocolInclusion.values();
                len$ = arr$.length;
                boolean bl2 = false;
                while (var12_24 < len$) {
                    Enum enum_ = arr$[var12_24];
                    Main.parseProtocolInclusions(options, this._commandLine.getOptionValues(((ProtocolInclusion)enum_).getIncludeName()), (ProtocolInclusion)enum_);
                    ++var12_24;
                }
            }
            this.setExceptionHandler();
            this.startBroker(options);
        }
    }

    protected void setExceptionHandler() {
        Thread.UncaughtExceptionHandler handler = null;
        String handlerClass = System.getProperty("qpid.broker.exceptionHandler");
        if (handlerClass != null) {
            try {
                handler = (Thread.UncaughtExceptionHandler)Class.forName(handlerClass).newInstance();
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (handler == null) {
            handler = new Thread.UncaughtExceptionHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void uncaughtException(Thread t, Throwable e) {
                    boolean continueOnError = Boolean.getBoolean("qpid.broker.exceptionHandler.continue");
                    try {
                        System.err.println("########################################################################");
                        System.err.println("#");
                        System.err.print("# Unhandled Exception ");
                        System.err.print(e.toString());
                        System.err.print(" in Thread ");
                        System.err.println(t.getName());
                        System.err.println("#");
                        System.err.println(continueOnError ? "# Forced to continue by JVM setting 'qpid.broker.exceptionHandler.continue'" : "# Exiting");
                        System.err.println("#");
                        System.err.println("########################################################################");
                        e.printStackTrace(System.err);
                        Logger logger = Logger.getLogger((String)"org.apache.qpid.server.Main");
                        logger.error((Object)("Uncaught exception, " + (continueOnError ? "continuing." : "shutting down.")), e);
                    }
                    finally {
                        if (!continueOnError) {
                            Runtime.getRuntime().halt(1);
                        }
                    }
                }
            };
            Thread.setDefaultUncaughtExceptionHandler(handler);
        }
    }

    protected void startBroker(BrokerOptions options) throws Exception {
        Broker broker = new Broker();
        broker.startup(options);
    }

    protected void shutdown(int status) {
        ApplicationRegistry.remove();
        System.exit(status);
    }

    private static void parsePortArray(BrokerOptions options, Object[] ports, boolean ssl) throws Broker.InitException {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                try {
                    if (ssl) {
                        options.addSSLPort(Integer.parseInt(String.valueOf(ports[i])));
                        continue;
                    }
                    options.addPort(Integer.parseInt(String.valueOf(ports[i])));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Broker.InitException("Invalid port: " + ports[i], e);
                }
            }
        }
    }

    private static void parsePortArray(BrokerOptions options, Object[] ports, ProtocolExclusion excludedProtocol) throws Broker.InitException {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                try {
                    options.addExcludedPort(excludedProtocol, Integer.parseInt(String.valueOf(ports[i])));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Broker.InitException("Invalid port for exclusion: " + ports[i], e);
                }
            }
        }
    }

    private static void parseProtocolInclusions(BrokerOptions options, Object[] ports, ProtocolInclusion includedProtocol) throws Broker.InitException {
        if (ports != null) {
            for (int i = 0; i < ports.length; ++i) {
                try {
                    options.addIncludedPort(includedProtocol, Integer.parseInt(String.valueOf(ports[i])));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new Broker.InitException("Invalid port for inclusion: " + ports[i], e);
                }
            }
        }
    }

    static {
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use given configuration file");
        OptionBuilder.withLongOpt((String)"config");
        OPTION_CONFIG_FILE = OptionBuilder.create((String)"c");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"port");
        OPTION_PORT = OptionBuilder.create((String)"p");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"SSL port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"sslport");
        OPTION_SSLPORT = OptionBuilder.create((String)"s");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP1-0 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-1-0");
        OPTION_EXCLUDE_1_0 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-10 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-10");
        OPTION_EXCLUDE_0_10 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-9-1 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-9-1");
        OPTION_EXCLUDE_0_9_1 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-9 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-9");
        OPTION_EXCLUDE_0_9 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"when listening on the specified port do not accept AMQP0-8 connections. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"exclude-0-8");
        OPTION_EXCLUDE_0_8 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"accept AMQP1-0 connections on this port, overriding configuration to the contrary. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"include-1-0");
        OPTION_INCLUDE_1_0 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"accept AMQP0-10 connections on this port, overriding configuration to the contrary. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"include-0-10");
        OPTION_INCLUDE_0_10 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"accept AMQP0-9-1 connections on this port, overriding configuration to the contrary. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"include-0-9-1");
        OPTION_INCLUDE_0_9_1 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"accept AMQP0-9 connections on this port, overriding configuration to the contrary. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"include-0-9");
        OPTION_INCLUDE_0_9 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"accept AMQP0-8 connections on this port, overriding configuration to the contrary. The specified port must be one specified on the command line");
        OptionBuilder.withLongOpt((String)"include-0-8");
        OPTION_INCLUDE_0_8 = OptionBuilder.create();
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified management (registry server) port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"jmxregistryport");
        OPTION_JMX_PORT_REGISTRY_SERVER = OptionBuilder.create((String)"m");
        OptionBuilder.withArgName((String)"port");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"listen on the specified management (connector server) port. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"jmxconnectorport");
        OPTION_JMX_PORT_CONNECTOR_SERVER = OptionBuilder.create();
        OptionBuilder.withArgName((String)"address");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"bind to the specified address. Overrides any value in the config file");
        OptionBuilder.withLongOpt((String)"bind");
        OPTION_BIND = OptionBuilder.create((String)"b");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use the specified log4j xml configuration file. By default looks for a file named etc/log4j.xml in the same directory as the configuration file");
        OptionBuilder.withLongOpt((String)"logconfig");
        OPTION_LOG_CONFIG_FILE = OptionBuilder.create((String)"l");
        OptionBuilder.withArgName((String)"period");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"monitor the log file configuration file for changes. Units are seconds. Zero means do not check for changes.");
        OptionBuilder.withLongOpt((String)"logwatch");
        OPTION_LOG_WATCH = OptionBuilder.create((String)"w");
        OPTIONS = new Options();
        OPTIONS.addOption(OPTION_HELP);
        OPTIONS.addOption(OPTION_VERSION);
        OPTIONS.addOption(OPTION_CONFIG_FILE);
        OPTIONS.addOption(OPTION_LOG_CONFIG_FILE);
        OPTIONS.addOption(OPTION_LOG_WATCH);
        OPTIONS.addOption(OPTION_PORT);
        OPTIONS.addOption(OPTION_SSLPORT);
        OPTIONS.addOption(OPTION_EXCLUDE_1_0);
        OPTIONS.addOption(OPTION_EXCLUDE_0_10);
        OPTIONS.addOption(OPTION_EXCLUDE_0_9_1);
        OPTIONS.addOption(OPTION_EXCLUDE_0_9);
        OPTIONS.addOption(OPTION_EXCLUDE_0_8);
        OPTIONS.addOption(OPTION_INCLUDE_1_0);
        OPTIONS.addOption(OPTION_INCLUDE_0_10);
        OPTIONS.addOption(OPTION_INCLUDE_0_9_1);
        OPTIONS.addOption(OPTION_INCLUDE_0_9);
        OPTIONS.addOption(OPTION_INCLUDE_0_8);
        OPTIONS.addOption(OPTION_BIND);
        OPTIONS.addOption(OPTION_JMX_PORT_REGISTRY_SERVER);
        OPTIONS.addOption(OPTION_JMX_PORT_CONNECTOR_SERVER);
    }
}

