/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server;

import org.apache.log4j.Logger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogMessage;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.logging.actors.CurrentActor;

public class TransactionTimeoutHelper {
    private static final Logger LOGGER = Logger.getLogger(TransactionTimeoutHelper.class);
    public static final String IDLE_TRANSACTION_ALERT = "IDLE TRANSACTION ALERT";
    public static final String OPEN_TRANSACTION_ALERT = "OPEN TRANSACTION ALERT";
    private final LogSubject _logSubject;

    public TransactionTimeoutHelper(LogSubject logSubject) {
        this._logSubject = logSubject;
    }

    public void logIfNecessary(long timeSoFar, long warnTimeout, LogMessage message, String alternateLogPrefix) {
        if (this.isTimedOut(timeSoFar, warnTimeout)) {
            LogActor logActor = CurrentActor.get();
            if (logActor.getRootMessageLogger().isMessageEnabled(logActor, this._logSubject, message.getLogHierarchy())) {
                logActor.message(this._logSubject, message);
            } else {
                LOGGER.warn((Object)(alternateLogPrefix + " " + this._logSubject.toLogString() + " " + timeSoFar + " ms"));
            }
        }
    }

    public boolean isTimedOut(long timeSoFar, long timeout) {
        return timeout > 0L && timeSoFar > timeout;
    }
}

