/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.plugins.AbstractConfiguration;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.store.MemoryMessageStore;

public class VirtualHostConfiguration
extends AbstractConfiguration {
    private final String _name;
    private final Map<String, QueueConfiguration> _queues = new HashMap<String, QueueConfiguration>();
    private final Map<String, ExchangeConfiguration> _exchanges = new HashMap<String, ExchangeConfiguration>();

    public VirtualHostConfiguration(String name, Configuration config) throws ConfigurationException {
        this._name = name;
        this.setConfiguration(config);
    }

    public void setConfiguration(Configuration config) throws ConfigurationException {
        this.setConfiguration("virtualhosts.virtualhost", config);
        for (String queueName : this.getListValue("queues.queue.name")) {
            this._queues.put(queueName, new QueueConfiguration(queueName, this));
        }
        Iterator i = this.getListValue("exchanges.exchange.name").iterator();
        int count = 0;
        while (i.hasNext()) {
            CompositeConfiguration mungedConf = new CompositeConfiguration();
            mungedConf.addConfiguration(config.subset("exchanges.exchange(" + count++ + ")"));
            mungedConf.addConfiguration(this.getConfig().subset("exchanges"));
            String exchName = (String)i.next();
            this._exchanges.put(exchName, new ExchangeConfiguration(exchName, (Configuration)mungedConf));
        }
    }

    public String getName() {
        return this._name;
    }

    public long getHousekeepingCheckPeriod() {
        return this.getLongValue("housekeeping.checkPeriod", ApplicationRegistry.getInstance().getConfiguration().getHousekeepingCheckPeriod());
    }

    public Configuration getStoreConfiguration() {
        return this.getConfig().subset("store");
    }

    public String getMessageStoreClass() {
        return this.getStringValue("store.class", MemoryMessageStore.class.getName());
    }

    public void setMessageStoreClass(String storeFactoryClass) {
        this.getConfig().setProperty("store.class", (Object)storeFactoryClass);
    }

    public List getExchanges() {
        return this.getListValue("exchanges.exchange.name");
    }

    public String[] getQueueNames() {
        return this._queues.keySet().toArray(new String[this._queues.size()]);
    }

    public ExchangeConfiguration getExchangeConfiguration(String exchangeName) {
        return this._exchanges.get(exchangeName);
    }

    public QueueConfiguration getQueueConfiguration(String queueName) {
        if (this._queues.containsKey(queueName)) {
            return this._queues.get(queueName);
        }
        try {
            return new QueueConfiguration(queueName, this);
        }
        catch (ConfigurationException e) {
            return null;
        }
    }

    public int getMaximumMessageAge() {
        return this.getIntValue("queues.maximumMessageAge");
    }

    public Long getMaximumQueueDepth() {
        return this.getLongValue("queues.maximumQueueDepth");
    }

    public Long getMaximumMessageSize() {
        return this.getLongValue("queues.maximumMessageSize");
    }

    public Long getMaximumMessageCount() {
        return this.getLongValue("queues.maximumMessageCount");
    }

    public Long getMinimumAlertRepeatGap() {
        return this.getLongValue("queues.minimumAlertRepeatGap", ApplicationRegistry.getInstance().getConfiguration().getMinimumAlertRepeatGap());
    }

    public long getCapacity() {
        return this.getLongValue("queues.capacity");
    }

    public long getFlowResumeCapacity() {
        return this.getLongValue("queues.flowResumeCapacity", this.getCapacity());
    }

    public String[] getElementsProcessed() {
        return new String[]{"queues", "exchanges", "custom-exchanges", "store", "housekeeping"};
    }

    public void validateConfiguration() throws ConfigurationException {
        if (this.getListValue("security.authentication.name").size() > 0) {
            String message = "Validation error : security/authentication/name is no longer a supported element within the configuration xml. It appears in virtual host definition : " + this._name;
            throw new ConfigurationException(message);
        }
        if (this.contains("housekeeping.expiredMessageCheckPeriod")) {
            String message = "Validation error : housekeeping/expiredMessageCheckPeriod must be replaced by housekeeping/checkPeriod. It appears in virtual host definition : " + this._name;
            throw new ConfigurationException(message);
        }
    }

    public int getHouseKeepingThreadCount() {
        return this.getIntValue("housekeeping.poolSize", Runtime.getRuntime().availableProcessors());
    }

    public long getTransactionTimeoutOpenWarn() {
        return this.getLongValue("transactionTimeout.openWarn", 0L);
    }

    public long getTransactionTimeoutOpenClose() {
        return this.getLongValue("transactionTimeout.openClose", 0L);
    }

    public long getTransactionTimeoutIdleWarn() {
        return this.getLongValue("transactionTimeout.idleWarn", 0L);
    }

    public long getTransactionTimeoutIdleClose() {
        return this.getLongValue("transactionTimeout.idleClose", 0L);
    }

    public int getMaxDeliveryCount() {
        return this.getIntValue("queues.maximumDeliveryCount", ApplicationRegistry.getInstance().getConfiguration().getMaxDeliveryCount());
    }

    public boolean isDeadLetterQueueEnabled() {
        return this.getBooleanValue("queues.deadLetterQueues", ApplicationRegistry.getInstance().getConfiguration().isDeadLetterQueueEnabled());
    }
}

