/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.configuration.plugins;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;

public abstract class AbstractConfiguration {
    protected static final Logger _logger = Logger.getLogger(AbstractConfiguration.class);
    private Configuration _config;

    public abstract String[] getElementsProcessed();

    public void validateConfiguration() throws ConfigurationException {
    }

    public Configuration getConfig() {
        return this._config;
    }

    public void setConfiguration(String path, Configuration configuration) throws ConfigurationException {
        this._config = configuration;
        Iterator keys = configuration.getKeys();
        HashSet<String> elements = new HashSet<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            int elementNameIndex = key.indexOf(".");
            String element = key.trim();
            if (elementNameIndex != -1) {
                element = key.substring(0, elementNameIndex).trim();
            }
            if ((elementNameIndex = element.indexOf("[")) > 0) {
                element = element.substring(0, elementNameIndex).trim();
            }
            elements.add(element);
        }
        for (String tag : this.getElementsProcessed()) {
            int bracketIndex = tag.indexOf("[");
            if (bracketIndex != -1) {
                tag = tag.substring(bracketIndex + 1, tag.length());
            }
            elements.remove(tag);
        }
        if (_logger.isInfoEnabled() && !elements.isEmpty()) {
            _logger.info((Object)("Elements to lookup:" + path));
            for (String tag : elements) {
                _logger.info((Object)("Tag:'" + tag + "'"));
            }
        }
        this.validateConfiguration();
    }

    public static final void showKeys(Configuration config) {
        if (config.isEmpty()) {
            _logger.info((Object)"Configuration is empty");
        } else {
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                _logger.info((Object)("Configuration key: " + key));
            }
        }
    }

    protected boolean hasConfiguration() {
        return this._config != null;
    }

    protected double getDoubleValue(String property) {
        return this.getDoubleValue(property, 0.0);
    }

    protected double getDoubleValue(String property, double defaultValue) {
        return this._config.getDouble(property, defaultValue);
    }

    protected long getLongValue(String property) {
        return this.getLongValue(property, 0L);
    }

    protected long getLongValue(String property, long defaultValue) {
        return this._config.getLong(property, defaultValue);
    }

    protected int getIntValue(String property) {
        return this.getIntValue(property, 0);
    }

    protected int getIntValue(String property, int defaultValue) {
        return this._config.getInt(property, defaultValue);
    }

    protected String getStringValue(String property) {
        return this.getStringValue(property, null);
    }

    protected String getStringValue(String property, String defaultValue) {
        return this._config.getString(property, defaultValue);
    }

    protected boolean getBooleanValue(String property) {
        return this.getBooleanValue(property, false);
    }

    protected boolean getBooleanValue(String property, boolean defaultValue) {
        return this._config.getBoolean(property, defaultValue);
    }

    protected List getListValue(String property) {
        return this.getListValue(property, Collections.EMPTY_LIST);
    }

    protected List getListValue(String property, List defaultValue) {
        return this._config.getList(property, defaultValue);
    }

    protected boolean contains(String property) {
        return this._config.getProperty(property) != null;
    }

    protected void validatePositiveLong(String property) throws ConfigurationException {
        try {
            if (!this.containsPositiveLong(property)) {
                throw new ConfigurationException(this.getClass().getSimpleName() + ": '" + property + "' must be a Positive Long value.");
            }
        }
        catch (Exception e) {
            Throwable last = e;
            if (e instanceof ConversionException) {
                Throwable t = e.getCause();
                while (t != null) {
                    last = t;
                    t = last.getCause();
                }
            }
            throw new ConfigurationException(this.getClass().getSimpleName() + ": unable to configure invalid " + property + ":" + this._config.getString(property), last);
        }
    }

    protected boolean containsLong(String property) {
        try {
            this._config.getLong(property);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected boolean containsPositiveLong(String property) {
        try {
            long value = this._config.getLong(property);
            return value > 0L;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected boolean containsInt(String property) {
        try {
            this._config.getInt(property);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    protected boolean containsBoolean(String property) {
        try {
            this._config.getBoolean(property);
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public String escapeTagName(String name) {
        return name.replaceAll("\\.", "\\.\\.");
    }

    protected void setConfig(Configuration config) {
        this._config = config;
    }
}

