/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.AMQUnknownExchangeType;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExchangeFactory
implements ExchangeFactory {
    public static final String DEFAULT_DLE_NAME_SUFFIX = "_DLE";
    private static final Logger LOGGER = Logger.getLogger(DefaultExchangeFactory.class);
    private static final AMQShortString[] BASE_EXCHANGE_TYPES = new AMQShortString[]{ExchangeDefaults.DIRECT_EXCHANGE_CLASS, ExchangeDefaults.FANOUT_EXCHANGE_CLASS, ExchangeDefaults.HEADERS_EXCHANGE_CLASS, ExchangeDefaults.TOPIC_EXCHANGE_CLASS};
    private final VirtualHost _host;
    private Map<AMQShortString, ExchangeType<? extends Exchange>> _exchangeClassMap = new HashMap<AMQShortString, ExchangeType<? extends Exchange>>();

    public DefaultExchangeFactory(VirtualHost host) {
        this._host = host;
        Iterable<ExchangeType> exchangeTypes = this.loadExchangeTypes();
        for (ExchangeType exchangeType : exchangeTypes) {
            AMQShortString typeName = exchangeType.getName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Registering exchange type '" + typeName + "' using class '" + exchangeType.getClass().getName() + "'"));
            }
            if (this._exchangeClassMap.containsKey(typeName)) {
                ExchangeType<? extends Exchange> existingType = this._exchangeClassMap.get(typeName);
                throw new IllegalStateException("ExchangeType with type name '" + typeName + "' is already registered using class '" + existingType.getClass().getName() + "', can not register class '" + exchangeType.getClass().getName() + "'");
            }
            this._exchangeClassMap.put(typeName, exchangeType);
        }
        for (AMQShortString type : BASE_EXCHANGE_TYPES) {
            if (this._exchangeClassMap.containsKey(type)) continue;
            throw new IllegalStateException("Did not find expected exchange type: " + type.asString());
        }
    }

    protected Iterable<ExchangeType> loadExchangeTypes() {
        return new QpidServiceLoader<ExchangeType>().atLeastOneInstanceOf(ExchangeType.class);
    }

    @Override
    public Collection<ExchangeType<? extends Exchange>> getRegisteredTypes() {
        return this._exchangeClassMap.values();
    }

    @Override
    public Collection<ExchangeType<? extends Exchange>> getPublicCreatableTypes() {
        ArrayList<ExchangeType<? extends Exchange>> publicTypes = new ArrayList<ExchangeType<? extends Exchange>>();
        publicTypes.addAll(this._exchangeClassMap.values());
        return publicTypes;
    }

    @Override
    public Exchange createExchange(String exchange, String type, boolean durable, boolean autoDelete) throws AMQException {
        return this.createExchange(new AMQShortString(exchange), new AMQShortString(type), durable, autoDelete, 0);
    }

    @Override
    public Exchange createExchange(UUID id, String exchange, String type, boolean durable, boolean autoDelete) throws AMQException {
        return this.createExchange(id, new AMQShortString(exchange), new AMQShortString(type), durable, autoDelete, 0);
    }

    @Override
    public Exchange createExchange(AMQShortString exchange, AMQShortString type, boolean durable, boolean autoDelete, int ticket) throws AMQException {
        UUID id = UUIDGenerator.generateExchangeUUID(exchange.asString(), this._host.getName());
        return this.createExchange(id, exchange, type, durable, autoDelete, ticket);
    }

    @Override
    public Exchange createExchange(UUID id, AMQShortString exchange, AMQShortString type, boolean durable, boolean autoDelete, int ticket) throws AMQException {
        if (!this._host.getSecurityManager().authoriseCreateExchange(autoDelete, durable, exchange, null, null, null, type)) {
            String description = "Permission denied: exchange-name '" + exchange.asString() + "'";
            throw new AMQSecurityException(description);
        }
        ExchangeType<? extends Exchange> exchType = this._exchangeClassMap.get(type);
        if (exchType == null) {
            throw new AMQUnknownExchangeType("Unknown exchange type: " + type, null);
        }
        Exchange e = exchType.newInstance(id, this._host, exchange, durable, ticket, autoDelete);
        return e;
    }
}

