/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.exchange;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQInvalidArgumentException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.filter.SelectorParsingException;
import org.apache.qpid.filter.selector.ParseException;
import org.apache.qpid.filter.selector.TokenMgrError;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.AbstractExchange;
import org.apache.qpid.server.exchange.TopicExchangeType;
import org.apache.qpid.server.exchange.topic.TopicExchangeResult;
import org.apache.qpid.server.exchange.topic.TopicMatcherResult;
import org.apache.qpid.server.exchange.topic.TopicNormalizer;
import org.apache.qpid.server.exchange.topic.TopicParser;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.MessageFilter;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.plugin.ExchangeType;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.queue.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicExchange
extends AbstractExchange {
    public static final ExchangeType<TopicExchange> TYPE = new TopicExchangeType();
    private static final Logger _logger = Logger.getLogger(TopicExchange.class);
    private final TopicParser _parser = new TopicParser();
    private final Map<AMQShortString, TopicExchangeResult> _topicExchangeResults = new ConcurrentHashMap<AMQShortString, TopicExchangeResult>();
    private final Map<Binding, FieldTable> _bindings = new HashMap<Binding, FieldTable>();
    private final Map<String, WeakReference<JMSSelectorFilter>> _selectorCache = new WeakHashMap<String, WeakReference<JMSSelectorFilter>>();

    public TopicExchange() {
        super(TYPE);
    }

    protected synchronized void registerQueue(Binding binding) throws AMQInvalidArgumentException {
        AMQShortString rKey = new AMQShortString(binding.getBindingKey());
        AMQQueue queue = binding.getQueue();
        FieldTable args = FieldTable.convertToFieldTable(binding.getArguments());
        assert (queue != null);
        assert (rKey != null);
        _logger.debug((Object)("Registering queue " + queue.getNameShortString() + " with routing key " + rKey));
        AMQShortString routingKey = TopicNormalizer.normalize(rKey);
        if (this._bindings.containsKey(binding)) {
            FieldTable oldArgs = this._bindings.get(binding);
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (TopicExchange.argumentsContainFilter(args)) {
                if (TopicExchange.argumentsContainFilter(oldArgs)) {
                    result.replaceQueueFilter(queue, this.createMessageFilter(oldArgs, queue), this.createMessageFilter(args, queue));
                } else {
                    result.addFilteredQueue(queue, this.createMessageFilter(args, queue));
                    result.removeUnfilteredQueue(queue);
                }
            } else if (TopicExchange.argumentsContainFilter(oldArgs)) {
                result.addUnfilteredQueue(queue);
                result.removeFilteredQueue(queue, this.createMessageFilter(oldArgs, queue));
            } else {
                return;
            }
            result.addBinding(binding);
        } else {
            TopicExchangeResult result = this._topicExchangeResults.get(routingKey);
            if (result == null) {
                result = new TopicExchangeResult();
                if (TopicExchange.argumentsContainFilter(args)) {
                    result.addFilteredQueue(queue, this.createMessageFilter(args, queue));
                } else {
                    result.addUnfilteredQueue(queue);
                }
                this._parser.addBinding(routingKey, result);
                this._topicExchangeResults.put(routingKey, result);
            } else if (TopicExchange.argumentsContainFilter(args)) {
                result.addFilteredQueue(queue, this.createMessageFilter(args, queue));
            } else {
                result.addUnfilteredQueue(queue);
            }
            result.addBinding(binding);
            this._bindings.put(binding, args);
        }
    }

    private MessageFilter createMessageFilter(FieldTable args, AMQQueue queue) throws AMQInvalidArgumentException {
        if (TopicExchange.argumentsContainNoLocal(args)) {
            MessageFilter filter = new NoLocalFilter(queue);
            if (TopicExchange.argumentsContainJMSSelector(args)) {
                filter = new CompoundFilter(filter, this.createJMSSelectorFilter(args));
            }
            return filter;
        }
        return this.createJMSSelectorFilter(args);
    }

    private MessageFilter createJMSSelectorFilter(FieldTable args) throws AMQInvalidArgumentException {
        String selectorString = args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue());
        WeakReference<JMSSelectorFilter> selectorRef = this._selectorCache.get(selectorString);
        JMSSelectorFilter selector = null;
        if (selectorRef == null || (selector = (JMSSelectorFilter)selectorRef.get()) == null) {
            try {
                selector = new JMSSelectorFilter(selectorString);
            }
            catch (ParseException e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", (Throwable)e);
            }
            catch (SelectorParsingException e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", (Throwable)e);
            }
            catch (TokenMgrError e) {
                throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + selectorString + "\"", (Throwable)e);
            }
            this._selectorCache.put(selectorString, new WeakReference<JMSSelectorFilter>(selector));
        }
        return selector;
    }

    private static boolean argumentsContainFilter(FieldTable args) {
        return TopicExchange.argumentsContainNoLocal(args) || TopicExchange.argumentsContainJMSSelector(args);
    }

    private static boolean argumentsContainNoLocal(FieldTable args) {
        return args != null && args.containsKey(AMQPFilterTypes.NO_LOCAL.getValue()) && Boolean.TRUE.equals(args.get(AMQPFilterTypes.NO_LOCAL.getValue()));
    }

    private static boolean argumentsContainJMSSelector(FieldTable args) {
        return args != null && args.containsKey(AMQPFilterTypes.JMS_SELECTOR.getValue()) && args.getString(AMQPFilterTypes.JMS_SELECTOR.getValue()).trim().length() != 0;
    }

    public ArrayList<BaseQueue> doRoute(InboundMessage payload) {
        ArrayList<BaseQueue> queues;
        AMQShortString routingKey = payload.getRoutingKeyShortString() == null ? AMQShortString.EMPTY_STRING : payload.getRoutingKeyShortString();
        Collection<AMQQueue> matchedQueues = this.getMatchedQueues(payload, routingKey);
        if (matchedQueues.getClass() == ArrayList.class) {
            queues = (ArrayList<BaseQueue>)matchedQueues;
        } else {
            queues = new ArrayList<BaseQueue>();
            queues.addAll(matchedQueues);
        }
        if (queues == null || queues.isEmpty()) {
            _logger.info((Object)("Message routing key: " + payload.getRoutingKey() + " No routes."));
        }
        return queues;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, FieldTable arguments, AMQQueue queue) {
        Binding binding = new Binding(null, routingKey.toString(), queue, this, FieldTable.convertToMap((FieldTable)arguments));
        if (arguments == null) {
            return this._bindings.containsKey(binding);
        }
        FieldTable o = this._bindings.get(binding);
        if (o != null) {
            return o.equals((Object)arguments);
        }
        return false;
    }

    @Override
    public boolean isBound(String bindingKey, Map<String, Object> arguments, AMQQueue queue) {
        Binding binding = new Binding(null, bindingKey, queue, this, arguments);
        if (arguments == null) {
            return this._bindings.containsKey(binding);
        }
        FieldTable o = this._bindings.get(binding);
        if (o != null) {
            return ((Object)arguments).equals(FieldTable.convertToMap((FieldTable)o));
        }
        return false;
    }

    @Override
    public boolean isBound(AMQShortString routingKey, AMQQueue queue) {
        return this.isBound(routingKey, null, queue);
    }

    @Override
    public boolean isBound(AMQShortString routingKey) {
        for (Binding b : this._bindings.keySet()) {
            if (!b.getBindingKey().equals(routingKey.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBound(AMQQueue queue) {
        for (Binding b : this._bindings.keySet()) {
            if (!b.getQueue().equals(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasBindings() {
        return !this._bindings.isEmpty();
    }

    private boolean deregisterQueue(Binding binding) {
        if (this._bindings.containsKey(binding)) {
            FieldTable bindingArgs = this._bindings.remove(binding);
            AMQShortString bindingKey = TopicNormalizer.normalize(new AMQShortString(binding.getBindingKey()));
            TopicExchangeResult result = this._topicExchangeResults.get(bindingKey);
            result.removeBinding(binding);
            if (TopicExchange.argumentsContainFilter(bindingArgs)) {
                try {
                    result.removeFilteredQueue(binding.getQueue(), this.createMessageFilter(bindingArgs, binding.getQueue()));
                }
                catch (AMQInvalidArgumentException e) {
                    return false;
                }
            } else {
                result.removeUnfilteredQueue(binding.getQueue());
            }
            return true;
        }
        return false;
    }

    private Collection<AMQQueue> getMatchedQueues(InboundMessage message, AMQShortString routingKey) {
        Collection<TopicMatcherResult> results = this._parser.parse(routingKey);
        switch (results.size()) {
            case 0: {
                return Collections.EMPTY_SET;
            }
            case 1: {
                TopicMatcherResult[] resultQueues = new TopicMatcherResult[1];
                results.toArray(resultQueues);
                return ((TopicExchangeResult)resultQueues[0]).processMessage(message, null);
            }
        }
        Collection<AMQQueue> queues = new HashSet<AMQQueue>();
        for (TopicMatcherResult result : results) {
            TopicExchangeResult res = (TopicExchangeResult)result;
            for (Binding b : res.getBindings()) {
                b.incrementMatches();
            }
            queues = res.processMessage(message, queues);
        }
        return queues;
    }

    @Override
    protected void onBind(Binding binding) {
        try {
            this.registerQueue(binding);
        }
        catch (AMQInvalidArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void onUnbind(Binding binding) {
        this.deregisterQueue(binding);
    }

    private static final class CompoundFilter
    implements MessageFilter {
        private MessageFilter _noLocalFilter;
        private MessageFilter _jmsSelectorFilter;

        public CompoundFilter(MessageFilter filter, MessageFilter jmsSelectorFilter) {
            this._noLocalFilter = filter;
            this._jmsSelectorFilter = jmsSelectorFilter;
        }

        public boolean matches(Filterable message) {
            return this._noLocalFilter.matches(message) && this._jmsSelectorFilter.matches(message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompoundFilter that = (CompoundFilter)o;
            if (this._jmsSelectorFilter != null ? !this._jmsSelectorFilter.equals(that._jmsSelectorFilter) : that._jmsSelectorFilter != null) {
                return false;
            }
            return !(this._noLocalFilter != null ? !this._noLocalFilter.equals(that._noLocalFilter) : that._noLocalFilter != null);
        }

        public int hashCode() {
            int result = this._noLocalFilter != null ? this._noLocalFilter.hashCode() : 0;
            result = 31 * result + (this._jmsSelectorFilter != null ? this._jmsSelectorFilter.hashCode() : 0);
            return result;
        }
    }

    private static final class NoLocalFilter
    implements MessageFilter {
        private final AMQQueue _queue;

        public NoLocalFilter(AMQQueue queue) {
            this._queue = queue;
        }

        public boolean matches(Filterable message) {
            InboundMessage inbound = (InboundMessage)message;
            AMQSessionModel exclusiveOwningSession = this._queue.getExclusiveOwningSession();
            return exclusiveOwningSession == null || !exclusiveOwningSession.onSameConnection(inbound);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NoLocalFilter that = (NoLocalFilter)o;
            return this._queue == null ? that._queue == null : this._queue.equals(that._queue);
        }

        public int hashCode() {
            return this._queue != null ? this._queue.hashCode() : 0;
        }
    }
}

