/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.flow;

import org.apache.qpid.server.flow.AbstractFlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager;

public class Pre0_10CreditManager
extends AbstractFlowCreditManager
implements FlowCreditManager {
    private volatile long _bytesCreditLimit;
    private volatile long _messageCreditLimit;
    private volatile long _bytesCredit;
    private volatile long _messageCredit;

    public Pre0_10CreditManager(long bytesCreditLimit, long messageCreditLimit) {
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this._bytesCredit = bytesCreditLimit;
        this._messageCredit = messageCreditLimit;
    }

    public synchronized void setCreditLimits(long bytesCreditLimit, long messageCreditLimit) {
        long bytesCreditChange = bytesCreditLimit - this._bytesCreditLimit;
        long messageCreditChange = messageCreditLimit - this._messageCreditLimit;
        if (bytesCreditChange != 0L) {
            this._bytesCredit = bytesCreditLimit == 0L ? 0L : (this._bytesCredit += bytesCreditChange);
        }
        if (messageCreditChange != 0L) {
            this._messageCredit = messageCreditLimit == 0L ? 0L : (this._messageCredit += messageCreditChange);
        }
        this._bytesCreditLimit = bytesCreditLimit;
        this._messageCreditLimit = messageCreditLimit;
        this.setSuspended(!this.hasCredit());
    }

    public long getMessageCredit() {
        return this._messageCredit;
    }

    public long getBytesCredit() {
        return this._bytesCredit;
    }

    public synchronized void restoreCredit(long messageCredit, long bytesCredit) {
        long bytesCreditLimit;
        long messageCreditLimit = this._messageCreditLimit;
        boolean notifyIncrease = true;
        if (messageCreditLimit != 0L) {
            notifyIncrease = this._messageCredit != 0L;
            long newCredit = this._messageCredit + messageCredit;
            long l = this._messageCredit = newCredit > messageCreditLimit ? messageCreditLimit : newCredit;
        }
        if ((bytesCreditLimit = this._bytesCreditLimit) != 0L) {
            long newCredit = this._bytesCredit + bytesCredit;
            long l = this._bytesCredit = newCredit > bytesCreditLimit ? bytesCreditLimit : newCredit;
            if (notifyIncrease && bytesCredit > 0L) {
                this.notifyIncreaseBytesCredit();
            }
        }
        this.setSuspended(!this.hasCredit());
    }

    public synchronized void removeAllCredit() {
        this._bytesCredit = 0L;
        this._messageCredit = 0L;
        this.setSuspended(!this.hasCredit());
    }

    public synchronized boolean hasCredit() {
        return !(this._bytesCreditLimit != 0L && this._bytesCredit <= 0L || this._messageCreditLimit != 0L && this._messageCredit <= 0L);
    }

    public synchronized boolean useCreditForMessage(long msgSize) {
        if (this._messageCreditLimit != 0L) {
            if (this._messageCredit != 0L) {
                if (this._bytesCreditLimit == 0L) {
                    --this._messageCredit;
                    return true;
                }
                if (this._bytesCredit >= msgSize || this._bytesCredit == this._bytesCreditLimit) {
                    --this._messageCredit;
                    this._bytesCredit -= msgSize;
                    return true;
                }
                return false;
            }
            this.setSuspended(true);
            return false;
        }
        if (this._bytesCreditLimit == 0L) {
            return true;
        }
        if (this._bytesCredit >= msgSize || this._bytesCredit == this._bytesCreditLimit) {
            this._bytesCredit -= msgSize;
            return true;
        }
        return false;
    }
}

