/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.BasicGetBody;
import org.apache.qpid.framing.BasicGetEmptyBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.flow.MessageOnlyCreditManager;
import org.apache.qpid.server.message.AMQMessage;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.RecordDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionFactoryImpl;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGetMethodHandler
implements StateAwareMethodListener<BasicGetBody> {
    private static final Logger _log = Logger.getLogger(BasicGetMethodHandler.class);
    private static final BasicGetMethodHandler _instance = new BasicGetMethodHandler();

    public static BasicGetMethodHandler getInstance() {
        return _instance;
    }

    private BasicGetMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, BasicGetBody body, int channelId) throws AMQException {
        AMQSessionModel session;
        AMQQueue queue;
        AMQProtocolSession protocolConnection = stateManager.getProtocolSession();
        VirtualHost vHost = protocolConnection.getVirtualHost();
        AMQChannel channel = protocolConnection.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        AMQQueue aMQQueue = queue = body.getQueue() == null ? channel.getDefaultQueue() : vHost.getQueueRegistry().getQueue(body.getQueue());
        if (queue == null) {
            _log.info((Object)("No queue for '" + body.getQueue() + "'"));
            if (body.getQueue() != null) {
                throw body.getConnectionException(AMQConstant.NOT_FOUND, "No such queue, '" + body.getQueue() + "'");
            }
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "No queue name provided, no default queue defined.");
        }
        if (queue.isExclusive() && ((session = queue.getExclusiveOwningSession()) == null || session.getConnectionModel() != protocolConnection)) {
            throw body.getConnectionException(AMQConstant.NOT_ALLOWED, "Queue is exclusive, but not created on this Connection.");
        }
        if (!BasicGetMethodHandler.performGet(queue, protocolConnection, channel, !body.getNoAck())) {
            MethodRegistry methodRegistry = protocolConnection.getMethodRegistry();
            BasicGetEmptyBody responseBody = methodRegistry.createBasicGetEmptyBody(null);
            protocolConnection.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        }
    }

    public static boolean performGet(final AMQQueue queue, final AMQProtocolSession session, final AMQChannel channel, boolean acks) throws AMQException {
        final MessageOnlyCreditManager singleMessageCredit = new MessageOnlyCreditManager(1L);
        ClientDeliveryMethod getDeliveryMethod = new ClientDeliveryMethod(){

            public void deliverToClient(Subscription sub, QueueEntry entry, long deliveryTag) throws AMQException {
                singleMessageCredit.useCreditForMessage(entry.getMessage().getSize());
                if (!(entry.getMessage() instanceof AMQMessage)) {
                    throw new AMQException(AMQConstant.NOT_IMPLEMENTED, "Not implemented conversion of 0-10 message", null);
                }
                session.getProtocolOutputConverter().writeGetOk(entry, channel.getChannelId(), deliveryTag, queue.getMessageCount());
                entry.incrementDeliveryCount();
            }
        };
        RecordDeliveryMethod getRecordMethod = new RecordDeliveryMethod(){

            public void recordMessageDelivery(Subscription sub, QueueEntry entry, long deliveryTag) {
                channel.addUnacknowledgedMessage(entry, deliveryTag, null);
            }
        };
        Subscription sub = acks ? SubscriptionFactoryImpl.INSTANCE.createSubscription(channel, session, null, acks, null, false, singleMessageCredit, getDeliveryMethod, getRecordMethod) : SubscriptionFactoryImpl.INSTANCE.createBasicGetNoAckSubscription(channel, session, null, null, false, singleMessageCredit, getDeliveryMethod, getRecordMethod);
        queue.registerSubscription(sub, false);
        queue.flushSubscription(sub);
        queue.unregisterSubscription(sub);
        return !singleMessageCredit.hasCredit();
    }
}

