/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionCloseOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionCloseMethodHandler
implements StateAwareMethodListener<ConnectionCloseBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionCloseMethodHandler.class);
    private static ConnectionCloseMethodHandler _instance = new ConnectionCloseMethodHandler();

    public static ConnectionCloseMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionCloseMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionCloseBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("ConnectionClose received with reply code/reply text " + body.getReplyCode() + "/" + body.getReplyText() + " for " + session));
        }
        try {
            session.closeSession();
        }
        catch (Exception e) {
            _logger.error((Object)("Error closing protocol session: " + e), (Throwable)e);
        }
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ConnectionCloseOkBody responseBody = methodRegistry.createConnectionCloseOkBody();
        session.writeFrame((AMQDataBlock)responseBody.generateFrame(channelId));
        session.closeProtocolSession();
    }
}

