/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.ConnectionCloseBody;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.ConnectionSecureOkBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.handler.ConnectionStartOkMethodHandler;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.state.AMQState;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionSecureOkMethodHandler
implements StateAwareMethodListener<ConnectionSecureOkBody> {
    private static final Logger _logger = Logger.getLogger(ConnectionSecureOkMethodHandler.class);
    private static ConnectionSecureOkMethodHandler _instance = new ConnectionSecureOkMethodHandler();

    public static ConnectionSecureOkMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionSecureOkMethodHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ConnectionSecureOkBody body, int channelId) throws AMQException {
        AMQProtocolSession session = stateManager.getProtocolSession();
        SubjectCreator subjectCreator = stateManager.getSubjectCreator();
        SaslServer ss = session.getSaslServer();
        if (ss == null) {
            throw new AMQException("No SASL context set up in session");
        }
        MethodRegistry methodRegistry = session.getMethodRegistry();
        SubjectAuthenticationResult authResult = subjectCreator.authenticate(ss, body.getResponse());
        switch (authResult.getStatus()) {
            case ERROR: {
                Exception cause = authResult.getCause();
                _logger.info((Object)("Authentication failed:" + (cause == null ? "" : cause.getMessage())));
                stateManager.changeState(AMQState.CONNECTION_CLOSING);
                ConnectionCloseBody connectionCloseBody = methodRegistry.createConnectionCloseBody(AMQConstant.NOT_ALLOWED.getCode(), AMQConstant.NOT_ALLOWED.getName(), body.getClazz(), body.getMethod());
                session.writeFrame((AMQDataBlock)connectionCloseBody.generateFrame(0));
                this.disposeSaslServer(session);
                break;
            }
            case SUCCESS: {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Connected as: " + authResult.getSubject()));
                }
                stateManager.changeState(AMQState.CONNECTION_NOT_TUNED);
                ConnectionTuneBody tuneBody = methodRegistry.createConnectionTuneBody(ApplicationRegistry.getInstance().getConfiguration().getMaxChannelCount(), (long)ConnectionStartOkMethodHandler.getConfiguredFrameSize(), ApplicationRegistry.getInstance().getConfiguration().getHeartBeatDelay());
                session.writeFrame((AMQDataBlock)tuneBody.generateFrame(0));
                session.setAuthorizedSubject(authResult.getSubject());
                this.disposeSaslServer(session);
                break;
            }
            case CONTINUE: {
                stateManager.changeState(AMQState.CONNECTION_NOT_AUTH);
                ConnectionSecureBody secureBody = methodRegistry.createConnectionSecureBody(authResult.getChallenge());
                session.writeFrame((AMQDataBlock)secureBody.generateFrame(0));
            }
        }
    }

    private void disposeSaslServer(AMQProtocolSession ps) {
        SaslServer ss = ps.getSaslServer();
        if (ss != null) {
            ps.setSaslServer(null);
            try {
                ss.dispose();
            }
            catch (SaslException e) {
                _logger.error((Object)("Error disposing of Sasl server: " + e));
            }
        }
    }
}

