/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.handler;

import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ExchangeBoundBody;
import org.apache.qpid.framing.ExchangeBoundOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.state.AMQStateManager;
import org.apache.qpid.server.state.StateAwareMethodListener;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExchangeBoundHandler
implements StateAwareMethodListener<ExchangeBoundBody> {
    private static final ExchangeBoundHandler _instance = new ExchangeBoundHandler();
    public static final int OK = 0;
    public static final int EXCHANGE_NOT_FOUND = 1;
    public static final int QUEUE_NOT_FOUND = 2;
    public static final int NO_BINDINGS = 3;
    public static final int QUEUE_NOT_BOUND = 4;
    public static final int NO_QUEUE_BOUND_WITH_RK = 5;
    public static final int SPECIFIC_QUEUE_NOT_BOUND_WITH_RK = 6;

    public static ExchangeBoundHandler getInstance() {
        return _instance;
    }

    private ExchangeBoundHandler() {
    }

    @Override
    public void methodReceived(AMQStateManager stateManager, ExchangeBoundBody body, int channelId) throws AMQException {
        AMQQueue queue;
        AMQProtocolSession session = stateManager.getProtocolSession();
        VirtualHost virtualHost = session.getVirtualHost();
        QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
        MethodRegistry methodRegistry = session.getMethodRegistry();
        AMQChannel channel = session.getChannel(channelId);
        if (channel == null) {
            throw body.getChannelNotFoundException(channelId);
        }
        channel.sync();
        AMQShortString exchangeName = body.getExchange();
        AMQShortString queueName = body.getQueue();
        AMQShortString routingKey = body.getRoutingKey();
        if (exchangeName == null) {
            throw new AMQException("Exchange exchange must not be null");
        }
        Exchange exchange = virtualHost.getExchangeRegistry().getExchange(exchangeName);
        ExchangeBoundOkBody response = exchange == null ? methodRegistry.createExchangeBoundOkBody(1, new AMQShortString("Exchange " + exchangeName + " not found")) : (routingKey == null ? (queueName == null ? (exchange.hasBindings() ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(3, null)) : ((queue = queueRegistry.getQueue(queueName)) == null ? methodRegistry.createExchangeBoundOkBody(2, new AMQShortString("Queue " + queueName + " not found")) : (exchange.isBound(queue) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(4, new AMQShortString("Queue " + queueName + " not bound to exchange " + exchangeName))))) : (queueName != null ? ((queue = queueRegistry.getQueue(queueName)) == null ? methodRegistry.createExchangeBoundOkBody(2, new AMQShortString("Queue " + queueName + " not found")) : (exchange.isBound(body.getRoutingKey(), queue) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(6, new AMQShortString("Queue " + queueName + " not bound with routing key " + body.getRoutingKey() + " to exchange " + exchangeName)))) : (exchange.isBound(body.getRoutingKey()) ? methodRegistry.createExchangeBoundOkBody(0, null) : methodRegistry.createExchangeBoundOkBody(5, new AMQShortString("No queue bound with routing key " + body.getRoutingKey() + " to exchange " + exchangeName)))));
        session.writeFrame((AMQDataBlock)response.generateFrame(channelId));
    }
}

