/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.actors;

import java.text.MessageFormat;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractManagementActor;

public class HttpManagementActor
extends AbstractManagementActor {
    private String _cachedLogString;
    private String _lastPrincipalName;
    private String _address;

    public HttpManagementActor(RootMessageLogger rootLogger, String ip, int port) {
        super(rootLogger, "N/A");
        this._address = ip + ":" + port;
    }

    private synchronized String getAndCacheLogString() {
        String principalName = this.getPrincipalName();
        if (!principalName.equals(this._lastPrincipalName)) {
            this._lastPrincipalName = principalName;
            this._cachedLogString = "[" + MessageFormat.format("mng:{0}({1})", principalName, this._address) + "] ";
        }
        return this._cachedLogString;
    }

    public String getLogMessage() {
        return this.getAndCacheLogString();
    }
}

