/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.log4j;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.qpid.server.logging.log4j.LoggingFacadeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingManagementFacade {
    private static Logger LOGGER;
    private static transient LoggingManagementFacade _instance;
    private final String _filename;
    private final int _delay;

    public static LoggingManagementFacade configure(String filename) throws LoggingFacadeException {
        _instance = new LoggingManagementFacade(filename);
        return _instance;
    }

    public static LoggingManagementFacade configureAndWatch(String filename, int delay) throws LoggingFacadeException {
        _instance = new LoggingManagementFacade(filename, delay);
        return _instance;
    }

    public static LoggingManagementFacade getCurrentInstance() {
        return _instance;
    }

    private LoggingManagementFacade(String filename) {
        DOMConfigurator.configure((String)filename);
        if (LOGGER == null) {
            LOGGER = Logger.getLogger(LoggingManagementFacade.class);
        }
        this._filename = filename;
        this._delay = 0;
    }

    private LoggingManagementFacade(String filename, int delay) {
        DOMConfigurator.configureAndWatch((String)filename, (long)delay);
        if (LOGGER == null) {
            LOGGER = Logger.getLogger(LoggingManagementFacade.class);
        }
        this._filename = filename;
        this._delay = delay;
    }

    public int getLog4jLogWatchInterval() {
        return this._delay;
    }

    public synchronized void reload() throws LoggingFacadeException {
        DOMConfigurator.configure((String)this._filename);
    }

    public synchronized Map<String, String> retrieveConfigFileLoggersLevels() throws LoggingFacadeException {
        try {
            HashMap<String, String> loggerLevelList = new HashMap<String, String>();
            LOGGER.info((Object)"Getting logger levels from log4j configuration file");
            Document doc = LoggingManagementFacade.parseConfigFile(this._filename);
            List<Element> categoryOrLoggerElements = this.buildListOfCategoryOrLoggerElements(doc);
            for (Element categoryOrLogger : categoryOrLoggerElements) {
                Element priorityOrLevelElement;
                try {
                    priorityOrLevelElement = this.getPriorityOrLevelElement(categoryOrLogger);
                }
                catch (LoggingFacadeException lfe) {
                    continue;
                }
                String categoryName = categoryOrLogger.getAttribute("name");
                String priorityOrLevelValue = priorityOrLevelElement.getAttribute("value");
                loggerLevelList.put(categoryName, priorityOrLevelValue);
            }
            return loggerLevelList;
        }
        catch (IOException e) {
            throw new LoggingFacadeException(e);
        }
    }

    public synchronized String retrieveConfigFileRootLoggerLevel() throws LoggingFacadeException {
        try {
            Document doc = LoggingManagementFacade.parseConfigFile(this._filename);
            NodeList rootElements = doc.getElementsByTagName("root");
            if (rootElements.getLength() == 0) {
                return "N/A";
            }
            Element rootElement = (Element)rootElements.item(0);
            Element levelElement = this.getPriorityOrLevelElement(rootElement);
            if (levelElement != null) {
                return levelElement.getAttribute("value");
            }
            return "N/A";
        }
        catch (IOException e) {
            throw new LoggingFacadeException(e);
        }
    }

    public synchronized void setConfigFileLoggerLevel(String logger, String level) throws LoggingFacadeException {
        LOGGER.info((Object)("Setting level to " + level + " for logger '" + logger + "' in log4j xml configuration file: " + this._filename));
        try {
            Document doc = LoggingManagementFacade.parseConfigFile(this._filename);
            List<Element> logElements = this.buildListOfCategoryOrLoggerElements(doc);
            Element logElement = null;
            for (Element e : logElements) {
                if (!e.getAttribute("name").equals(logger)) continue;
                logElement = e;
                break;
            }
            if (logElement == null) {
                throw new LoggingFacadeException("Can't find logger " + logger);
            }
            Element levelElement = this.getPriorityOrLevelElement(logElement);
            levelElement.setAttribute("value", level);
            this.writeUpdatedConfigFile(this._filename, doc);
        }
        catch (IOException ioe) {
            throw new LoggingFacadeException(ioe);
        }
        catch (TransformerConfigurationException e) {
            throw new LoggingFacadeException(e);
        }
    }

    public synchronized void setConfigFileRootLoggerLevel(String level) throws LoggingFacadeException {
        try {
            LOGGER.info((Object)("Setting level to " + level + " for the Root logger in " + "log4j xml configuration file: " + this._filename));
            Document doc = LoggingManagementFacade.parseConfigFile(this._filename);
            NodeList rootElements = doc.getElementsByTagName("root");
            if (rootElements.getLength() == 0) {
                throw new LoggingFacadeException("Configuration contains no root element");
            }
            Element rootElement = (Element)rootElements.item(0);
            Element levelElement = this.getPriorityOrLevelElement(rootElement);
            levelElement.setAttribute("value", level);
            this.writeUpdatedConfigFile(this._filename, doc);
        }
        catch (IOException e) {
            throw new LoggingFacadeException(e);
        }
        catch (TransformerConfigurationException e) {
            throw new LoggingFacadeException(e);
        }
    }

    public List<String> getAvailableLoggerLevels() {
        return new ArrayList<String>(){
            {
                this.add(Level.ALL.toString());
                this.add(Level.TRACE.toString());
                this.add(Level.DEBUG.toString());
                this.add(Level.INFO.toString());
                this.add(Level.WARN.toString());
                this.add(Level.ERROR.toString());
                this.add(Level.FATAL.toString());
                this.add(Level.OFF.toString());
            }
        };
    }

    public String retrieveRuntimeRootLoggerLevel() {
        Logger rootLogger = Logger.getRootLogger();
        return rootLogger.getLevel().toString();
    }

    public void setRuntimeRootLoggerLevel(String level) {
        Level newLevel = Level.toLevel((String)level);
        LOGGER.info((Object)("Setting RootLogger level to " + level));
        Logger log = Logger.getRootLogger();
        log.setLevel(newLevel);
    }

    public void setRuntimeLoggerLevel(String loggerName, String level) throws LoggingFacadeException {
        Level newLevel = level == null ? null : Level.toLevel((String)level);
        Logger targetLogger = this.findRuntimeLogger(loggerName);
        if (targetLogger == null) {
            throw new LoggingFacadeException("Can't find logger " + loggerName);
        }
        LOGGER.info((Object)("Setting level to " + newLevel + " for logger '" + targetLogger.getName() + "'"));
        targetLogger.setLevel(newLevel);
    }

    public Map<String, String> retrieveRuntimeLoggersLevels() {
        LOGGER.info((Object)"Getting levels for currently active log4j loggers");
        HashMap<String, String> levels = new HashMap<String, String>();
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            levels.put(logger.getName(), logger.getEffectiveLevel().toString());
        }
        return levels;
    }

    private void writeUpdatedConfigFile(String log4jConfigFileName, Document doc) throws IOException, TransformerConfigurationException {
        File tmp;
        File log4jConfigFile = new File(log4jConfigFileName);
        if (!log4jConfigFile.canWrite()) {
            LOGGER.warn((Object)("Specified log4j XML configuration file is not writable: " + log4jConfigFile));
            throw new IOException("Specified log4j XML configuration file is not writable");
        }
        Transformer transformer = null;
        transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-system", "log4j.dtd");
        DOMSource source = new DOMSource(doc);
        Random r = new Random();
        while ((tmp = new File(log4jConfigFile.getAbsolutePath() + r.nextInt() + ".tmp")).exists()) {
        }
        tmp.deleteOnExit();
        try {
            StreamResult result = new StreamResult(new FileOutputStream(tmp));
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            LOGGER.warn((Object)"Could not transform the XML into new file: ", (Throwable)e);
            throw new IOException("Could not transform the XML into new file: ", e);
        }
        File old = new File(log4jConfigFile.getAbsoluteFile() + ".old");
        if (old.exists()) {
            old.delete();
        }
        if (!log4jConfigFile.renameTo(old)) {
            LOGGER.error((Object)"Could not backup the existing log4j XML file");
            throw new IOException("Could not backup the existing log4j XML file");
        }
        if (!tmp.renameTo(log4jConfigFile)) {
            if (!old.renameTo(log4jConfigFile)) {
                LOGGER.error((Object)"Could not rename the new log4j configuration file into place, and unable to restore original file");
                throw new IOException("Could not rename the new log4j configuration file into place, and unable to restore original file");
            }
            LOGGER.error((Object)"Could not rename the new log4j configuration file into place");
            throw new IOException("Could not rename the new log4j configuration file into place");
        }
    }

    private static Document parseConfigFile(String fileName) throws IOException {
        Document doc;
        if (fileName == null) {
            LOGGER.warn((Object)"Provided log4j XML configuration filename is null");
            throw new IOException("Provided log4j XML configuration filename is null");
        }
        File configFile = new File(fileName);
        if (!configFile.exists()) {
            LOGGER.warn((Object)("The log4j XML configuration file could not be found: " + fileName));
            throw new IOException("The log4j XML configuration file could not be found");
        }
        if (!configFile.canRead()) {
            LOGGER.warn((Object)("The log4j XML configuration file is not readable: " + fileName));
            throw new IOException("The log4j XML configuration file is not readable");
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        QpidLog4JSaxErrorHandler errHandler = new QpidLog4JSaxErrorHandler();
        try {
            docFactory.setValidating(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(errHandler);
            docBuilder.setEntityResolver((EntityResolver)new Log4jEntityResolver());
            doc = docBuilder.parse(fileName);
        }
        catch (ParserConfigurationException e) {
            LOGGER.warn((Object)"Unable to parse the log4j XML file due to possible configuration error: ", (Throwable)e);
            throw new IOException("Unable to parse the log4j XML file due to possible configuration error: ", e);
        }
        catch (SAXException e) {
            LOGGER.warn((Object)"The specified log4j XML file is invalid: ", (Throwable)e);
            throw new IOException("The specified log4j XML file is invalid: ", e);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Unable to parse the specified log4j XML file", (Throwable)e);
            throw new IOException("Unable to parse the specified log4j XML file: ", e);
        }
        return doc;
    }

    private Logger findRuntimeLogger(String loggerName) {
        Logger targetLogger = null;
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            targetLogger = (Logger)loggers.nextElement();
            if (!targetLogger.getName().equals(loggerName)) continue;
            return targetLogger;
        }
        return null;
    }

    private List<Element> buildListOfCategoryOrLoggerElements(Document doc) {
        int i;
        NodeList categoryElements = doc.getElementsByTagName("category");
        NodeList loggerElements = doc.getElementsByTagName("logger");
        ArrayList<Element> logElements = new ArrayList<Element>();
        for (i = 0; i < categoryElements.getLength(); ++i) {
            logElements.add((Element)categoryElements.item(i));
        }
        for (i = 0; i < loggerElements.getLength(); ++i) {
            logElements.add((Element)loggerElements.item(i));
        }
        return logElements;
    }

    private Element getPriorityOrLevelElement(Element categoryOrLogger) throws LoggingFacadeException {
        NodeList priorityElements = categoryOrLogger.getElementsByTagName("priority");
        NodeList levelElements = categoryOrLogger.getElementsByTagName("level");
        Element levelElement = null;
        if (priorityElements.getLength() != 0) {
            levelElement = (Element)priorityElements.item(0);
        } else if (levelElements.getLength() != 0) {
            levelElement = (Element)levelElements.item(0);
        } else {
            throw new LoggingFacadeException("Configuration " + categoryOrLogger.getNodeName() + " element contains neither priority nor level child");
        }
        return levelElement;
    }

    private static class QpidLog4JSaxErrorHandler
    implements ErrorHandler {
        private QpidLog4JSaxErrorHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            if (LOGGER != null) {
                LOGGER.warn((Object)QpidLog4JSaxErrorHandler.constructMessage("Error parsing XML file", e));
            } else {
                System.err.println(QpidLog4JSaxErrorHandler.constructMessage("Error parsing XML file", e));
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            throw new SAXException(QpidLog4JSaxErrorHandler.constructMessage("Fatal error parsing XML file", e));
        }

        public void warning(SAXParseException e) throws SAXException {
            if (LOGGER != null) {
                LOGGER.warn((Object)QpidLog4JSaxErrorHandler.constructMessage("Warning parsing XML file", e));
            } else {
                System.err.println(QpidLog4JSaxErrorHandler.constructMessage("Warning parsing XML file", e));
            }
        }

        private static String constructMessage(String msg, SAXParseException ex) {
            return msg + ": Line " + ex.getLineNumber() + " column " + ex.getColumnNumber() + ": " + ex.getMessage();
        }
    }
}

