/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.subjects;

import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.logging.subjects.AbstractLogSubject;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.server.transport.ServerSession;

public class ChannelLogSubject
extends AbstractLogSubject {
    public ChannelLogSubject(AMQChannel channel) {
        AMQProtocolSession session = channel.getProtocolSession();
        this.setLogStringWithFormat("con:{0}({1}@{2}/{3})/ch:{4}", session.getSessionID(), session.getAuthorizedPrincipal().getName(), session.getRemoteAddress(), session.getVirtualHost().getName(), channel.getChannelId());
    }

    public ChannelLogSubject(ServerSession session) {
        if (session.getConnection() instanceof ServerConnection) {
            ServerConnection connection = session.getConnection();
            this.setLogStringWithFormat("con:{0}({1}@{2}/{3})/ch:{4}", connection == null ? -1L : connection.getConnectionId(), session.getAuthorizedPrincipal() == null ? "?" : session.getAuthorizedPrincipal().getName(), connection == null || connection.getRemoteAddressString() == null ? "?" : connection.getRemoteAddressString(), session.getVirtualHost().getName(), session.getChannel());
        }
    }
}

