/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.subjects;

import java.text.MessageFormat;
import org.apache.qpid.server.logging.subjects.AbstractLogSubject;
import org.apache.qpid.server.protocol.AMQProtocolSession;

public class ConnectionLogSubject
extends AbstractLogSubject {
    private AMQProtocolSession _session;
    private boolean _upToDate = false;

    public ConnectionLogSubject(AMQProtocolSession session) {
        this._session = session;
    }

    private void updateLogString() {
        if (!this._upToDate) {
            if (this._session.getAuthorizedPrincipal() != null) {
                if (this._session.getVirtualHost() != null) {
                    this.setLogString("[" + MessageFormat.format("con:{0}({1}@{2}/{3})", this._session.getSessionID(), this._session.getAuthorizedPrincipal().getName(), this._session.getRemoteAddress(), this._session.getVirtualHost().getName()) + "] ");
                    this._upToDate = true;
                } else {
                    this.setLogString("[" + MessageFormat.format("con:{0}({1}@{2})", this._session.getSessionID(), this._session.getAuthorizedPrincipal().getName(), this._session.getRemoteAddress()) + "] ");
                }
            } else {
                this.setLogString("[" + MessageFormat.format("con:{0}({1})", this._session.getSessionID(), this._session.getRemoteAddress()) + "] ");
            }
        }
    }

    public String toLogString() {
        this.updateLogString();
        return super.toLogString();
    }
}

