/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.model.ConfigurationChangeListener;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractAdapter
implements ConfiguredObject {
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private final Map<Class<? extends ConfiguredObject>, ConfiguredObject> _parents = new HashMap<Class<? extends ConfiguredObject>, ConfiguredObject>();
    private final Collection<ConfigurationChangeListener> _changeListeners = new ArrayList<ConfigurationChangeListener>();
    private final UUID _id;

    protected AbstractAdapter(UUID id) {
        this._id = id;
    }

    static String getStringAttribute(String name, Map<String, Object> attributes, String defaultVal) {
        Object value = attributes.get(name);
        return value == null ? defaultVal : String.valueOf(value);
    }

    static Map getMapAttribute(String name, Map<String, Object> attributes, Map defaultVal) {
        Object value = attributes.get(name);
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Map");
    }

    static <E extends Enum> E getEnumAttribute(Class<E> clazz, String name, Map<String, Object> attributes, E defaultVal) {
        Object obj = attributes.get(name);
        if (obj == null) {
            return defaultVal;
        }
        if (clazz.isInstance(obj)) {
            return (E)((Enum)obj);
        }
        if (obj instanceof String) {
            return Enum.valueOf(clazz, (String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type " + clazz.getSimpleName());
    }

    static Boolean getBooleanAttribute(String name, Map<String, Object> attributes, Boolean defaultValue) {
        Object obj = attributes.get(name);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Boolean");
    }

    static Integer getIntegerAttribute(String name, Map<String, Object> attributes, Integer defaultValue) {
        Object obj = attributes.get(name);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Integer");
    }

    static Long getLongAttribute(String name, Map<String, Object> attributes, Long defaultValue) {
        Object obj = attributes.get(name);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Long");
    }

    @Override
    public final UUID getId() {
        return this._id;
    }

    @Override
    public State getDesiredState() {
        return null;
    }

    @Override
    public State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot add a null listener");
        }
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            if (!this._changeListeners.contains(listener)) {
                this._changeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeChangeListener(ConfigurationChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("Cannot remove a null listener");
        }
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            return this._changeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void childAdded(ConfiguredObject child) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            for (ConfigurationChangeListener listener : this._changeListeners) {
                listener.childAdded(this, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void childRemoved(ConfiguredObject child) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            for (ConfigurationChangeListener listener : this._changeListeners) {
                listener.childRemoved(this, child);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            return this._attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            Object currentValue = this._attributes.get(name);
            if (currentValue == null && expected == null || currentValue != null && currentValue.equals(expected)) {
                this._attributes.put(name, desired);
                return desired;
            }
            return currentValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends ConfiguredObject> T getParent(Class<T> clazz) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            return (T)this._parents.get(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ConfiguredObject> void addParent(Class<T> clazz, T parent) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            this._parents.put(clazz, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends ConfiguredObject> void removeParent(Class<T> clazz) {
        AbstractAdapter abstractAdapter = this;
        synchronized (abstractAdapter) {
            this._parents.remove(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getAttributeNames() {
        Map<String, Object> map = this._attributes;
        synchronized (map) {
            return new ArrayList<String>(this._attributes.keySet());
        }
    }
}

