/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Consumer;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.QueueAdapter;
import org.apache.qpid.server.subscription.Subscription;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsumerAdapter
extends AbstractAdapter
implements Consumer {
    private final Subscription _subscription;
    private final QueueAdapter _queue;
    private final ConsumerStatistics _statistics;

    public ConsumerAdapter(QueueAdapter queueAdapter, Subscription subscription) {
        super(UUIDGenerator.generateConsumerUUID(queueAdapter.getVirtualHost().getName(), queueAdapter.getName(), subscription.getSessionModel().getConnectionModel().getRemoteAddressString(), String.valueOf(subscription.getSessionModel().getChannelId()), subscription.getConsumerName()));
        this._subscription = subscription;
        this._queue = queueAdapter;
        this._statistics = new ConsumerStatistics();
    }

    @Override
    public String getName() {
        return this._subscription.getConsumerName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return null;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Consumer.AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return super.setAttribute(name, expected, desired);
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if (!"state".equals(name)) {
            if ("durable".equals(name)) {
                return false;
            }
            if ("lifetimePolicy".equals(name)) {
                return LifetimePolicy.AUTO_DELETE;
            }
            if (!("timeToLive".equals(name) || "created".equals(name) || "updated".equals(name))) {
                if ("distributionMode".equals(name)) {
                    return this._subscription.acquires() ? "MOVE" : "COPY";
                }
                if ("settlementMode".equals(name) || "exclusive".equals(name) || "noLocal".equals(name) || "selector".equals(name)) {
                    // empty if block
                }
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Statistics getStatistics() {
        return this._statistics;
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new IllegalArgumentException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConsumerStatistics
    implements Statistics {
        private ConsumerStatistics() {
        }

        @Override
        public Collection<String> getStatisticNames() {
            return Consumer.AVAILABLE_STATISTICS;
        }

        @Override
        public Object getStatistic(String name) {
            if (name.equals("bytesOut")) {
                return ConsumerAdapter.this._subscription.getBytesOut();
            }
            if (name.equals("messagesOut")) {
                return ConsumerAdapter.this._subscription.getMessagesOut();
            }
            if (!name.equals("stateChanged")) {
                if (name.equals("unacknowledgedBytes")) {
                    return ConsumerAdapter.this._subscription.getUnacknowledgedBytes();
                }
                if (name.equals("unacknowledgedMessages")) {
                    return ConsumerAdapter.this._subscription.getUnacknowledgedMessages();
                }
            }
            return null;
        }
    }
}

