/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.security.AccessControlException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Group;
import org.apache.qpid.server.model.GroupMember;
import org.apache.qpid.server.model.GroupProvider;
import org.apache.qpid.server.model.IllegalStateTransitionException;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.BrokerAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.security.group.GroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupProviderAdapter
extends AbstractAdapter
implements GroupProvider {
    private final GroupManager _groupManager;

    protected GroupProviderAdapter(GroupManager groupManager) {
        super(UUIDGenerator.generateRandomUUID());
        if (groupManager == null) {
            throw new IllegalArgumentException("GroupManager must not be null");
        }
        this._groupManager = groupManager;
    }

    public static GroupProviderAdapter createGroupProviderAdapter(BrokerAdapter brokerAdapter, GroupManager groupManager) {
        GroupProviderAdapter groupProviderAdapter = new GroupProviderAdapter(groupManager);
        groupProviderAdapter.addParent(Broker.class, brokerAdapter);
        return groupProviderAdapter;
    }

    @Override
    public String getName() {
        return this._groupManager.getClass().getSimpleName();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        return null;
    }

    @Override
    public State getActualState() {
        return null;
    }

    @Override
    public boolean isDurable() {
        return true;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return null;
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return 0L;
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public Collection<String> getAttributeNames() {
        return GroupProvider.AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object getAttribute(String name) {
        if ("type".equals(name)) {
            return this.getName();
        }
        if (!"created".equals(name)) {
            if ("durable".equals(name)) {
                return true;
            }
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("lifetimePolicy".equals(name)) {
                return LifetimePolicy.PERMANENT;
            }
            if ("name".equals(name)) {
                return this.getName();
            }
            if ("state".equals(name)) {
                return State.ACTIVE;
            }
            if ("timeToLive".equals(name) || "updated".equals(name)) {
                // empty if block
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        if (childClass == Group.class) {
            String groupName = (String)attributes.get("name");
            if (this.getSecurityManager().authoriseGroupOperation(Operation.CREATE, groupName)) {
                this._groupManager.createGroup(groupName);
                return (C)new GroupAdapter(groupName);
            }
            throw new AccessControlException("Do not have permission to create new group");
        }
        throw new IllegalArgumentException("This group provider does not support creating children of type: " + childClass);
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Group.class) {
            Set<Principal> groups = this._groupManager.getGroupPrincipals();
            ArrayList<GroupAdapter> principals = new ArrayList<GroupAdapter>(groups.size());
            for (Principal group : groups) {
                principals.add(new GroupAdapter(group.getName()));
            }
            return Collections.unmodifiableCollection(principals);
        }
        return null;
    }

    private SecurityManager getSecurityManager() {
        return ApplicationRegistry.getInstance().getSecurityManager();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupAdapter
    extends AbstractAdapter
    implements Group {
        private final String _group;

        public GroupAdapter(String group) {
            super(UUIDGenerator.generateGroupUUID(GroupProviderAdapter.this.getName(), group));
            this._group = group;
        }

        @Override
        public String getName() {
            return this._group;
        }

        @Override
        public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
            throw new IllegalStateException("Names cannot be updated");
        }

        @Override
        public State getActualState() {
            return State.ACTIVE;
        }

        @Override
        public boolean isDurable() {
            return true;
        }

        @Override
        public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new IllegalStateException("Durability cannot be updated");
        }

        @Override
        public LifetimePolicy getLifetimePolicy() {
            return LifetimePolicy.PERMANENT;
        }

        @Override
        public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new IllegalStateException("LifetimePolicy cannot be updated");
        }

        @Override
        public long getTimeToLive() {
            return 0L;
        }

        @Override
        public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            throw new IllegalStateException("ttl cannot be updated");
        }

        @Override
        public Statistics getStatistics() {
            return NoStatistics.getInstance();
        }

        @Override
        public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
            if (clazz == GroupMember.class) {
                Set<Principal> usersInGroup = GroupProviderAdapter.this._groupManager.getUserPrincipalsForGroup(this._group);
                ArrayList<GroupMemberAdapter> members = new ArrayList<GroupMemberAdapter>();
                for (Principal principal : usersInGroup) {
                    members.add(new GroupMemberAdapter(principal.getName()));
                }
                return Collections.unmodifiableCollection(members);
            }
            return null;
        }

        @Override
        public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
            if (childClass == GroupMember.class) {
                String memberName = (String)attributes.get("name");
                if (GroupProviderAdapter.this.getSecurityManager().authoriseGroupOperation(Operation.UPDATE, this._group)) {
                    GroupProviderAdapter.this._groupManager.addUserToGroup(memberName, this._group);
                    return (C)new GroupMemberAdapter(memberName);
                }
                throw new AccessControlException("Do not have permission to add new group member");
            }
            throw new IllegalArgumentException("This group provider does not support creating children of type: " + childClass);
        }

        @Override
        public Collection<String> getAttributeNames() {
            return Group.AVAILABLE_ATTRIBUTES;
        }

        @Override
        public Object getAttribute(String name) {
            if ("id".equals(name)) {
                return this.getId();
            }
            if ("name".equals(name)) {
                return this.getName();
            }
            return super.getAttribute(name);
        }

        @Override
        public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            return super.setAttribute(name, expected, desired);
        }

        @Override
        public State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
            if (desiredState == State.DELETED) {
                if (GroupProviderAdapter.this.getSecurityManager().authoriseGroupOperation(Operation.DELETE, this._group)) {
                    GroupProviderAdapter.this._groupManager.removeGroup(this._group);
                    return State.DELETED;
                }
                throw new AccessControlException("Do not have permission to delete group");
            }
            return super.setDesiredState(currentState, desiredState);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class GroupMemberAdapter
        extends AbstractAdapter
        implements GroupMember {
            private String _memberName;

            public GroupMemberAdapter(String memberName) {
                super(UUIDGenerator.generateGroupMemberUUID(GroupProviderAdapter.this.getName(), GroupAdapter.this._group, memberName));
                this._memberName = memberName;
            }

            @Override
            public Collection<String> getAttributeNames() {
                return GroupMember.AVAILABLE_ATTRIBUTES;
            }

            @Override
            public Object getAttribute(String name) {
                if ("id".equals(name)) {
                    return this.getId();
                }
                if ("name".equals(name)) {
                    return this.getName();
                }
                return super.getAttribute(name);
            }

            @Override
            public String getName() {
                return this._memberName;
            }

            @Override
            public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
                return null;
            }

            @Override
            public State getActualState() {
                return null;
            }

            @Override
            public boolean isDurable() {
                return false;
            }

            @Override
            public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
            }

            @Override
            public LifetimePolicy getLifetimePolicy() {
                return null;
            }

            @Override
            public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                return null;
            }

            @Override
            public long getTimeToLive() {
                return 0L;
            }

            @Override
            public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
                return 0L;
            }

            @Override
            public Statistics getStatistics() {
                return NoStatistics.getInstance();
            }

            @Override
            public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
                return null;
            }

            @Override
            public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
                return null;
            }

            @Override
            public State setDesiredState(State currentState, State desiredState) throws IllegalStateTransitionException, AccessControlException {
                if (desiredState == State.DELETED) {
                    if (GroupProviderAdapter.this.getSecurityManager().authoriseGroupOperation(Operation.UPDATE, GroupAdapter.this._group)) {
                        GroupProviderAdapter.this._groupManager.removeUserFromGroup(this._memberName, GroupAdapter.this._group);
                        return State.DELETED;
                    }
                    throw new AccessControlException("Do not have permission to remove group member");
                }
                return super.setDesiredState(currentState, desiredState);
            }
        }
    }
}

