/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Port;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.model.VirtualHostAlias;
import org.apache.qpid.server.model.adapter.AbstractAdapter;
import org.apache.qpid.server.model.adapter.BrokerAdapter;
import org.apache.qpid.server.model.adapter.NoStatistics;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.transport.QpidAcceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortAdapter
extends AbstractAdapter
implements Port {
    private final BrokerAdapter _broker;
    private final QpidAcceptor _acceptor;
    private final InetSocketAddress _address;
    private final Collection<Protocol> _protocols;

    public PortAdapter(BrokerAdapter brokerAdapter, QpidAcceptor acceptor, InetSocketAddress address) {
        super(UUIDGenerator.generateRandomUUID());
        this._broker = brokerAdapter;
        this._acceptor = acceptor;
        this._address = address;
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        for (AmqpProtocolVersion pv : this._acceptor.getSupported()) {
            switch (pv) {
                case v0_8: {
                    protocols.add(Protocol.AMQP_0_8);
                    break;
                }
                case v0_9: {
                    protocols.add(Protocol.AMQP_0_9);
                    break;
                }
                case v0_9_1: {
                    protocols.add(Protocol.AMQP_0_9_1);
                    break;
                }
                case v0_10: {
                    protocols.add(Protocol.AMQP_0_10);
                    break;
                }
                case v1_0_0: {
                    protocols.add(Protocol.AMQP_1_0);
                }
            }
        }
        this._protocols = Collections.unmodifiableCollection(protocols);
    }

    @Override
    public String getBindingAddress() {
        return this._address.getHostName();
    }

    @Override
    public int getPort() {
        return this._address.getPort();
    }

    @Override
    public Collection<Transport> getTransports() {
        switch (this._acceptor.getTransport()) {
            case TCP: {
                return Collections.singleton(Transport.TCP);
            }
            case SSL: {
                return Collections.singleton(Transport.SSL);
            }
        }
        return null;
    }

    @Override
    public void addTransport(Transport transport) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Transport removeTransport(Transport transport) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Collection<Protocol> getProtocols() {
        return this._protocols;
    }

    @Override
    public void addProtocol(Protocol protocol) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Protocol removeProtocol(Protocol protocol) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Collection<VirtualHostAlias> getVirtualHostBindings() {
        ArrayList<VirtualHostAlias> aliases = new ArrayList<VirtualHostAlias>();
        for (VirtualHost vh : this._broker.getVirtualHosts()) {
            for (VirtualHostAlias alias : vh.getAliases()) {
                if (!alias.getPort().equals(this)) continue;
                aliases.add(alias);
            }
        }
        return Collections.unmodifiableCollection(aliases);
    }

    @Override
    public Collection<Connection> getConnections() {
        return null;
    }

    @Override
    public String getName() {
        return this.getBindingAddress() + ":" + this.getPort();
    }

    @Override
    public String setName(String currentName, String desiredName) throws IllegalStateException, AccessControlException {
        throw new IllegalStateException();
    }

    @Override
    public State getActualState() {
        return State.ACTIVE;
    }

    @Override
    public boolean isDurable() {
        return false;
    }

    @Override
    public void setDurable(boolean durable) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public LifetimePolicy getLifetimePolicy() {
        return LifetimePolicy.PERMANENT;
    }

    @Override
    public LifetimePolicy setLifetimePolicy(LifetimePolicy expected, LifetimePolicy desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public long getTimeToLive() {
        return 0L;
    }

    @Override
    public long setTimeToLive(long expected, long desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        throw new IllegalStateException();
    }

    @Override
    public Statistics getStatistics() {
        return NoStatistics.getInstance();
    }

    @Override
    public <C extends ConfiguredObject> Collection<C> getChildren(Class<C> clazz) {
        if (clazz == Connection.class) {
            return this.getConnections();
        }
        return Collections.emptySet();
    }

    @Override
    public <C extends ConfiguredObject> C createChild(Class<C> childClass, Map<String, Object> attributes, ConfiguredObject ... otherParents) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getAttribute(String name) {
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("name".equals(name)) {
            return this.getName();
        }
        if ("state".equals(name)) {
            return this.getActualState();
        }
        if ("durable".equals(name)) {
            return this.isDurable();
        }
        if ("lifetimePolicy".equals(name)) {
            return this.getLifetimePolicy();
        }
        if ("timeToLive".equals(name)) {
            return this.getTimeToLive();
        }
        if (!"created".equals(name) && !"updated".equals(name)) {
            if ("bindingAddress".equals(name)) {
                return this.getBindingAddress();
            }
            if ("port".equals(name)) {
                return this.getPort();
            }
            if ("protocols".equals(name)) {
                return this.getProtocols();
            }
            if ("transports".equals(name)) {
                return this.getTransports();
            }
        }
        return super.getAttribute(name);
    }

    @Override
    public Collection<String> getAttributeNames() {
        return AVAILABLE_ATTRIBUTES;
    }

    @Override
    public Object setAttribute(String name, Object expected, Object desired) throws IllegalStateException, AccessControlException, IllegalArgumentException {
        return super.setAttribute(name, expected, desired);
    }
}

