/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model.adapter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.qpid.server.model.Statistics;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.stats.StatisticsGatherer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatisticsAdapter
implements Statistics {
    private final Map<String, StatisticsCounter> _statistics = new HashMap<String, StatisticsCounter>();
    private static final String BYTES_IN = "bytesIn";
    private static final String BYTES_OUT = "bytesOut";
    private static final String MESSAGES_IN = "messagesIn";
    private static final String MESSAGES_OUT = "messagesOut";
    private static final Collection<String> STATISTIC_NAMES = Collections.unmodifiableCollection(Arrays.asList("bytesIn", "bytesOut", "messagesIn", "messagesOut"));

    public StatisticsAdapter(StatisticsGatherer statGatherer) {
        this._statistics.put(BYTES_OUT, statGatherer.getDataDeliveryStatistics());
        this._statistics.put(BYTES_IN, statGatherer.getDataReceiptStatistics());
        this._statistics.put(MESSAGES_OUT, statGatherer.getMessageDeliveryStatistics());
        this._statistics.put(MESSAGES_IN, statGatherer.getMessageReceiptStatistics());
    }

    @Override
    public Collection<String> getStatisticNames() {
        return STATISTIC_NAMES;
    }

    @Override
    public Object getStatistic(String name) {
        StatisticsCounter counter = this._statistics.get(name);
        return counter == null ? null : Long.valueOf(counter.getTotal());
    }
}

