/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.protocol.AMQProtocolEngine;
import org.apache.qpid.server.protocol.AmqpProtocolVersion;
import org.apache.qpid.server.protocol.ProtocolEngine_0_10;
import org.apache.qpid.server.protocol.ProtocolEngine_1_0_0;
import org.apache.qpid.server.protocol.ProtocolEngine_1_0_0_SASL;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.transport.ServerConnection;
import org.apache.qpid.server.transport.ServerConnectionDelegate;
import org.apache.qpid.transport.ConnectionDelegate;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiVersionProtocolEngine
implements ServerProtocolEngine {
    private static final Logger _logger = Logger.getLogger(MultiVersionProtocolEngine.class);
    private final long _id;
    private Set<AmqpProtocolVersion> _supported;
    private String _fqdn;
    private IApplicationRegistry _appRegistry;
    private NetworkConnection _network;
    private Sender<ByteBuffer> _sender;
    private final AmqpProtocolVersion _defaultSupportedReply;
    private volatile ServerProtocolEngine _delegate = new SelfDelegateProtocolEngine();
    private static final int MINIMUM_REQUIRED_HEADER_BYTES = 8;
    private static final byte[] AMQP_0_8_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 8, 0};
    private static final byte[] AMQP_0_9_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 0, 9};
    private static final byte[] AMQP_0_9_1_HEADER = new byte[]{65, 77, 81, 80, 0, 0, 9, 1};
    private static final byte[] AMQP_0_10_HEADER = new byte[]{65, 77, 81, 80, 1, 1, 0, 10};
    private static final byte[] AMQP_1_0_0_HEADER = new byte[]{65, 77, 81, 80, 0, 1, 0, 0};
    private static final byte[] AMQP_SASL_1_0_0_HEADER = new byte[]{65, 77, 81, 80, 3, 1, 0, 0};
    private DelegateCreator creator_0_8 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_8;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_8_HEADER;
        }

        public ServerProtocolEngine getProtocolEngine() {
            return new AMQProtocolEngine(MultiVersionProtocolEngine.this._appRegistry.getVirtualHostRegistry(), MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._id);
        }
    };
    private DelegateCreator creator_0_9 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_9;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_9_HEADER;
        }

        public ServerProtocolEngine getProtocolEngine() {
            return new AMQProtocolEngine(MultiVersionProtocolEngine.this._appRegistry.getVirtualHostRegistry(), MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._id);
        }
    };
    private DelegateCreator creator_0_9_1 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_9_1;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_9_1_HEADER;
        }

        public ServerProtocolEngine getProtocolEngine() {
            return new AMQProtocolEngine(MultiVersionProtocolEngine.this._appRegistry.getVirtualHostRegistry(), MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._id);
        }
    };
    private DelegateCreator creator_0_10 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v0_10;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_0_10_HEADER;
        }

        public ServerProtocolEngine getProtocolEngine() {
            ServerConnectionDelegate connDelegate = new ServerConnectionDelegate(MultiVersionProtocolEngine.this._appRegistry, MultiVersionProtocolEngine.this._fqdn, MultiVersionProtocolEngine.this._appRegistry.getSubjectCreator(MultiVersionProtocolEngine.this.getLocalAddress()));
            ServerConnection conn = new ServerConnection(MultiVersionProtocolEngine.this._id);
            conn.setConnectionDelegate((ConnectionDelegate)connDelegate);
            conn.setRemoteAddress(MultiVersionProtocolEngine.this._network.getRemoteAddress());
            conn.setLocalAddress(MultiVersionProtocolEngine.this._network.getLocalAddress());
            return new ProtocolEngine_0_10(conn, MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._appRegistry);
        }
    };
    private DelegateCreator creator_1_0_0 = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v1_0_0;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_1_0_0_HEADER;
        }

        public ServerProtocolEngine getProtocolEngine() {
            return new ProtocolEngine_1_0_0(MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._appRegistry, MultiVersionProtocolEngine.this._id);
        }
    };
    private DelegateCreator creator_1_0_0_SASL = new DelegateCreator(){

        public AmqpProtocolVersion getVersion() {
            return AmqpProtocolVersion.v1_0_0;
        }

        public byte[] getHeaderIdentifier() {
            return AMQP_SASL_1_0_0_HEADER;
        }

        public ServerProtocolEngine getProtocolEngine() {
            return new ProtocolEngine_1_0_0_SASL(MultiVersionProtocolEngine.this._network, MultiVersionProtocolEngine.this._appRegistry, MultiVersionProtocolEngine.this._id);
        }
    };
    private final DelegateCreator[] _creators = new DelegateCreator[]{this.creator_0_8, this.creator_0_9, this.creator_0_9_1, this.creator_0_10, this.creator_1_0_0_SASL, this.creator_1_0_0};

    public MultiVersionProtocolEngine(IApplicationRegistry appRegistry, Set<AmqpProtocolVersion> supported, AmqpProtocolVersion defaultSupportedReply, long id, NetworkConnection network) {
        this(appRegistry, supported, defaultSupportedReply, id);
        this.setNetworkConnection(network);
    }

    public MultiVersionProtocolEngine(IApplicationRegistry appRegistry, Set<AmqpProtocolVersion> supported, AmqpProtocolVersion defaultSupportedReply, long id) {
        if (defaultSupportedReply != null && !supported.contains((Object)defaultSupportedReply)) {
            throw new IllegalArgumentException("The configured default reply (" + (Object)((Object)defaultSupportedReply) + ") to an unsupported protocol version initiation is itself not supported!");
        }
        this._id = id;
        this._appRegistry = appRegistry;
        this._supported = supported;
        this._defaultSupportedReply = defaultSupportedReply;
    }

    public SocketAddress getRemoteAddress() {
        return this._delegate.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._delegate.getLocalAddress();
    }

    public long getWrittenBytes() {
        return this._delegate.getWrittenBytes();
    }

    public long getReadBytes() {
        return this._delegate.getReadBytes();
    }

    public void closed() {
        this._delegate.closed();
    }

    public void writerIdle() {
        this._delegate.writerIdle();
    }

    public void readerIdle() {
        this._delegate.readerIdle();
    }

    public void received(ByteBuffer msg) {
        this._delegate.received((Object)msg);
    }

    public void exception(Throwable t) {
        this._delegate.exception(t);
    }

    public long getConnectionId() {
        return this._delegate.getConnectionId();
    }

    public void setNetworkConnection(NetworkConnection networkConnection) {
        this.setNetworkConnection(networkConnection, (Sender<ByteBuffer>)networkConnection.getSender());
    }

    public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        this._network = network;
        SocketAddress address = this._network.getLocalAddress();
        if (!(address instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Unsupported socket address class: " + address);
        }
        this._fqdn = ((InetSocketAddress)address).getHostName();
        this._sender = sender;
    }

    public long getLastReadTime() {
        return this._delegate.getLastReadTime();
    }

    public long getLastWriteTime() {
        return this._delegate.getLastWriteTime();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SelfDelegateProtocolEngine
    implements ServerProtocolEngine {
        private final ByteBuffer _header = ByteBuffer.allocate(8);

        private SelfDelegateProtocolEngine() {
        }

        public SocketAddress getRemoteAddress() {
            return MultiVersionProtocolEngine.this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return MultiVersionProtocolEngine.this._network.getLocalAddress();
        }

        public long getWrittenBytes() {
            return 0L;
        }

        public long getReadBytes() {
            return 0L;
        }

        public void received(ByteBuffer msg) {
            ByteBuffer msgheader = msg.duplicate();
            if (this._header.remaining() > msgheader.limit()) {
                msg.position(msg.limit());
            } else {
                msgheader.limit(this._header.remaining());
                msg.position(this._header.remaining());
            }
            this._header.put(msgheader);
            if (!this._header.hasRemaining()) {
                this._header.flip();
                byte[] headerBytes = new byte[8];
                this._header.get(headerBytes);
                ServerProtocolEngine newDelegate = null;
                byte[] supportedReplyBytes = null;
                byte[] defaultSupportedReplyBytes = null;
                AmqpProtocolVersion supportedReplyVersion = null;
                for (int i = 0; newDelegate == null && i < MultiVersionProtocolEngine.this._creators.length; ++i) {
                    if (MultiVersionProtocolEngine.this._supported.contains((Object)MultiVersionProtocolEngine.this._creators[i].getVersion())) {
                        supportedReplyBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                        supportedReplyVersion = MultiVersionProtocolEngine.this._creators[i].getVersion();
                        byte[] compareBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                        boolean equal = true;
                        for (int j = 0; equal && j < compareBytes.length; ++j) {
                            equal = headerBytes[j] == compareBytes[j];
                        }
                        if (equal) {
                            newDelegate = MultiVersionProtocolEngine.this._creators[i].getProtocolEngine();
                        }
                    }
                    if (MultiVersionProtocolEngine.this._defaultSupportedReply == null || MultiVersionProtocolEngine.this._creators[i].getVersion() != MultiVersionProtocolEngine.this._defaultSupportedReply) continue;
                    defaultSupportedReplyBytes = MultiVersionProtocolEngine.this._creators[i].getHeaderIdentifier();
                }
                if (newDelegate == null) {
                    if (MultiVersionProtocolEngine.this._defaultSupportedReply != null && MultiVersionProtocolEngine.this._defaultSupportedReply != supportedReplyVersion) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Default reply to unsupported protocol version was configured, changing reply from " + (Object)((Object)supportedReplyVersion) + " to " + (Object)((Object)MultiVersionProtocolEngine.this._defaultSupportedReply)));
                        }
                        supportedReplyBytes = defaultSupportedReplyBytes;
                        supportedReplyVersion = MultiVersionProtocolEngine.this._defaultSupportedReply;
                    }
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Unsupported protocol version requested, replying with: " + supportedReplyVersion));
                    }
                    MultiVersionProtocolEngine.this._sender.send((Object)ByteBuffer.wrap(supportedReplyBytes));
                    MultiVersionProtocolEngine.this._sender.flush();
                    MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                    MultiVersionProtocolEngine.this._network.close();
                } else {
                    MultiVersionProtocolEngine.this._delegate = newDelegate;
                    this._header.flip();
                    MultiVersionProtocolEngine.this._delegate.received((Object)this._header);
                    if (msg.hasRemaining()) {
                        MultiVersionProtocolEngine.this._delegate.received((Object)msg);
                    }
                }
            }
        }

        public long getConnectionId() {
            return MultiVersionProtocolEngine.this._id;
        }

        public void exception(Throwable t) {
            _logger.error((Object)"Error establishing session", t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closed() {
            try {
                MultiVersionProtocolEngine.this._delegate = new ClosedDelegateProtocolEngine();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Connection from  " + this.getRemoteAddress() + " was closed before any protocol version was established."));
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    MultiVersionProtocolEngine.this._network.close();
                }
                catch (Exception e) {}
            }
        }

        public void writerIdle() {
        }

        public void readerIdle() {
        }

        public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        }

        public long getLastReadTime() {
            return 0L;
        }

        public long getLastWriteTime() {
            return 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClosedDelegateProtocolEngine
    implements ServerProtocolEngine {
        private ClosedDelegateProtocolEngine() {
        }

        public SocketAddress getRemoteAddress() {
            return MultiVersionProtocolEngine.this._network.getRemoteAddress();
        }

        public SocketAddress getLocalAddress() {
            return MultiVersionProtocolEngine.this._network.getLocalAddress();
        }

        public long getWrittenBytes() {
            return 0L;
        }

        public long getReadBytes() {
            return 0L;
        }

        public void received(ByteBuffer msg) {
            _logger.error((Object)"Error processing incoming data, could not negotiate a common protocol");
        }

        public void exception(Throwable t) {
            _logger.error((Object)"Error establishing session", t);
        }

        public void closed() {
        }

        public void writerIdle() {
        }

        public void readerIdle() {
        }

        public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        }

        public long getLastReadTime() {
            return 0L;
        }

        public long getLastWriteTime() {
            return 0L;
        }

        public long getConnectionId() {
            return MultiVersionProtocolEngine.this._id;
        }
    }

    private static interface DelegateCreator {
        public AmqpProtocolVersion getVersion();

        public byte[] getHeaderIdentifier();

        public ServerProtocolEngine getProtocolEngine();
    }
}

