/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol;

import java.io.PrintWriter;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.amqp_1_0.codec.FrameWriter;
import org.apache.qpid.amqp_1_0.codec.ProtocolHandler;
import org.apache.qpid.amqp_1_0.codec.ValueWriter;
import org.apache.qpid.amqp_1_0.framing.AMQFrame;
import org.apache.qpid.amqp_1_0.framing.OversizeFrameException;
import org.apache.qpid.amqp_1_0.framing.SASLFrameHandler;
import org.apache.qpid.amqp_1_0.framing.TransportFrame;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;
import org.apache.qpid.amqp_1_0.transport.ConnectionEventListener;
import org.apache.qpid.amqp_1_0.transport.Container;
import org.apache.qpid.amqp_1_0.transport.FrameOutputHandler;
import org.apache.qpid.amqp_1_0.transport.SaslServerProvider;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.FrameBody;
import org.apache.qpid.protocol.ServerProtocolEngine;
import org.apache.qpid.server.protocol.v1_0.Connection_1_0;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.NetworkConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolEngine_1_0_0_SASL
implements ServerProtocolEngine,
FrameOutputHandler {
    private long _readBytes;
    private long _writtenBytes;
    private long _lastReadTime;
    private long _lastWriteTime;
    private final IApplicationRegistry _appRegistry;
    private long _createTime = System.currentTimeMillis();
    private ConnectionEndpoint _conn;
    private long _connectionId;
    private static final ByteBuffer HEADER = ByteBuffer.wrap(new byte[]{65, 77, 81, 80, 3, 1, 0, 0});
    private static final ByteBuffer PROTOCOL_HEADER = ByteBuffer.wrap(new byte[]{65, 77, 81, 80, 0, 1, 0, 0});
    private FrameWriter _frameWriter;
    private ProtocolHandler _frameHandler;
    private ByteBuffer _buf = ByteBuffer.allocate(0x100000);
    private Object _sendLock = new Object();
    private byte _major;
    private byte _minor;
    private byte _revision;
    private PrintWriter _out;
    private NetworkConnection _network;
    private Sender<ByteBuffer> _sender;
    private State _state = State.A;
    private final Logger RAW_LOGGER = Logger.getLogger("RAW");
    private static final Logger FRAME_LOGGER = Logger.getLogger("FRM");

    public ProtocolEngine_1_0_0_SASL(NetworkConnection networkDriver, IApplicationRegistry appRegistry, long id) {
        this._connectionId = id;
        this._appRegistry = appRegistry;
        if (networkDriver != null) {
            this.setNetworkConnection(networkDriver, (Sender<ByteBuffer>)networkDriver.getSender());
        }
    }

    public SocketAddress getRemoteAddress() {
        return this._network.getRemoteAddress();
    }

    public SocketAddress getLocalAddress() {
        return this._network.getLocalAddress();
    }

    public long getReadBytes() {
        return this._readBytes;
    }

    public long getWrittenBytes() {
        return this._writtenBytes;
    }

    public void writerIdle() {
    }

    public void readerIdle() {
    }

    public void setNetworkConnection(NetworkConnection network, Sender<ByteBuffer> sender) {
        this._network = network;
        this._sender = sender;
        Container container = new Container(this._appRegistry.getBrokerId().toString());
        this._conn = new ConnectionEndpoint(container, this.asSaslServerProvider(ApplicationRegistry.getInstance().getSubjectCreator(this.getLocalAddress())));
        this._conn.setConnectionEventListener((ConnectionEventListener)new Connection_1_0(this._appRegistry, this._conn, this._connectionId));
        this._conn.setRemoteAddress(this.getRemoteAddress());
        this._conn.setFrameOutputHandler((FrameOutputHandler)this);
        this._conn.setSaslFrameOutput((FrameOutputHandler)this);
        this._conn.setOnSaslComplete(new Runnable(){

            public void run() {
                if (ProtocolEngine_1_0_0_SASL.this._conn.isAuthenticated()) {
                    ProtocolEngine_1_0_0_SASL.this._sender.send((Object)PROTOCOL_HEADER.duplicate());
                    ProtocolEngine_1_0_0_SASL.this._sender.flush();
                } else {
                    ProtocolEngine_1_0_0_SASL.this._network.close();
                }
            }
        });
        this._frameWriter = new FrameWriter((ValueWriter.Registry)this._conn.getDescribedTypeRegistry());
        this._frameHandler = new SASLFrameHandler(this._conn);
        this._sender.send((Object)HEADER.duplicate());
        this._sender.flush();
        this._conn.initiateSASL();
    }

    private SaslServerProvider asSaslServerProvider(final SubjectCreator subjectCreator) {
        return new SaslServerProvider(){

            public SaslServer getSaslServer(String mechanism, String fqdn) throws SaslException {
                return subjectCreator.createSaslServer(mechanism, fqdn, null);
            }
        };
    }

    public String getAddress() {
        return this.getRemoteAddress().toString();
    }

    public boolean isDurable() {
        return false;
    }

    public synchronized void received(ByteBuffer msg) {
        this._lastReadTime = System.currentTimeMillis();
        if (this.RAW_LOGGER.isLoggable(Level.FINE)) {
            ByteBuffer dup = msg.duplicate();
            byte[] data = new byte[dup.remaining()];
            dup.get(data);
            Binary bin = new Binary(data);
            this.RAW_LOGGER.fine("RECV[" + this.getRemoteAddress() + "] : " + bin.toString());
        }
        this._readBytes += (long)msg.remaining();
        switch (this._state) {
            case A: {
                if (!msg.hasRemaining()) break;
                msg.get();
            }
            case M: {
                if (msg.hasRemaining()) {
                    msg.get();
                } else {
                    this._state = State.M;
                    break;
                }
            }
            case Q: {
                if (msg.hasRemaining()) {
                    msg.get();
                } else {
                    this._state = State.Q;
                    break;
                }
            }
            case P: {
                if (msg.hasRemaining()) {
                    msg.get();
                } else {
                    this._state = State.P;
                    break;
                }
            }
            case PROTOCOL: {
                if (msg.hasRemaining()) {
                    msg.get();
                } else {
                    this._state = State.PROTOCOL;
                    break;
                }
            }
            case MAJOR: {
                if (msg.hasRemaining()) {
                    this._major = msg.get();
                } else {
                    this._state = State.MAJOR;
                    break;
                }
            }
            case MINOR: {
                if (msg.hasRemaining()) {
                    this._minor = msg.get();
                } else {
                    this._state = State.MINOR;
                    break;
                }
            }
            case REVISION: {
                if (msg.hasRemaining()) {
                    this._revision = msg.get();
                    this._state = State.FRAME;
                } else {
                    this._state = State.REVISION;
                    break;
                }
            }
            case FRAME: {
                if (!msg.hasRemaining()) break;
                this._frameHandler = this._frameHandler.parse(msg);
            }
        }
    }

    public void exception(Throwable t) {
        t.printStackTrace();
    }

    public void closed() {
        this._conn.inputClosed();
        if (this._conn != null && this._conn.getConnectionEventListener() != null) {
            ((Connection_1_0)this._conn.getConnectionEventListener()).closed();
        }
    }

    public long getCreateTime() {
        return this._createTime;
    }

    public boolean canSend() {
        return true;
    }

    public void send(AMQFrame amqFrame) {
        this.send(amqFrame, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(AMQFrame amqFrame, ByteBuffer buf) {
        Object object = this._sendLock;
        synchronized (object) {
            this._lastWriteTime = System.currentTimeMillis();
            if (FRAME_LOGGER.isLoggable(Level.FINE)) {
                FRAME_LOGGER.fine("SEND[" + this.getRemoteAddress() + "|" + amqFrame.getChannel() + "] : " + amqFrame.getFrameBody());
            }
            this._frameWriter.setValue(amqFrame);
            ByteBuffer dup = ByteBuffer.allocate(this._conn.getMaxFrameSize());
            int size = this._frameWriter.writeToBuffer(dup);
            if (size > this._conn.getMaxFrameSize()) {
                throw new OversizeFrameException(amqFrame, size);
            }
            dup.flip();
            this._writtenBytes += (long)dup.limit();
            if (this.RAW_LOGGER.isLoggable(Level.FINE)) {
                ByteBuffer dup2 = dup.duplicate();
                byte[] data = new byte[dup2.remaining()];
                dup2.get(data);
                Binary bin = new Binary(data);
                this.RAW_LOGGER.fine("SEND[" + this.getRemoteAddress() + "] : " + bin.toString());
            }
            this._sender.send((Object)dup);
            this._sender.flush();
        }
    }

    public void send(short channel, FrameBody body) {
        TransportFrame frame = AMQFrame.createAMQFrame((short)channel, (FrameBody)body);
        this.send((AMQFrame)frame);
    }

    public void close() {
        this._sender.close();
    }

    public void setLogOutput(PrintWriter out) {
        this._out = out;
    }

    public long getConnectionId() {
        return this._connectionId;
    }

    public long getLastReadTime() {
        return this._lastReadTime;
    }

    public long getLastWriteTime() {
        return this._lastWriteTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        A,
        M,
        Q,
        P,
        PROTOCOL,
        MAJOR,
        MINOR,
        REVISION,
        FRAME;

    }
}

