/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.List;
import org.apache.qpid.AMQException;
import org.apache.qpid.amqp_1_0.type.Outcome;
import org.apache.qpid.amqp_1_0.type.messaging.Accepted;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusExpiryPolicy;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.queue.BaseQueue;
import org.apache.qpid.server.txn.ServerTransaction;

public class ExchangeDestination
implements ReceivingDestination,
SendingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED};
    private Exchange _exchange;
    private TerminusDurability _durability;
    private TerminusExpiryPolicy _expiryPolicy;

    public ExchangeDestination(Exchange exchange, TerminusDurability durable, TerminusExpiryPolicy expiryPolicy) {
        this._exchange = exchange;
        this._durability = durable;
        this._expiryPolicy = expiryPolicy;
    }

    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    public Outcome send(final Message_1_0 message, ServerTransaction txn) {
        final List<? extends BaseQueue> queues = this._exchange.route(message);
        txn.enqueue(queues, message, new ServerTransaction.Action(){
            BaseQueue[] _queues;
            {
                this._queues = queues.toArray(new BaseQueue[queues.size()]);
            }

            public void postCommit() {
                for (int i = 0; i < this._queues.length; ++i) {
                    try {
                        this._queues[i].enqueue(message);
                        continue;
                    }
                    catch (AMQException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onRollback() {
            }
        }, System.currentTimeMillis());
        return ACCEPTED;
    }

    TerminusDurability getDurability() {
        return this._durability;
    }

    TerminusExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    public int getCredit() {
        return 20000;
    }

    public Exchange getExchange() {
        return this._exchange;
    }
}

