/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.amqp_1_0.transport.LinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.LinkEventListener;
import org.apache.qpid.amqp_1_0.transport.ReceivingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SendingLinkEndpoint;
import org.apache.qpid.amqp_1_0.transport.SessionEventListener;
import org.apache.qpid.amqp_1_0.type.AmqpErrorException;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.ErrorCondition;
import org.apache.qpid.amqp_1_0.type.LifetimePolicy;
import org.apache.qpid.amqp_1_0.type.Source;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.DeleteOnClose;
import org.apache.qpid.amqp_1_0.type.messaging.DeleteOnNoLinks;
import org.apache.qpid.amqp_1_0.type.messaging.DeleteOnNoLinksOrMessages;
import org.apache.qpid.amqp_1_0.type.messaging.DeleteOnNoMessages;
import org.apache.qpid.amqp_1_0.type.messaging.Target;
import org.apache.qpid.amqp_1_0.type.messaging.TerminusDurability;
import org.apache.qpid.amqp_1_0.type.transaction.Coordinator;
import org.apache.qpid.amqp_1_0.type.transaction.TxnCapability;
import org.apache.qpid.amqp_1_0.type.transport.AmqpError;
import org.apache.qpid.amqp_1_0.type.transport.End;
import org.apache.qpid.amqp_1_0.type.transport.Error;
import org.apache.qpid.amqp_1_0.type.transport.Role;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.logging.LogSubject;
import org.apache.qpid.server.message.InboundMessage;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v1_0.Connection_1_0;
import org.apache.qpid.server.protocol.v1_0.ExchangeDestination;
import org.apache.qpid.server.protocol.v1_0.LinkRegistry;
import org.apache.qpid.server.protocol.v1_0.Link_1_0;
import org.apache.qpid.server.protocol.v1_0.QueueDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingDestination;
import org.apache.qpid.server.protocol.v1_0.ReceivingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.ReceivingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.SendingLinkAttachment;
import org.apache.qpid.server.protocol.v1_0.SendingLink_1_0;
import org.apache.qpid.server.protocol.v1_0.TxnCoordinatorLink_1_0;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.txn.AutoCommitTransaction;
import org.apache.qpid.server.txn.ServerTransaction;
import org.apache.qpid.server.virtualhost.VirtualHost;

public class Session_1_0
implements SessionEventListener,
AMQSessionModel,
LogSubject {
    private static final Symbol LIFETIME_POLICY = Symbol.valueOf((String)"lifetime-policy");
    private IApplicationRegistry _appRegistry;
    private VirtualHost _vhost;
    private AutoCommitTransaction _transaction;
    private final LinkedHashMap<Integer, ServerTransaction> _openTransactions = new LinkedHashMap();
    private final Connection_1_0 _connection;
    private UUID _id = UUID.randomUUID();

    public Session_1_0(VirtualHost vhost, IApplicationRegistry appRegistry, Connection_1_0 connection) {
        this._appRegistry = appRegistry;
        this._vhost = vhost;
        this._transaction = new AutoCommitTransaction(vhost.getMessageStore());
        this._connection = connection;
    }

    public void remoteLinkCreation(LinkEndpoint endpoint) {
        Link_1_0 link = null;
        Error error = null;
        LinkRegistry linkRegistry = this._vhost.getLinkRegistry(endpoint.getSession().getConnection().getRemoteContainerId());
        if (endpoint.getRole() == Role.SENDER) {
            SendingLink_1_0 previousLink = linkRegistry.getDurableSendingLink(endpoint.getName());
            if (previousLink == null) {
                SendingDestination destination;
                Target target = (Target)endpoint.getTarget();
                org.apache.qpid.amqp_1_0.type.messaging.Source source = (org.apache.qpid.amqp_1_0.type.messaging.Source)endpoint.getSource();
                if (source != null) {
                    if (Boolean.TRUE.equals(source.getDynamic())) {
                        AMQQueue tempQueue = this.createTemporaryQueue(source.getDynamicNodeProperties());
                        source.setAddress(tempQueue.getName());
                    }
                    String addr = source.getAddress();
                    AMQQueue queue = this._vhost.getQueueRegistry().getQueue(addr);
                    if (queue != null) {
                        destination = new QueueDestination(queue);
                    } else {
                        Exchange exchg = this._vhost.getExchangeRegistry().getExchange(addr);
                        if (exchg != null) {
                            destination = new ExchangeDestination(exchg, source.getDurable(), source.getExpiryPolicy());
                        } else {
                            endpoint.setSource(null);
                            destination = null;
                        }
                    }
                } else {
                    destination = null;
                }
                if (destination != null) {
                    SendingLinkEndpoint sendingLinkEndpoint = (SendingLinkEndpoint)endpoint;
                    try {
                        SendingLink_1_0 sendingLink = new SendingLink_1_0(new SendingLinkAttachment(this, sendingLinkEndpoint), this._vhost, destination);
                        sendingLinkEndpoint.setLinkEventListener((LinkEventListener)sendingLink);
                        link = sendingLink;
                        if (TerminusDurability.UNSETTLED_STATE.equals(source.getDurable())) {
                            linkRegistry.registerSendingLink(endpoint.getName(), sendingLink);
                        }
                    }
                    catch (AmqpErrorException e) {
                        e.printStackTrace();
                        destination = null;
                        sendingLinkEndpoint.setSource(null);
                        error = e.getError();
                    }
                }
            } else {
                TerminusDurability newSourceDurable;
                org.apache.qpid.amqp_1_0.type.messaging.Source newSource = (org.apache.qpid.amqp_1_0.type.messaging.Source)endpoint.getSource();
                org.apache.qpid.amqp_1_0.type.messaging.Source oldSource = (org.apache.qpid.amqp_1_0.type.messaging.Source)previousLink.getEndpoint().getSource();
                TerminusDurability terminusDurability = newSourceDurable = newSource == null ? null : newSource.getDurable();
                if (newSourceDurable != null) {
                    oldSource.setDurable(newSourceDurable);
                    if (newSourceDurable.equals(TerminusDurability.NONE)) {
                        linkRegistry.unregisterSendingLink(endpoint.getName());
                    }
                }
                endpoint.setSource((Source)oldSource);
                SendingLinkEndpoint sendingLinkEndpoint = (SendingLinkEndpoint)endpoint;
                previousLink.setLinkAttachment(new SendingLinkAttachment(this, sendingLinkEndpoint));
                sendingLinkEndpoint.setLinkEventListener((LinkEventListener)previousLink);
                link = previousLink;
                endpoint.setLocalUnsettled(previousLink.getUnsettledOutcomeMap());
            }
        } else if (endpoint.getTarget() instanceof Coordinator) {
            Coordinator coordinator = (Coordinator)endpoint.getTarget();
            TxnCapability[] capabilities = coordinator.getCapabilities();
            boolean localTxn = false;
            boolean multiplePerSession = false;
            if (capabilities != null) {
                for (TxnCapability capability : capabilities) {
                    if (capability.equals(TxnCapability.LOCAL_TXN)) {
                        localTxn = true;
                        continue;
                    }
                    if (capability.equals(TxnCapability.MULTI_TXNS_PER_SSN)) {
                        multiplePerSession = true;
                        continue;
                    }
                    error = new Error();
                    error.setCondition((ErrorCondition)AmqpError.NOT_IMPLEMENTED);
                    error.setDescription("Unsupported capability: " + capability);
                    break;
                }
            }
            ReceivingLinkEndpoint receivingLinkEndpoint = (ReceivingLinkEndpoint)endpoint;
            TxnCoordinatorLink_1_0 coordinatorLink = new TxnCoordinatorLink_1_0(this._vhost, this, receivingLinkEndpoint, this._openTransactions);
            receivingLinkEndpoint.setLinkEventListener((LinkEventListener)coordinatorLink);
            link = coordinatorLink;
        } else {
            ReceivingLink_1_0 previousLink = linkRegistry.getDurableReceivingLink(endpoint.getName());
            if (previousLink == null) {
                SendingDestination destination;
                Target target = (Target)endpoint.getTarget();
                if (target != null) {
                    if (Boolean.TRUE.equals(target.getDynamic())) {
                        AMQQueue tempQueue = this.createTemporaryQueue(target.getDynamicNodeProperties());
                        target.setAddress(tempQueue.getName());
                    }
                    String addr = target.getAddress();
                    Exchange exchg = this._vhost.getExchangeRegistry().getExchange(addr);
                    if (exchg != null) {
                        destination = new ExchangeDestination(exchg, target.getDurable(), target.getExpiryPolicy());
                    } else {
                        AMQQueue queue = this._vhost.getQueueRegistry().getQueue(addr);
                        if (queue != null) {
                            destination = new QueueDestination(queue);
                        } else {
                            endpoint.setTarget(null);
                            destination = null;
                        }
                    }
                } else {
                    destination = null;
                }
                if (destination != null) {
                    ReceivingLinkEndpoint receivingLinkEndpoint = (ReceivingLinkEndpoint)endpoint;
                    ReceivingLink_1_0 receivingLink = new ReceivingLink_1_0(new ReceivingLinkAttachment(this, receivingLinkEndpoint), this._vhost, (ReceivingDestination)((Object)destination));
                    receivingLinkEndpoint.setLinkEventListener((LinkEventListener)receivingLink);
                    link = receivingLink;
                    if (TerminusDurability.UNSETTLED_STATE.equals(target.getDurable())) {
                        linkRegistry.registerReceivingLink(endpoint.getName(), receivingLink);
                    }
                }
            } else {
                ReceivingLinkEndpoint receivingLinkEndpoint = (ReceivingLinkEndpoint)endpoint;
                previousLink.setLinkAttachment(new ReceivingLinkAttachment(this, receivingLinkEndpoint));
                receivingLinkEndpoint.setLinkEventListener((LinkEventListener)previousLink);
                link = previousLink;
                endpoint.setLocalUnsettled(previousLink.getUnsettledOutcomeMap());
            }
        }
        endpoint.attach();
        if (link == null) {
            if (error == null) {
                error = new Error();
                error.setCondition((ErrorCondition)AmqpError.NOT_FOUND);
            }
            endpoint.detach(error);
        } else {
            link.start();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AMQQueue createTemporaryQueue(Map properties) {
        final String queueName = UUID.randomUUID().toString();
        AMQQueue queue = null;
        try {
            LifetimePolicy lifetimePolicy = properties == null ? null : (LifetimePolicy)properties.get(LIFETIME_POLICY);
            final AMQQueue tempQueue = queue = AMQQueueFactory.createAMQQueueImpl(UUIDGenerator.generateQueueUUID(queueName, this._vhost.getName()), queueName, false, null, false, false, this._vhost, properties);
            if (lifetimePolicy == null || lifetimePolicy instanceof DeleteOnClose) {
                final Connection_1_0.Task deleteQueueTask = new Connection_1_0.Task(){

                    public void doTask(Connection_1_0 session) {
                        if (Session_1_0.this._vhost.getQueueRegistry().getQueue(queueName) == tempQueue) {
                            try {
                                tempQueue.delete();
                            }
                            catch (AMQException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                };
                this._connection.addConnectionCloseTask(deleteQueueTask);
                queue.addQueueDeleteTask(new AMQQueue.Task(){

                    public void doTask(AMQQueue queue) {
                        Session_1_0.this._connection.removeConnectionCloseTask(deleteQueueTask);
                    }
                });
                return queue;
            }
            if (!(lifetimePolicy instanceof DeleteOnNoLinks) && !(lifetimePolicy instanceof DeleteOnNoMessages) && !(lifetimePolicy instanceof DeleteOnNoLinksOrMessages)) return queue;
        }
        catch (AMQSecurityException e) {
            e.printStackTrace();
            return queue;
        }
        catch (AMQException e) {
            e.printStackTrace();
        }
        return queue;
    }

    public ServerTransaction getTransaction(Binary transactionId) {
        ServerTransaction transaction = this._openTransactions.get(this.binaryToInteger(transactionId));
        return transaction == null ? this._transaction : transaction;
    }

    public void remoteEnd(End end) {
        Iterator<Map.Entry<Integer, ServerTransaction>> iter = this._openTransactions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, ServerTransaction> entry = iter.next();
            entry.getValue().rollback();
            iter.remove();
        }
        this._connection.sessionEnded(this);
    }

    Integer binaryToInteger(Binary txnId) {
        if (txnId == null) {
            return null;
        }
        if (txnId.getLength() > 4) {
            throw new IllegalArgumentException();
        }
        int id = 0;
        byte[] data = txnId.getArray();
        for (int i = 0; i < txnId.getLength(); ++i) {
            id <<= 8;
            id += data[i + txnId.getArrayOffset()];
        }
        return id;
    }

    Binary integerToBinary(int txnId) {
        byte[] data = new byte[4];
        data[3] = (byte)(txnId & 0xFF);
        data[2] = (byte)((txnId & 0xFF00) >> 8);
        data[1] = (byte)((txnId & 0xFF0000) >> 16);
        data[0] = (byte)((txnId & 0xFF000000) >> 24);
        return new Binary(data);
    }

    public void forceEnd() {
    }

    public UUID getId() {
        return this._id;
    }

    public AMQConnectionModel getConnectionModel() {
        return this._connection.getModel();
    }

    public String getClientID() {
        return "";
    }

    public void close() throws AMQException {
    }

    public LogSubject getLogSubject() {
        return this;
    }

    public void checkTransactionStatus(long openWarn, long openClose, long idleWarn, long idleClose) throws AMQException {
    }

    public void block(AMQQueue queue) {
    }

    public void unblock(AMQQueue queue) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public boolean getBlocking() {
        return false;
    }

    public boolean onSameConnection(InboundMessage inbound) {
        return false;
    }

    public int getUnacknowledgedMessageCount() {
        return 0;
    }

    public Long getTxnCount() {
        return 0L;
    }

    public Long getTxnStart() {
        return 0L;
    }

    public Long getTxnCommits() {
        return 0L;
    }

    public Long getTxnRejects() {
        return 0L;
    }

    public int getChannelId() {
        return 0;
    }

    public int getConsumerCount() {
        return 0;
    }

    public String toLogString() {
        long connectionId = this.getConnectionModel().getConnectionId();
        String remoteAddress = this.getConnectionModel().getRemoteAddressString();
        return "[" + MessageFormat.format("con:{0}({1}@{2}/{3})/ch:{4}", connectionId, this.getClientID(), remoteAddress, this._vhost.getName(), 0) + "] ";
    }

    public int compareTo(AMQSessionModel o) {
        return this.getId().compareTo(o.getId());
    }
}

