/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQSecurityException;
import org.apache.qpid.exchange.ExchangeDefaults;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.queue.AMQPriorityQueue;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.ConflationQueue;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.queue.SimpleAMQQueue;
import org.apache.qpid.server.queue.SortedQueue;
import org.apache.qpid.server.registry.ApplicationRegistry;
import org.apache.qpid.server.virtualhost.VirtualHost;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMQQueueFactory {
    public static final String X_QPID_PRIORITIES = "x-qpid-priorities";
    public static final String X_QPID_DESCRIPTION = "x-qpid-description";
    public static final String QPID_LVQ_KEY = "qpid.LVQ_key";
    public static final String QPID_LAST_VALUE_QUEUE = "qpid.last_value_queue";
    public static final String QPID_LAST_VALUE_QUEUE_KEY = "qpid.last_value_queue_key";
    public static final String QPID_QUEUE_SORT_KEY = "qpid.queue_sort_key";
    public static final String DLQ_ROUTING_KEY = "dlq";
    public static final String X_QPID_DLQ_ENABLED = "x-qpid-dlq-enabled";
    public static final String X_QPID_MAXIMUM_DELIVERY_COUNT = "x-qpid-maximum-delivery-count";
    public static final String DEFAULT_DLQ_NAME_SUFFIX = "_DLQ";
    private static final QueueProperty[] DECLAREABLE_PROPERTIES = new QueueProperty[]{new QueueLongProperty("x-qpid-maximum-message-age"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMaximumMessageAge(value);
        }
    }, new QueueLongProperty("x-qpid-maximum-message-size"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMaximumMessageSize(value);
        }
    }, new QueueLongProperty("x-qpid-maximum-message-count"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMaximumMessageCount(value);
        }
    }, new QueueLongProperty("x-qpid-minimum-alert-repeat-gap"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setMinimumAlertRepeatGap(value);
        }
    }, new QueueLongProperty("x-qpid-capacity"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setCapacity(value);
        }
    }, new QueueLongProperty("x-qpid-flow-resume-capacity"){

        public void setPropertyValue(AMQQueue queue, long value) {
            queue.setFlowResumeCapacity(value);
        }
    }, new QueueIntegerProperty("x-qpid-maximum-delivery-count"){

        public void setPropertyValue(AMQQueue queue, int value) {
            queue.setMaximumDeliveryCount(value);
        }
    }};

    private AMQQueueFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQQueue createAMQQueueImpl(UUID id, String queueName, boolean durable, String owner, boolean autoDelete, boolean exclusive, VirtualHost virtualHost, Map<String, Object> arguments) throws AMQSecurityException, AMQException {
        if (id == null) {
            throw new IllegalArgumentException("Queue id must not be null");
        }
        if (queueName == null) {
            throw new IllegalArgumentException("Queue name must not be null");
        }
        if (!virtualHost.getSecurityManager().authoriseCreateQueue(autoDelete, durable, exclusive, null, null, new AMQShortString(queueName), owner)) {
            String description = "Permission denied: queue-name '" + queueName + "'";
            throw new AMQSecurityException(description);
        }
        QueueConfiguration queueConfiguration = virtualHost.getConfiguration().getQueueConfiguration(queueName);
        boolean isDLQEnabled = AMQQueueFactory.isDLQEnabled(autoDelete, arguments, queueConfiguration);
        if (isDLQEnabled) {
            AMQQueueFactory.validateDLNames(queueName);
        }
        int priorities = 1;
        String conflationKey = null;
        String sortingKey = null;
        if (arguments != null) {
            if (arguments.containsKey(QPID_LAST_VALUE_QUEUE) || arguments.containsKey(QPID_LAST_VALUE_QUEUE_KEY)) {
                conflationKey = (String)arguments.get(QPID_LAST_VALUE_QUEUE_KEY);
                if (conflationKey == null) {
                    conflationKey = QPID_LVQ_KEY;
                }
            } else if (arguments.containsKey(X_QPID_PRIORITIES)) {
                Object prioritiesObj = arguments.get(X_QPID_PRIORITIES);
                if (prioritiesObj instanceof Number) {
                    priorities = ((Number)prioritiesObj).intValue();
                }
            } else if (arguments.containsKey(QPID_QUEUE_SORT_KEY)) {
                sortingKey = (String)arguments.get(QPID_QUEUE_SORT_KEY);
            }
        }
        SimpleAMQQueue q = sortingKey != null ? new SortedQueue(id, queueName, durable, owner, autoDelete, exclusive, virtualHost, arguments, sortingKey) : (conflationKey != null ? new ConflationQueue(id, queueName, durable, owner, autoDelete, exclusive, virtualHost, arguments, conflationKey) : (priorities > 1 ? new AMQPriorityQueue(id, queueName, durable, owner, autoDelete, exclusive, virtualHost, arguments, priorities) : new SimpleAMQQueue(id, queueName, durable, owner, autoDelete, exclusive, virtualHost, arguments)));
        virtualHost.getQueueRegistry().registerQueue(q);
        q.configure(virtualHost.getConfiguration().getQueueConfiguration(queueName));
        if (arguments != null) {
            for (QueueProperty p : DECLAREABLE_PROPERTIES) {
                if (!arguments.containsKey(p.getArgumentName().toString())) continue;
                p.setPropertyValue(q, arguments.get(p.getArgumentName().toString()));
            }
        }
        if (isDLQEnabled) {
            String dlExchangeName = AMQQueueFactory.getDeadLetterExchangeName(queueName);
            String dlQueueName = AMQQueueFactory.getDeadLetterQueueName(queueName);
            ExchangeRegistry exchangeRegistry = virtualHost.getExchangeRegistry();
            ExchangeFactory exchangeFactory = virtualHost.getExchangeFactory();
            QueueRegistry queueRegistry = virtualHost.getQueueRegistry();
            Exchange dlExchange = null;
            ExchangeRegistry exchangeRegistry2 = exchangeRegistry;
            synchronized (exchangeRegistry2) {
                dlExchange = exchangeRegistry.getExchange(dlExchangeName);
                if (dlExchange == null) {
                    dlExchange = exchangeFactory.createExchange(UUIDGenerator.generateExchangeUUID(dlExchangeName, virtualHost.getName()), new AMQShortString(dlExchangeName), ExchangeDefaults.FANOUT_EXCHANGE_CLASS, true, false, 0);
                    exchangeRegistry.registerExchange(dlExchange);
                    virtualHost.getMessageStore().createExchange(dlExchange);
                }
            }
            AMQQueue dlQueue = null;
            QueueRegistry queueRegistry2 = queueRegistry;
            synchronized (queueRegistry2) {
                dlQueue = queueRegistry.getQueue(dlQueueName);
                if (dlQueue == null) {
                    HashMap<String, Object> args = new HashMap<String, Object>();
                    args.put(X_QPID_DLQ_ENABLED, false);
                    args.put(X_QPID_MAXIMUM_DELIVERY_COUNT, 0);
                    dlQueue = AMQQueueFactory.createAMQQueueImpl(UUIDGenerator.generateQueueUUID(dlQueueName, virtualHost.getName()), dlQueueName, true, owner, false, exclusive, virtualHost, args);
                    virtualHost.getMessageStore().createQueue(dlQueue, FieldTable.convertToFieldTable(args));
                }
            }
            if (!dlExchange.isBound(DLQ_ROUTING_KEY, dlQueue)) {
                virtualHost.getBindingFactory().addBinding(DLQ_ROUTING_KEY, dlQueue, dlExchange, null);
            }
            q.setAlternateExchange(dlExchange);
        }
        return q;
    }

    public static AMQQueue createAMQQueueImpl(QueueConfiguration config, VirtualHost host) throws AMQException {
        String queueName = config.getName();
        boolean durable = config.getDurable();
        boolean autodelete = config.getAutoDelete();
        boolean exclusive = config.getExclusive();
        String owner = config.getOwner();
        Map<String, Object> arguments = AMQQueueFactory.createQueueArgumentsFromConfig(config);
        UUID id = UUIDGenerator.generateQueueUUID(queueName, host.getName());
        AMQQueue q = AMQQueueFactory.createAMQQueueImpl(id, queueName, durable, owner, autodelete, exclusive, host, arguments);
        q.configure(config);
        return q;
    }

    protected static void validateDLNames(String name) {
        String exchangeName = AMQQueueFactory.getDeadLetterExchangeName(name);
        if (exchangeName.length() > 255) {
            throw new IllegalArgumentException("DL exchange name '" + exchangeName + "' length exceeds limit of " + 255 + " characters for queue " + name);
        }
        String queueName = AMQQueueFactory.getDeadLetterQueueName(name);
        if (queueName.length() > 255) {
            throw new IllegalArgumentException("DLQ queue name '" + queueName + "' length exceeds limit of " + 255 + " characters for queue " + name);
        }
    }

    protected static boolean isDLQEnabled(boolean autoDelete, Map<String, Object> arguments, QueueConfiguration qConfig) {
        if (!autoDelete) {
            boolean dlqArgumentPresent;
            boolean bl = dlqArgumentPresent = arguments != null && arguments.containsKey(X_QPID_DLQ_ENABLED);
            if (dlqArgumentPresent || qConfig.isDeadLetterQueueEnabled()) {
                boolean dlqEnabled = true;
                if (dlqArgumentPresent) {
                    Object argument = arguments.get(X_QPID_DLQ_ENABLED);
                    dlqEnabled = argument instanceof Boolean && (Boolean)argument != false;
                }
                return dlqEnabled;
            }
        }
        return false;
    }

    protected static String getDeadLetterQueueName(String name) {
        ServerConfiguration serverConfig = ApplicationRegistry.getInstance().getConfiguration();
        String dlQueueName = name + serverConfig.getDeadLetterQueueSuffix();
        return dlQueueName;
    }

    protected static String getDeadLetterExchangeName(String name) {
        ServerConfiguration serverConfig = ApplicationRegistry.getInstance().getConfiguration();
        String dlExchangeName = name + serverConfig.getDeadLetterExchangeSuffix();
        return dlExchangeName;
    }

    private static Map<String, Object> createQueueArgumentsFromConfig(QueueConfiguration config) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        if (config.isLVQ() || config.getLVQKey() != null) {
            arguments.put(QPID_LAST_VALUE_QUEUE, 1);
            arguments.put(QPID_LAST_VALUE_QUEUE_KEY, config.getLVQKey() == null ? QPID_LVQ_KEY : config.getLVQKey());
        } else if (config.getPriority() || config.getPriorities() > 0) {
            arguments.put(X_QPID_PRIORITIES, config.getPriorities() < 0 ? 10 : config.getPriorities());
        } else if (config.getQueueSortKey() != null && !"".equals(config.getQueueSortKey())) {
            arguments.put(QPID_QUEUE_SORT_KEY, config.getQueueSortKey());
        }
        if (!config.getAutoDelete() && config.isDeadLetterQueueEnabled()) {
            arguments.put(X_QPID_DLQ_ENABLED, true);
        }
        if (config.getDescription() != null && !"".equals(config.getDescription())) {
            arguments.put(X_QPID_DESCRIPTION, config.getDescription());
        }
        if (arguments.isEmpty()) {
            return Collections.emptyMap();
        }
        return arguments;
    }

    private static abstract class QueueIntegerProperty
    extends QueueProperty {
        public QueueIntegerProperty(String argumentName) {
            super(argumentName);
        }

        public void setPropertyValue(AMQQueue queue, Object value) {
            if (value instanceof Number) {
                this.setPropertyValue(queue, ((Number)value).intValue());
            }
        }

        abstract void setPropertyValue(AMQQueue var1, int var2);
    }

    private static abstract class QueueLongProperty
    extends QueueProperty {
        public QueueLongProperty(String argumentName) {
            super(argumentName);
        }

        public void setPropertyValue(AMQQueue queue, Object value) {
            if (value instanceof Number) {
                this.setPropertyValue(queue, ((Number)value).longValue());
            }
        }

        abstract void setPropertyValue(AMQQueue var1, long var2);
    }

    private static abstract class QueueProperty {
        private final AMQShortString _argumentName;

        public QueueProperty(String argumentName) {
            this._argumentName = new AMQShortString(argumentName);
        }

        public AMQShortString getArgumentName() {
            return this._argumentName;
        }

        public abstract void setPropertyValue(AMQQueue var1, Object var2);
    }
}

