/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.QueueEntryListFactory;
import org.apache.qpid.server.queue.SimpleQueueEntryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleQueueEntryList
implements QueueEntryList<SimpleQueueEntryImpl> {
    private final SimpleQueueEntryImpl _head;
    private volatile SimpleQueueEntryImpl _tail;
    static final AtomicReferenceFieldUpdater<SimpleQueueEntryList, SimpleQueueEntryImpl> _tailUpdater = AtomicReferenceFieldUpdater.newUpdater(SimpleQueueEntryList.class, SimpleQueueEntryImpl.class, "_tail");
    private final AMQQueue _queue;
    static final AtomicReferenceFieldUpdater<SimpleQueueEntryImpl, SimpleQueueEntryImpl> _nextUpdater = SimpleQueueEntryImpl._nextUpdater;
    private AtomicLong _scavenges = new AtomicLong(0L);
    private final long _scavengeCount = Integer.getInteger("qpid.queue.scavenge_count", 50).intValue();
    private final AtomicReference<SimpleQueueEntryImpl> _unscavengedHWM = new AtomicReference();

    public SimpleQueueEntryList(AMQQueue queue) {
        this._queue = queue;
        this._tail = this._head = new SimpleQueueEntryImpl(this);
    }

    void scavenge() {
        SimpleQueueEntryImpl hwm = this._unscavengedHWM.getAndSet(null);
        if (hwm != null) {
            for (SimpleQueueEntryImpl next = this._head.getNextValidEntry(); next != null && hwm.compareTo(next) > 0; next = next.getNextValidEntry()) {
            }
        }
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    @Override
    public SimpleQueueEntryImpl add(ServerMessage message) {
        SimpleQueueEntryImpl node = this.createQueueEntry(message);
        while (true) {
            SimpleQueueEntryImpl tail = this._tail;
            SimpleQueueEntryImpl next = tail.getNextNode();
            if (tail != this._tail) continue;
            if (next == null) {
                node.setEntryId(tail.getEntryId() + 1L);
                if (!_nextUpdater.compareAndSet(tail, null, node)) continue;
                _tailUpdater.compareAndSet(this, tail, node);
                return node;
            }
            _tailUpdater.compareAndSet(this, tail, next);
        }
    }

    protected SimpleQueueEntryImpl createQueueEntry(ServerMessage<?> message) {
        return new SimpleQueueEntryImpl(this, message);
    }

    @Override
    public SimpleQueueEntryImpl next(SimpleQueueEntryImpl node) {
        return node.getNextValidEntry();
    }

    public QueueEntryIteratorImpl iterator() {
        return new QueueEntryIteratorImpl(this._head);
    }

    @Override
    public SimpleQueueEntryImpl getHead() {
        return this._head;
    }

    @Override
    public void entryDeleted(SimpleQueueEntryImpl queueEntry) {
        SimpleQueueEntryImpl newNext;
        SimpleQueueEntryImpl next = this._head.getNextNode();
        if (next == (newNext = this._head.getNextValidEntry())) {
            SimpleQueueEntryImpl unscavengedHWM = this._unscavengedHWM.get();
            while (unscavengedHWM == null || unscavengedHWM.compareTo(queueEntry) < 0) {
                this._unscavengedHWM.compareAndSet(unscavengedHWM, queueEntry);
                unscavengedHWM = this._unscavengedHWM.get();
            }
            if (this._scavenges.incrementAndGet() > this._scavengeCount) {
                this._scavenges.set(0L);
                this.scavenge();
            }
        } else {
            SimpleQueueEntryImpl unscavengedHWM = this._unscavengedHWM.get();
            if (unscavengedHWM != null && (next == null || unscavengedHWM.compareTo(next) < 0)) {
                this._unscavengedHWM.compareAndSet(unscavengedHWM, null);
            }
        }
    }

    @Override
    public int getPriorities() {
        return 0;
    }

    static class Factory
    implements QueueEntryListFactory {
        Factory() {
        }

        public SimpleQueueEntryList createQueueEntryList(AMQQueue queue) {
            return new SimpleQueueEntryList(queue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QueueEntryIteratorImpl
    implements QueueEntryIterator<SimpleQueueEntryImpl> {
        private SimpleQueueEntryImpl _lastNode;

        QueueEntryIteratorImpl(SimpleQueueEntryImpl startNode) {
            this._lastNode = startNode;
        }

        @Override
        public boolean atTail() {
            return this._lastNode.getNextValidEntry() == null;
        }

        @Override
        public SimpleQueueEntryImpl getNode() {
            return this._lastNode;
        }

        @Override
        public boolean advance() {
            SimpleQueueEntryImpl nextValidNode = this._lastNode.getNextValidEntry();
            if (nextValidNode != null) {
                this._lastNode = nextValidNode;
            }
            return nextValidNode != null;
        }
    }
}

