/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.queue;

import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.QueueEntryIterator;
import org.apache.qpid.server.queue.QueueEntryList;
import org.apache.qpid.server.queue.SortedQueueEntryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedQueueEntryList
implements QueueEntryList<SortedQueueEntryImpl> {
    private final SortedQueueEntryImpl _head;
    private SortedQueueEntryImpl _root;
    private long _entryId = Long.MIN_VALUE;
    private final Object _lock = new Object();
    private final AMQQueue _queue;
    private final String _propertyName;

    public SortedQueueEntryList(AMQQueue queue, String propertyName) {
        this._queue = queue;
        this._head = new SortedQueueEntryImpl(this);
        this._propertyName = propertyName;
    }

    @Override
    public AMQQueue getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedQueueEntryImpl add(ServerMessage message) {
        Object object = this._lock;
        synchronized (object) {
            String key = null;
            Object val = message.getMessageHeader().getHeader(this._propertyName);
            if (val != null) {
                key = val.toString();
            }
            SortedQueueEntryImpl entry = new SortedQueueEntryImpl(this, message, ++this._entryId);
            entry.setKey(key);
            this.insert(entry);
            return entry;
        }
    }

    private void insert(SortedQueueEntryImpl entry) {
        SortedQueueEntryImpl node = this._root;
        node = this._root;
        if (node == null) {
            this._root = entry;
            this._head.setNext(entry);
            entry.setPrev(this._head);
            return;
        }
        SortedQueueEntryImpl parent = null;
        while (node != null) {
            parent = node;
            if (entry.compareTo(node) < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        entry.setParent(parent);
        if (entry.compareTo(parent) < 0) {
            parent.setLeft(entry);
            SortedQueueEntryImpl prev = parent.getPrev();
            entry.setNext(parent);
            prev.setNext(entry);
            entry.setPrev(prev);
            parent.setPrev(entry);
        } else {
            parent.setRight(entry);
            SortedQueueEntryImpl next = parent.getNextValidEntry();
            entry.setNext(next);
            parent.setNext(entry);
            if (next != null) {
                next.setPrev(entry);
            }
            entry.setPrev(parent);
        }
        entry.setColour(SortedQueueEntryImpl.Colour.RED);
        this.insertFixup(entry);
    }

    private void insertFixup(SortedQueueEntryImpl entry) {
        while (this.isParentColour(entry, SortedQueueEntryImpl.Colour.RED)) {
            SortedQueueEntryImpl y;
            SortedQueueEntryImpl grandparent = this.nodeGrandparent(entry);
            if (this.nodeParent(entry) == this.leftChild(grandparent)) {
                y = this.rightChild(grandparent);
                if (this.isNodeColour(y, SortedQueueEntryImpl.Colour.RED)) {
                    this.setColour(this.nodeParent(entry), SortedQueueEntryImpl.Colour.BLACK);
                    this.setColour(y, SortedQueueEntryImpl.Colour.BLACK);
                    this.setColour(grandparent, SortedQueueEntryImpl.Colour.RED);
                    entry = grandparent;
                    continue;
                }
                if (entry == this.rightChild(this.nodeParent(entry))) {
                    entry = this.nodeParent(entry);
                    this.leftRotate(entry);
                }
                this.setColour(this.nodeParent(entry), SortedQueueEntryImpl.Colour.BLACK);
                this.setColour(this.nodeGrandparent(entry), SortedQueueEntryImpl.Colour.RED);
                this.rightRotate(this.nodeGrandparent(entry));
                continue;
            }
            y = this.leftChild(grandparent);
            if (this.isNodeColour(y, SortedQueueEntryImpl.Colour.RED)) {
                this.setColour(this.nodeParent(entry), SortedQueueEntryImpl.Colour.BLACK);
                this.setColour(y, SortedQueueEntryImpl.Colour.BLACK);
                this.setColour(grandparent, SortedQueueEntryImpl.Colour.RED);
                entry = grandparent;
                continue;
            }
            if (entry == this.leftChild(this.nodeParent(entry))) {
                entry = this.nodeParent(entry);
                this.rightRotate(entry);
            }
            this.setColour(this.nodeParent(entry), SortedQueueEntryImpl.Colour.BLACK);
            this.setColour(this.nodeGrandparent(entry), SortedQueueEntryImpl.Colour.RED);
            this.leftRotate(this.nodeGrandparent(entry));
        }
        this._root.setColour(SortedQueueEntryImpl.Colour.BLACK);
    }

    private void leftRotate(SortedQueueEntryImpl entry) {
        if (entry != null) {
            SortedQueueEntryImpl rightChild = this.rightChild(entry);
            entry.setRight(rightChild.getLeft());
            if (entry.getRight() != null) {
                entry.getRight().setParent(entry);
            }
            rightChild.setParent(entry.getParent());
            if (entry.getParent() == null) {
                this._root = rightChild;
            } else if (entry == entry.getParent().getLeft()) {
                entry.getParent().setLeft(rightChild);
            } else {
                entry.getParent().setRight(rightChild);
            }
            rightChild.setLeft(entry);
            entry.setParent(rightChild);
        }
    }

    private void rightRotate(SortedQueueEntryImpl entry) {
        if (entry != null) {
            SortedQueueEntryImpl leftChild = this.leftChild(entry);
            entry.setLeft(leftChild.getRight());
            if (entry.getLeft() != null) {
                leftChild.getRight().setParent(entry);
            }
            leftChild.setParent(entry.getParent());
            if (leftChild.getParent() == null) {
                this._root = leftChild;
            } else if (entry == entry.getParent().getRight()) {
                entry.getParent().setRight(leftChild);
            } else {
                entry.getParent().setLeft(leftChild);
            }
            leftChild.setRight(entry);
            entry.setParent(leftChild);
        }
    }

    private void setColour(SortedQueueEntryImpl node, SortedQueueEntryImpl.Colour colour) {
        if (node != null) {
            node.setColour(colour);
        }
    }

    private SortedQueueEntryImpl leftChild(SortedQueueEntryImpl node) {
        return node == null ? null : node.getLeft();
    }

    private SortedQueueEntryImpl rightChild(SortedQueueEntryImpl node) {
        return node == null ? null : node.getRight();
    }

    private SortedQueueEntryImpl nodeParent(SortedQueueEntryImpl node) {
        return node == null ? null : node.getParent();
    }

    private SortedQueueEntryImpl nodeGrandparent(SortedQueueEntryImpl node) {
        return this.nodeParent(this.nodeParent(node));
    }

    private boolean isParentColour(SortedQueueEntryImpl node, SortedQueueEntryImpl.Colour colour) {
        return node != null && this.isNodeColour(node.getParent(), colour);
    }

    protected boolean isNodeColour(SortedQueueEntryImpl node, SortedQueueEntryImpl.Colour colour) {
        return (node == null ? SortedQueueEntryImpl.Colour.BLACK : node.getColour()) == colour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortedQueueEntryImpl next(SortedQueueEntryImpl node) {
        Object object = this._lock;
        synchronized (object) {
            if (node.isDispensed() && this._head != node) {
                SortedQueueEntryImpl current = this._head;
                while (current != null) {
                    SortedQueueEntryImpl next = current.getNextValidEntry();
                    if (current.compareTo(node) > 0 && !current.isDispensed()) break;
                    current = next;
                }
                return current;
            }
            return node.getNextValidEntry();
        }
    }

    @Override
    public QueueEntryIterator<SortedQueueEntryImpl> iterator() {
        return new QueueEntryIteratorImpl(this._head);
    }

    @Override
    public SortedQueueEntryImpl getHead() {
        return this._head;
    }

    protected SortedQueueEntryImpl getRoot() {
        return this._root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryDeleted(SortedQueueEntryImpl entry) {
        Object object = this._lock;
        synchronized (object) {
            SortedQueueEntryImpl chosenChild;
            SortedQueueEntryImpl next;
            SortedQueueEntryImpl prev;
            if (this.leftChild(entry) != null && this.rightChild(entry) != null) {
                this.swapWithSuccessor(entry);
            }
            if ((prev = entry.getPrev()) != null) {
                prev.setNext(entry.getNextValidEntry());
            }
            if ((next = entry.getNextValidEntry()) != null) {
                next.setPrev(prev);
            }
            if ((chosenChild = this.leftChild(entry) != null ? this.leftChild(entry) : this.rightChild(entry)) != null) {
                chosenChild.setParent(entry.getParent());
                if (chosenChild.getParent() == null) {
                    this._root = chosenChild;
                } else if (entry == entry.getParent().getLeft()) {
                    entry.getParent().setLeft(chosenChild);
                } else {
                    entry.getParent().setRight(chosenChild);
                }
                entry.setLeft(null);
                entry.setRight(null);
                entry.setParent(null);
                if (entry.getColour() == SortedQueueEntryImpl.Colour.BLACK) {
                    this.deleteFixup(chosenChild);
                }
            } else if (entry.getParent() == null) {
                this._root = null;
            } else {
                if (entry.getColour() == SortedQueueEntryImpl.Colour.BLACK) {
                    this.deleteFixup(entry);
                }
                if (entry.getParent() != null) {
                    if (entry.getParent().getLeft() == entry) {
                        entry.getParent().setLeft(null);
                    } else if (entry.getParent().getRight() == entry) {
                        entry.getParent().setRight(null);
                    }
                    entry.setParent(null);
                }
            }
        }
    }

    @Override
    public int getPriorities() {
        return 0;
    }

    private void swapWithSuccessor(SortedQueueEntryImpl entry) {
        SortedQueueEntryImpl next = entry.getNextValidEntry();
        SortedQueueEntryImpl nextParent = next.getParent();
        SortedQueueEntryImpl nextLeft = next.getLeft();
        SortedQueueEntryImpl nextRight = next.getRight();
        SortedQueueEntryImpl.Colour nextColour = next.getColour();
        if (next == entry.getRight()) {
            next.setParent(entry.getParent());
            if (next.getParent() == null) {
                this._root = next;
            } else if (next.getParent().getLeft() == entry) {
                next.getParent().setLeft(next);
            } else {
                next.getParent().setRight(next);
            }
            next.setRight(entry);
            entry.setParent(next);
            next.setLeft(entry.getLeft());
            if (next.getLeft() != null) {
                next.getLeft().setParent(next);
            }
            next.setColour(entry.getColour());
            entry.setColour(nextColour);
            entry.setLeft(nextLeft);
            if (nextLeft != null) {
                nextLeft.setParent(entry);
            }
            entry.setRight(nextRight);
            if (nextRight != null) {
                nextRight.setParent(entry);
            }
        } else {
            next.setParent(entry.getParent());
            if (next.getParent() == null) {
                this._root = next;
            } else if (next.getParent().getLeft() == entry) {
                next.getParent().setLeft(next);
            } else {
                next.getParent().setRight(next);
            }
            next.setLeft(entry.getLeft());
            if (next.getLeft() != null) {
                next.getLeft().setParent(next);
            }
            next.setRight(entry.getRight());
            if (next.getRight() != null) {
                next.getRight().setParent(next);
            }
            next.setColour(entry.getColour());
            entry.setParent(nextParent);
            if (nextParent.getLeft() == next) {
                nextParent.setLeft(entry);
            } else {
                nextParent.setRight(entry);
            }
            entry.setLeft(nextLeft);
            if (nextLeft != null) {
                nextLeft.setParent(entry);
            }
            entry.setRight(nextRight);
            if (nextRight != null) {
                nextRight.setParent(entry);
            }
            entry.setColour(nextColour);
        }
    }

    private void deleteFixup(SortedQueueEntryImpl entry) {
        int i = 0;
        while (entry != null && entry != this._root && this.isNodeColour(entry, SortedQueueEntryImpl.Colour.BLACK)) {
            if (++i > 1000) {
                return;
            }
            if (entry == this.leftChild(this.nodeParent(entry))) {
                SortedQueueEntryImpl rightSibling = this.rightChild(this.nodeParent(entry));
                if (this.isNodeColour(rightSibling, SortedQueueEntryImpl.Colour.RED)) {
                    this.setColour(rightSibling, SortedQueueEntryImpl.Colour.BLACK);
                    this.nodeParent(entry).setColour(SortedQueueEntryImpl.Colour.RED);
                    this.leftRotate(this.nodeParent(entry));
                    rightSibling = this.rightChild(this.nodeParent(entry));
                }
                if (this.isNodeColour(this.leftChild(rightSibling), SortedQueueEntryImpl.Colour.BLACK) && this.isNodeColour(this.rightChild(rightSibling), SortedQueueEntryImpl.Colour.BLACK)) {
                    this.setColour(rightSibling, SortedQueueEntryImpl.Colour.RED);
                    entry = this.nodeParent(entry);
                    continue;
                }
                if (this.isNodeColour(this.rightChild(rightSibling), SortedQueueEntryImpl.Colour.BLACK)) {
                    this.setColour(this.leftChild(rightSibling), SortedQueueEntryImpl.Colour.BLACK);
                    rightSibling.setColour(SortedQueueEntryImpl.Colour.RED);
                    this.rightRotate(rightSibling);
                    rightSibling = this.rightChild(this.nodeParent(entry));
                }
                this.setColour(rightSibling, this.getColour(this.nodeParent(entry)));
                this.setColour(this.nodeParent(entry), SortedQueueEntryImpl.Colour.BLACK);
                this.setColour(this.rightChild(rightSibling), SortedQueueEntryImpl.Colour.BLACK);
                this.leftRotate(this.nodeParent(entry));
                entry = this._root;
                continue;
            }
            SortedQueueEntryImpl leftSibling = this.leftChild(this.nodeParent(entry));
            if (this.isNodeColour(leftSibling, SortedQueueEntryImpl.Colour.RED)) {
                this.setColour(leftSibling, SortedQueueEntryImpl.Colour.BLACK);
                this.nodeParent(entry).setColour(SortedQueueEntryImpl.Colour.RED);
                this.rightRotate(this.nodeParent(entry));
                leftSibling = this.leftChild(this.nodeParent(entry));
            }
            if (this.isNodeColour(this.leftChild(leftSibling), SortedQueueEntryImpl.Colour.BLACK) && this.isNodeColour(this.rightChild(leftSibling), SortedQueueEntryImpl.Colour.BLACK)) {
                this.setColour(leftSibling, SortedQueueEntryImpl.Colour.RED);
                entry = this.nodeParent(entry);
                continue;
            }
            if (this.isNodeColour(this.leftChild(leftSibling), SortedQueueEntryImpl.Colour.BLACK)) {
                this.setColour(this.rightChild(leftSibling), SortedQueueEntryImpl.Colour.BLACK);
                leftSibling.setColour(SortedQueueEntryImpl.Colour.RED);
                this.leftRotate(leftSibling);
                leftSibling = this.leftChild(this.nodeParent(entry));
            }
            this.setColour(leftSibling, this.getColour(this.nodeParent(entry)));
            this.setColour(this.nodeParent(entry), SortedQueueEntryImpl.Colour.BLACK);
            this.setColour(this.leftChild(leftSibling), SortedQueueEntryImpl.Colour.BLACK);
            this.rightRotate(this.nodeParent(entry));
            entry = this._root;
        }
        this.setColour(entry, SortedQueueEntryImpl.Colour.BLACK);
    }

    private SortedQueueEntryImpl.Colour getColour(SortedQueueEntryImpl x) {
        return x == null ? null : x.getColour();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class QueueEntryIteratorImpl
    implements QueueEntryIterator<SortedQueueEntryImpl> {
        private SortedQueueEntryImpl _lastNode;

        public QueueEntryIteratorImpl(SortedQueueEntryImpl startNode) {
            this._lastNode = startNode;
        }

        @Override
        public boolean atTail() {
            return SortedQueueEntryList.this.next(this._lastNode) == null;
        }

        @Override
        public SortedQueueEntryImpl getNode() {
            return this._lastNode;
        }

        @Override
        public boolean advance() {
            if (!this.atTail()) {
                SortedQueueEntryImpl nextNode = SortedQueueEntryList.this.next(this._lastNode);
                while (nextNode.isDispensed() && SortedQueueEntryList.this.next(nextNode) != null) {
                    nextNode = SortedQueueEntryList.this.next(nextNode);
                }
                this._lastNode = nextNode;
                return true;
            }
            return false;
        }
    }
}

