/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.logging.CompositeStartupMessageLogger;
import org.apache.qpid.server.logging.Log4jMessageLogger;
import org.apache.qpid.server.logging.LogActor;
import org.apache.qpid.server.logging.LogRecorder;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.logging.SystemOutMessageLogger;
import org.apache.qpid.server.logging.actors.AbstractActor;
import org.apache.qpid.server.logging.actors.BrokerActor;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.BrokerMessages;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.management.plugin.ManagementPlugin;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.adapter.BrokerAdapter;
import org.apache.qpid.server.plugin.GroupManagerFactory;
import org.apache.qpid.server.plugin.ManagementFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.AuthenticationManagerRegistry;
import org.apache.qpid.server.security.auth.manager.IAuthenticationManagerRegistry;
import org.apache.qpid.server.security.group.GroupManager;
import org.apache.qpid.server.security.group.GroupPrincipalAccessor;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostImpl;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationRegistry
implements IApplicationRegistry {
    private static final Logger _logger = Logger.getLogger(ApplicationRegistry.class);
    private static AtomicReference<IApplicationRegistry> _instance = new AtomicReference<Object>(null);
    private final ServerConfiguration _configuration;
    private final Map<InetSocketAddress, QpidAcceptor> _acceptors = Collections.synchronizedMap(new HashMap());
    private IAuthenticationManagerRegistry _authenticationManagerRegistry;
    private final VirtualHostRegistry _virtualHostRegistry = new VirtualHostRegistry(this);
    private SecurityManager _securityManager;
    private volatile RootMessageLogger _rootMessageLogger;
    private CompositeStartupMessageLogger _startupMessageLogger;
    private Broker _broker;
    private Timer _reportingTimer;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private final List<IApplicationRegistry.PortBindingListener> _portBindingListeners = new ArrayList<IApplicationRegistry.PortBindingListener>();
    private int _httpManagementPort = -1;
    private int _httpsManagementPort = -1;
    private LogRecorder _logRecorder;
    private List<IAuthenticationManagerRegistry.RegistryChangeListener> _authManagerChangeListeners = new ArrayList<IAuthenticationManagerRegistry.RegistryChangeListener>();
    private List<IApplicationRegistry.GroupManagerChangeListener> _groupManagerChangeListeners = new ArrayList<IApplicationRegistry.GroupManagerChangeListener>();
    private List<GroupManager> _groupManagerList = new ArrayList<GroupManager>();
    private QpidServiceLoader<GroupManagerFactory> _groupManagerServiceLoader = new QpidServiceLoader();
    private final List<ManagementPlugin> _managmentInstanceList = new ArrayList<ManagementPlugin>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<InetSocketAddress, QpidAcceptor> getAcceptors() {
        Map<InetSocketAddress, QpidAcceptor> map = this._acceptors;
        synchronized (map) {
            return new HashMap<InetSocketAddress, QpidAcceptor>(this._acceptors);
        }
    }

    protected void setSecurityManager(SecurityManager securityManager) {
        this._securityManager = securityManager;
    }

    protected void setRootMessageLogger(RootMessageLogger rootMessageLogger) {
        this._rootMessageLogger = rootMessageLogger;
    }

    protected CompositeStartupMessageLogger getStartupMessageLogger() {
        return this._startupMessageLogger;
    }

    protected void setStartupMessageLogger(CompositeStartupMessageLogger startupMessageLogger) {
        this._startupMessageLogger = startupMessageLogger;
    }

    public static void initialise(IApplicationRegistry instance) throws Exception {
        if (instance == null) {
            throw new IllegalArgumentException("ApplicationRegistry instance must not be null");
        }
        if (!_instance.compareAndSet(null, instance)) {
            throw new IllegalStateException("An ApplicationRegistry is already initialised");
        }
        _logger.info((Object)("Initialising Application Registry(" + instance + ")"));
        try {
            instance.initialise();
        }
        catch (Exception e) {
            _instance.set(null);
            throw e;
        }
    }

    public static boolean isConfigured() {
        return _instance.get() != null;
    }

    public static void remove() {
        IApplicationRegistry instance = _instance.getAndSet(null);
        try {
            if (instance != null) {
                if (_logger.isInfoEnabled()) {
                    _logger.info((Object)("Shutting down ApplicationRegistry(" + instance + ")"));
                }
                instance.close();
            }
        }
        catch (Exception e) {
            _logger.error((Object)("Error shutting down Application Registry(" + instance + "): " + e), (Throwable)e);
        }
    }

    public ApplicationRegistry(ServerConfiguration configuration) {
        this._configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws Exception {
        this._logRecorder = new LogRecorder();
        this._rootMessageLogger = new Log4jMessageLogger(this._configuration);
        RootMessageLogger[] messageLoggers = new RootMessageLogger[]{new SystemOutMessageLogger(), this._rootMessageLogger};
        this._startupMessageLogger = new CompositeStartupMessageLogger(messageLoggers);
        BrokerActor actor = new BrokerActor(this._startupMessageLogger);
        CurrentActor.setDefault(actor);
        CurrentActor.set(actor);
        try {
            this.initialiseStatistics();
            if (this._configuration.getHTTPManagementEnabled()) {
                this._httpManagementPort = this._configuration.getHTTPManagementPort();
            }
            if (this._configuration.getHTTPSManagementEnabled()) {
                this._httpsManagementPort = this._configuration.getHTTPSManagementPort();
            }
            this._broker = new BrokerAdapter(this);
            this._configuration.initialise();
            this.logStartupMessages(CurrentActor.get());
            this.createAndStartManagementPlugins(this._configuration, this._broker);
            this._securityManager = new SecurityManager(this._configuration.getConfig());
            this._groupManagerList = this.createGroupManagers(this._configuration);
            this._authenticationManagerRegistry = this.createAuthenticationManagerRegistry(this._configuration, new GroupPrincipalAccessor(this._groupManagerList));
            if (!this._authManagerChangeListeners.isEmpty()) {
                for (IAuthenticationManagerRegistry.RegistryChangeListener listener : this._authManagerChangeListeners) {
                    this._authenticationManagerRegistry.addRegistryChangeListener(listener);
                    for (AuthenticationManager authMgr : this._authenticationManagerRegistry.getAvailableAuthenticationManagers().values()) {
                        listener.authenticationManagerRegistered(authMgr);
                    }
                }
                this._authManagerChangeListeners.clear();
            }
        }
        finally {
            CurrentActor.remove();
        }
        CurrentActor.set(new BrokerActor(this._rootMessageLogger));
        try {
            this.initialiseVirtualHosts();
            this.initialiseStatisticsReporting();
        }
        finally {
            CurrentActor.remove();
        }
    }

    private void createAndStartManagementPlugins(ServerConfiguration configuration, Broker broker) throws Exception {
        QpidServiceLoader<ManagementFactory> factories = new QpidServiceLoader<ManagementFactory>();
        for (ManagementFactory managementFactory : factories.instancesOf(ManagementFactory.class)) {
            ManagementPlugin managementPlugin = managementFactory.createInstance(configuration, broker);
            if (managementPlugin == null) continue;
            try {
                managementPlugin.start();
            }
            catch (Exception e) {
                _logger.error((Object)("Management plugin " + managementPlugin.getClass().getSimpleName() + " failed to start normally, stopping it now"), (Throwable)e);
                managementPlugin.stop();
                throw e;
            }
            this._managmentInstanceList.add(managementPlugin);
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Configured " + this._managmentInstanceList.size() + " management instance(s)"));
        }
    }

    private void closeAllManagementPlugins() {
        for (ManagementPlugin managementPlugin : this._managmentInstanceList) {
            try {
                managementPlugin.stop();
            }
            catch (Exception e) {
                _logger.error((Object)("Exception thrown whilst stopping management plugin " + managementPlugin.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    private List<GroupManager> createGroupManagers(ServerConfiguration configuration) throws ConfigurationException {
        ArrayList<GroupManager> groupManagerList = new ArrayList<GroupManager>();
        Configuration securityConfig = configuration.getConfig().subset("security");
        for (GroupManagerFactory factory : this._groupManagerServiceLoader.instancesOf(GroupManagerFactory.class)) {
            GroupManager groupManager = factory.createInstance(securityConfig);
            if (groupManager == null) continue;
            groupManagerList.add(groupManager);
            for (IApplicationRegistry.GroupManagerChangeListener listener : this._groupManagerChangeListeners) {
                listener.groupManagerRegistered(groupManager);
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Configured " + groupManagerList.size() + " group manager(s)"));
        }
        return groupManagerList;
    }

    protected IAuthenticationManagerRegistry createAuthenticationManagerRegistry(ServerConfiguration configuration, GroupPrincipalAccessor groupPrincipalAccessor) throws ConfigurationException {
        return new AuthenticationManagerRegistry(configuration, groupPrincipalAccessor);
    }

    protected void initialiseVirtualHosts() throws Exception {
        for (String name : this._configuration.getVirtualHosts()) {
            this.createVirtualHost(this._configuration.getVirtualHostConfig(name));
        }
        this.getVirtualHostRegistry().setDefaultVirtualHostName(this._configuration.getDefaultVirtualHost());
    }

    @Override
    public void initialiseStatisticsReporting() {
        long report = this._configuration.getStatisticsReportingPeriod() * 1000L;
        boolean broker = this._configuration.isStatisticsGenerationBrokerEnabled();
        boolean virtualhost = this._configuration.isStatisticsGenerationVirtualhostsEnabled();
        boolean reset = this._configuration.isStatisticsReportResetEnabled();
        if (report > 0L && (broker || virtualhost)) {
            this._reportingTimer = new Timer("Statistics-Reporting", true);
            this._reportingTimer.scheduleAtFixedRate((TimerTask)new StatisticsReportingTask(broker, virtualhost, reset), report / 2L, report);
        }
    }

    public static IApplicationRegistry getInstance() throws IllegalStateException {
        IApplicationRegistry iApplicationRegistry = _instance.get();
        if (iApplicationRegistry == null) {
            throw new IllegalStateException("No ApplicationRegistry has been initialised");
        }
        return iApplicationRegistry;
    }

    private void close(Closeable close) {
        try {
            if (close != null) {
                close.close();
            }
        }
        catch (Throwable e) {
            _logger.error((Object)("Error thrown whilst closing " + close.getClass().getSimpleName()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Shutting down ApplicationRegistry:" + this));
        }
        CurrentActor.set(new BrokerActor(this.getRootMessageLogger()));
        try {
            if (this._reportingTimer != null) {
                this._reportingTimer.cancel();
            }
            this.unbind();
            this.close(this._virtualHostRegistry);
            this.close(this._authenticationManagerRegistry);
            CurrentActor.get().message(BrokerMessages.STOPPED());
            this._logRecorder.closeLogRecorder();
            this.closeAllManagementPlugins();
        }
        finally {
            CurrentActor.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbind() {
        ArrayList<QpidAcceptor> removedAcceptors = new ArrayList<QpidAcceptor>();
        Object object = this._acceptors;
        synchronized (object) {
            for (InetSocketAddress bindAddress : this._acceptors.keySet()) {
                QpidAcceptor acceptor = this._acceptors.get(bindAddress);
                removedAcceptors.add(acceptor);
                try {
                    acceptor.getNetworkTransport().close();
                }
                catch (Throwable e) {
                    _logger.error((Object)("Unable to close network driver due to:" + e.getMessage()));
                }
                CurrentActor.get().message(BrokerMessages.SHUTTING_DOWN(acceptor.toString(), bindAddress.getPort()));
            }
        }
        object = this._portBindingListeners;
        synchronized (object) {
            for (QpidAcceptor acceptor : removedAcceptors) {
                for (IApplicationRegistry.PortBindingListener listener : this._portBindingListeners) {
                    listener.unbound(acceptor);
                }
            }
        }
    }

    @Override
    public ServerConfiguration getConfiguration() {
        return this._configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAcceptor(InetSocketAddress bindAddress, QpidAcceptor acceptor) {
        Object object = this._acceptors;
        synchronized (object) {
            this._acceptors.put(bindAddress, acceptor);
        }
        object = this._portBindingListeners;
        synchronized (object) {
            for (IApplicationRegistry.PortBindingListener listener : this._portBindingListeners) {
                listener.bound(acceptor, bindAddress);
            }
        }
    }

    @Override
    public VirtualHostRegistry getVirtualHostRegistry() {
        return this._virtualHostRegistry;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    @Override
    public SubjectCreator getSubjectCreator(SocketAddress localAddress) {
        return this._authenticationManagerRegistry.getSubjectCreator(localAddress);
    }

    @Override
    public IAuthenticationManagerRegistry getAuthenticationManagerRegistry() {
        return this._authenticationManagerRegistry;
    }

    @Override
    public List<GroupManager> getGroupManagers() {
        return this._groupManagerList;
    }

    @Override
    public RootMessageLogger getRootMessageLogger() {
        return this._rootMessageLogger;
    }

    public RootMessageLogger getCompositeStartupMessageLogger() {
        return this._startupMessageLogger;
    }

    @Override
    public UUID getBrokerId() {
        return this.getBroker().getId();
    }

    @Override
    public VirtualHost createVirtualHost(VirtualHostConfiguration vhostConfig) throws Exception {
        VirtualHostImpl virtualHost = new VirtualHostImpl(this, vhostConfig);
        this._virtualHostRegistry.registerVirtualHost(virtualHost);
        return virtualHost;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (VirtualHost vhost : this._virtualHostRegistry.getVirtualHosts()) {
            vhost.resetStatistics();
        }
    }

    @Override
    public void initialiseStatistics() {
        this._messagesDelivered = new StatisticsCounter("messages-delivered");
        this._dataDelivered = new StatisticsCounter("bytes-delivered");
        this._messagesReceived = new StatisticsCounter("messages-received");
        this._dataReceived = new StatisticsCounter("bytes-received");
    }

    private void logStartupMessages(LogActor logActor) {
        logActor.message(BrokerMessages.STARTUP(QpidProperties.getReleaseVersion(), QpidProperties.getBuildVersion()));
        logActor.message(BrokerMessages.PLATFORM(System.getProperty("java.vendor"), System.getProperty("java.runtime.version", System.getProperty("java.version")), System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch")));
        logActor.message(BrokerMessages.MAX_MEMORY(Runtime.getRuntime().maxMemory()));
    }

    @Override
    public Broker getBroker() {
        return this._broker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPortBindingListener(IApplicationRegistry.PortBindingListener listener) {
        List<IApplicationRegistry.PortBindingListener> list = this._portBindingListeners;
        synchronized (list) {
            this._portBindingListeners.add(listener);
        }
    }

    @Override
    public boolean useHTTPManagement() {
        return this._httpManagementPort != -1;
    }

    @Override
    public int getHTTPManagementPort() {
        return this._httpManagementPort;
    }

    @Override
    public boolean useHTTPSManagement() {
        return this._httpsManagementPort != -1;
    }

    @Override
    public int getHTTPSManagementPort() {
        return this._httpsManagementPort;
    }

    public LogRecorder getLogRecorder() {
        return this._logRecorder;
    }

    @Override
    public void addAuthenticationManagerRegistryChangeListener(IAuthenticationManagerRegistry.RegistryChangeListener registryChangeListener) {
        if (this._authenticationManagerRegistry == null) {
            this._authManagerChangeListeners.add(registryChangeListener);
        } else {
            this._authenticationManagerRegistry.addRegistryChangeListener(registryChangeListener);
        }
    }

    @Override
    public void addGroupManagerChangeListener(IApplicationRegistry.GroupManagerChangeListener groupManagerChangeListener) {
        this._groupManagerChangeListeners.add(groupManagerChangeListener);
    }

    private class StatisticsReportingTask
    extends TimerTask {
        private final int DELIVERED = 0;
        private final int RECEIVED = 1;
        private boolean _broker;
        private boolean _virtualhost;
        private boolean _reset;

        public StatisticsReportingTask(boolean broker, boolean virtualhost, boolean reset) {
            this._broker = broker;
            this._virtualhost = virtualhost;
            this._reset = reset;
        }

        public void run() {
            CurrentActor.set(new AbstractActor(ApplicationRegistry.getInstance().getRootMessageLogger()){

                public String getLogMessage() {
                    return "[" + Thread.currentThread().getName() + "] ";
                }
            });
            if (this._broker) {
                CurrentActor.get().message(BrokerMessages.STATS_DATA(0, ApplicationRegistry.this._dataDelivered.getPeak() / 1024.0, ApplicationRegistry.this._dataDelivered.getTotal()));
                CurrentActor.get().message(BrokerMessages.STATS_MSGS(0, ApplicationRegistry.this._messagesDelivered.getPeak(), ApplicationRegistry.this._messagesDelivered.getTotal()));
                CurrentActor.get().message(BrokerMessages.STATS_DATA(1, ApplicationRegistry.this._dataReceived.getPeak() / 1024.0, ApplicationRegistry.this._dataReceived.getTotal()));
                CurrentActor.get().message(BrokerMessages.STATS_MSGS(1, ApplicationRegistry.this._messagesReceived.getPeak(), ApplicationRegistry.this._messagesReceived.getTotal()));
            }
            if (this._virtualhost) {
                for (VirtualHost vhost : ApplicationRegistry.this.getVirtualHostRegistry().getVirtualHosts()) {
                    String name = vhost.getName();
                    StatisticsCounter dataDelivered = vhost.getDataDeliveryStatistics();
                    StatisticsCounter messagesDelivered = vhost.getMessageDeliveryStatistics();
                    StatisticsCounter dataReceived = vhost.getDataReceiptStatistics();
                    StatisticsCounter messagesReceived = vhost.getMessageReceiptStatistics();
                    CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 0, dataDelivered.getPeak() / 1024.0, dataDelivered.getTotal()));
                    CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 0, messagesDelivered.getPeak(), messagesDelivered.getTotal()));
                    CurrentActor.get().message(VirtualHostMessages.STATS_DATA(name, 1, dataReceived.getPeak() / 1024.0, dataReceived.getTotal()));
                    CurrentActor.get().message(VirtualHostMessages.STATS_MSGS(name, 1, messagesReceived.getPeak(), messagesReceived.getTotal()));
                }
            }
            if (this._reset) {
                ApplicationRegistry.this.resetStatistics();
            }
            CurrentActor.remove();
        }
    }
}

