/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.registry;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.logging.RootMessageLogger;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.manager.IAuthenticationManagerRegistry;
import org.apache.qpid.server.security.group.GroupManager;
import org.apache.qpid.server.stats.StatisticsGatherer;
import org.apache.qpid.server.transport.QpidAcceptor;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IApplicationRegistry
extends StatisticsGatherer {
    public void initialise() throws Exception;

    public void close();

    public ServerConfiguration getConfiguration();

    public SubjectCreator getSubjectCreator(SocketAddress var1);

    public IAuthenticationManagerRegistry getAuthenticationManagerRegistry();

    public List<GroupManager> getGroupManagers();

    public VirtualHostRegistry getVirtualHostRegistry();

    public SecurityManager getSecurityManager();

    public RootMessageLogger getRootMessageLogger();

    public void addAcceptor(InetSocketAddress var1, QpidAcceptor var2);

    public UUID getBrokerId();

    public Broker getBroker();

    public VirtualHost createVirtualHost(VirtualHostConfiguration var1) throws Exception;

    public void initialiseStatisticsReporting();

    public Map<InetSocketAddress, QpidAcceptor> getAcceptors();

    public void addPortBindingListener(PortBindingListener var1);

    public boolean useHTTPManagement();

    public int getHTTPManagementPort();

    public boolean useHTTPSManagement();

    public int getHTTPSManagementPort();

    public void addAuthenticationManagerRegistryChangeListener(IAuthenticationManagerRegistry.RegistryChangeListener var1);

    public void addGroupManagerChangeListener(GroupManagerChangeListener var1);

    public static interface GroupManagerChangeListener {
        public void groupManagerRegistered(GroupManager var1);

        public void groupManagerUnregistered(GroupManager var1);
    }

    public static interface PortBindingListener {
        public void bound(QpidAcceptor var1, InetSocketAddress var2);

        public void unbound(QpidAcceptor var1);
    }
}

