/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.AuthenticatedPrincipal;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.group.GroupPrincipalAccessor;

public class SubjectCreator {
    private AuthenticationManager _authenticationManager;
    private GroupPrincipalAccessor _groupAccessor;

    public SubjectCreator(AuthenticationManager authenticationManager, GroupPrincipalAccessor groupAccessor) {
        this._authenticationManager = authenticationManager;
        this._groupAccessor = groupAccessor;
    }

    public String getMechanisms() {
        return this._authenticationManager.getMechanisms();
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        return this._authenticationManager.createSaslServer(mechanism, localFQDN, externalPrincipal);
    }

    public SubjectAuthenticationResult authenticate(SaslServer server, byte[] response) {
        AuthenticationResult authenticationResult = this._authenticationManager.authenticate(server, response);
        if (server.isComplete()) {
            String username = server.getAuthorizationID();
            return this.createResultWithGroups(username, authenticationResult);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public SubjectAuthenticationResult authenticate(String username, String password) {
        AuthenticationResult authenticationResult = this._authenticationManager.authenticate(username, password);
        return this.createResultWithGroups(username, authenticationResult);
    }

    private SubjectAuthenticationResult createResultWithGroups(String username, AuthenticationResult authenticationResult) {
        if (authenticationResult.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
            Subject authenticationSubject = new Subject();
            authenticationSubject.getPrincipals().addAll(authenticationResult.getPrincipals());
            authenticationSubject.getPrincipals().addAll(this._groupAccessor.getGroupPrincipals(username));
            authenticationSubject.setReadOnly();
            return new SubjectAuthenticationResult(authenticationResult, authenticationSubject);
        }
        return new SubjectAuthenticationResult(authenticationResult);
    }

    public Subject createSubjectWithGroups(String username) {
        Subject authenticationSubject = new Subject();
        authenticationSubject.getPrincipals().add(new AuthenticatedPrincipal(username));
        authenticationSubject.getPrincipals().addAll(this._groupAccessor.getGroupPrincipals(username));
        authenticationSubject.setReadOnly();
        return authenticationSubject;
    }
}

