/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.queue.AMQQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectProperties {
    public static final String STAR = "*";
    public static final ObjectProperties EMPTY = new ObjectProperties();
    private final EnumMap<Property, String> _properties = new EnumMap(Property.class);

    public static List<String> getAllPropertyNames() {
        ArrayList<String> properties = new ArrayList<String>();
        for (Property property : Property.values()) {
            properties.add(StringUtils.remove((String)property.name(), (char)'_').toLowerCase());
        }
        return properties;
    }

    public ObjectProperties() {
    }

    public ObjectProperties(Property property, String value) {
        this._properties.put(property, value);
    }

    public ObjectProperties(ObjectProperties copy) {
        this._properties.putAll(copy._properties);
    }

    public ObjectProperties(String name) {
        this.setName(name);
    }

    public ObjectProperties(AMQShortString name) {
        this.setName(name);
    }

    public ObjectProperties(AMQQueue queue) {
        this.setName(queue.getName());
        this.put(Property.AUTO_DELETE, queue.isAutoDelete());
        this.put(Property.TEMPORARY, queue.isAutoDelete());
        this.put(Property.DURABLE, queue.isDurable());
        this.put(Property.EXCLUSIVE, queue.isExclusive());
        if (queue.getAlternateExchange() != null) {
            this.put(Property.ALTERNATE, queue.getAlternateExchange().getName());
        }
        if (queue.getOwner() != null) {
            this.put(Property.OWNER, queue.getOwner());
        } else if (queue.getAuthorizationHolder() != null) {
            this.put(Property.OWNER, queue.getAuthorizationHolder().getAuthorizedPrincipal().getName());
        }
    }

    public ObjectProperties(Exchange exch, AMQQueue queue, AMQShortString routingKey) {
        this(queue);
        this.setName(exch.getName());
        this.put(Property.QUEUE_NAME, queue.getName());
        this.put(Property.ROUTING_KEY, routingKey);
    }

    public ObjectProperties(Exchange exch, AMQShortString routingKey) {
        this(exch.getName(), routingKey.asString());
    }

    public ObjectProperties(String exchangeName, String routingKey, Boolean immediate) {
        this(exchangeName, routingKey);
        this.put(Property.IMMEDIATE, immediate);
    }

    public ObjectProperties(String exchangeName, String routingKey) {
        this.setName(exchangeName);
        this.put(Property.ROUTING_KEY, routingKey);
    }

    public ObjectProperties(Boolean autoDelete, Boolean durable, AMQShortString exchangeName, Boolean internal, Boolean nowait, Boolean passive, AMQShortString exchangeType) {
        this.setName(exchangeName);
        this.put(Property.AUTO_DELETE, autoDelete);
        this.put(Property.TEMPORARY, autoDelete);
        this.put(Property.DURABLE, durable);
        this.put(Property.INTERNAL, internal);
        this.put(Property.NO_WAIT, nowait);
        this.put(Property.PASSIVE, passive);
        this.put(Property.TYPE, exchangeType);
    }

    public ObjectProperties(Boolean autoDelete, Boolean durable, Boolean exclusive, Boolean nowait, Boolean passive, AMQShortString queueName, String owner) {
        this.setName(queueName);
        this.put(Property.AUTO_DELETE, autoDelete);
        this.put(Property.TEMPORARY, autoDelete);
        this.put(Property.DURABLE, durable);
        this.put(Property.EXCLUSIVE, exclusive);
        this.put(Property.NO_WAIT, nowait);
        this.put(Property.PASSIVE, passive);
        this.put(Property.OWNER, owner);
    }

    public ObjectProperties(Boolean exclusive, Boolean noAck, Boolean noLocal, Boolean nowait, AMQQueue queue) {
        this(queue);
        this.put(Property.NO_LOCAL, noLocal);
        this.put(Property.NO_ACK, noAck);
        this.put(Property.EXCLUSIVE, exclusive);
        this.put(Property.NO_WAIT, nowait);
    }

    public Boolean isSet(Property key) {
        return this._properties.containsKey((Object)key) && Boolean.valueOf(this._properties.get((Object)key)) != false;
    }

    public String get(Property key) {
        return this._properties.get((Object)key);
    }

    public String getName() {
        return this._properties.get((Object)Property.NAME);
    }

    public void setName(String name) {
        this._properties.put(Property.NAME, name);
    }

    public void setName(AMQShortString name) {
        this.put(Property.NAME, name);
    }

    public String put(Property key, AMQShortString value) {
        return this.put(key, value == null ? "" : value.asString());
    }

    public String put(Property key, String value) {
        return this._properties.put(key, value == null ? "" : value.trim());
    }

    public void put(Property key, Boolean value) {
        if (value != null) {
            this._properties.put(key, Boolean.toString(value));
        }
    }

    public boolean matches(ObjectProperties properties) {
        if (properties._properties.keySet().isEmpty()) {
            return true;
        }
        if (!this._properties.keySet().containsAll(properties._properties.keySet())) {
            return false;
        }
        for (Map.Entry<Property, String> entry : properties._properties.entrySet()) {
            Property key = entry.getKey();
            String ruleValue = entry.getValue();
            String thisValue = this._properties.get((Object)key);
            if (this.valueMatches(thisValue, ruleValue)) continue;
            return false;
        }
        return true;
    }

    private boolean valueMatches(String thisValue, String ruleValue) {
        return StringUtils.isEmpty((String)ruleValue) || StringUtils.equals((String)thisValue, (String)ruleValue) || ruleValue.equals(STAR) || ruleValue.endsWith(STAR) && thisValue != null && thisValue.length() >= ruleValue.length() - 1 && thisValue.startsWith(ruleValue.substring(0, ruleValue.length() - 1));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ObjectProperties rhs = (ObjectProperties)obj;
        return new EqualsBuilder().append(this._properties, rhs._properties).isEquals();
    }

    public int hashCode() {
        return this._properties != null ? this._properties.hashCode() : 0;
    }

    public String toString() {
        return this._properties.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ROUTING_KEY,
        NAME,
        QUEUE_NAME,
        OWNER,
        TYPE,
        ALTERNATE,
        IMMEDIATE,
        INTERNAL,
        NO_WAIT,
        NO_LOCAL,
        NO_ACK,
        PASSIVE,
        DURABLE,
        EXCLUSIVE,
        TEMPORARY,
        AUTO_DELETE,
        COMPONENT,
        PACKAGE,
        CLASS,
        FROM_NETWORK,
        FROM_HOSTNAME;

        private static final Map<String, Property> _canonicalNameToPropertyMap;

        public static Property parse(String text) {
            String propertyName = Property.getCanonicalName(text);
            Property property = _canonicalNameToPropertyMap.get(propertyName);
            if (property == null) {
                throw new IllegalArgumentException("Not a valid property: " + text + " because " + propertyName + " is not in " + _canonicalNameToPropertyMap.keySet());
            }
            return property;
        }

        private static String getCanonicalName(String name) {
            return StringUtils.remove((String)name, (char)'_').toLowerCase();
        }

        static {
            _canonicalNameToPropertyMap = new HashMap<String, Property>();
            for (Property property : Property.values()) {
                _canonicalNameToPropertyMap.put(Property.getCanonicalName(property.name()), property);
            }
        }
    }
}

