/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth;

import java.io.Serializable;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.qpid.server.security.auth.UsernamePrincipal;

public final class AuthenticatedPrincipal
implements Principal,
Serializable {
    private final Principal _wrappedPrincipal;

    public AuthenticatedPrincipal(String userPrincipalName) {
        this(new UsernamePrincipal(userPrincipalName));
    }

    public AuthenticatedPrincipal(Principal wrappedPrincipal) {
        if (wrappedPrincipal == null) {
            throw new IllegalArgumentException("Wrapped principal is null");
        }
        this._wrappedPrincipal = wrappedPrincipal;
    }

    public String getName() {
        return this._wrappedPrincipal.getName();
    }

    public int hashCode() {
        return ((Object)this._wrappedPrincipal).hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AuthenticatedPrincipal)) {
            return false;
        }
        AuthenticatedPrincipal other = (AuthenticatedPrincipal)obj;
        return ((Object)this._wrappedPrincipal).equals(other._wrappedPrincipal);
    }

    public static AuthenticatedPrincipal getOptionalAuthenticatedPrincipalFromSubject(Subject authSubject) {
        return AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(authSubject, true);
    }

    public static AuthenticatedPrincipal getAuthenticatedPrincipalFromSubject(Subject authSubject) {
        return AuthenticatedPrincipal.getAuthenticatedPrincipalFromSubject(authSubject, false);
    }

    private static AuthenticatedPrincipal getAuthenticatedPrincipalFromSubject(Subject authSubject, boolean isPrincipalOptional) {
        if (authSubject == null) {
            throw new IllegalArgumentException("No authenticated subject.");
        }
        Set<AuthenticatedPrincipal> principals = authSubject.getPrincipals(AuthenticatedPrincipal.class);
        int numberOfAuthenticatedPrincipals = principals.size();
        if (numberOfAuthenticatedPrincipals == 0 && isPrincipalOptional) {
            return null;
        }
        if (numberOfAuthenticatedPrincipals != 1) {
            throw new IllegalArgumentException("Can't find single AuthenticatedPrincipal in authenticated subject. There were " + numberOfAuthenticatedPrincipals + " authenticated principals out of a total number of principals of: " + authSubject.getPrincipals());
        }
        return principals.iterator().next();
    }

    public String toString() {
        return this.getName();
    }
}

