/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.database;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PasswordPrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.apache.qpid.server.security.auth.sasl.UsernamePasswordInitialiser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPasswordFilePrincipalDatabase<U extends PasswordPrincipal>
implements PrincipalDatabase {
    private final Pattern _regexp = Pattern.compile(":");
    private final Map<String, AuthenticationProviderInitialiser> _saslServers = new HashMap<String, AuthenticationProviderInitialiser>();
    protected static final String DEFAULT_ENCODING = "utf-8";
    private final Map<String, U> _userMap = new HashMap<String, U>();
    private final ReentrantLock _userUpdate = new ReentrantLock();
    private final Random _random = new Random();
    private File _passwordFile;

    protected AbstractPasswordFilePrincipalDatabase(UsernamePasswordInitialiser ... initialisers) {
        for (UsernamePasswordInitialiser initialiser : initialisers) {
            initialiser.initialise(this);
            this._saslServers.put(initialiser.getMechanismName(), initialiser);
        }
    }

    @Override
    public final void setPasswordFile(String passwordFile) throws IOException {
        File f = new File(passwordFile);
        this.getLogger().info((Object)("PasswordFile using file " + f.getAbsolutePath()));
        this._passwordFile = f;
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot find password file " + f);
        }
        if (!f.canRead()) {
            throw new FileNotFoundException("Cannot read password file " + f + ". Check permissions.");
        }
        this.loadPasswordFile();
    }

    @Override
    public final void setPassword(Principal principal, PasswordCallback callback) throws AccountNotFoundException {
        if (this._passwordFile == null) {
            throw new AccountNotFoundException("Unable to locate principal since no password file was specified during initialisation");
        }
        if (principal == null) {
            throw new IllegalArgumentException("principal must not be null");
        }
        char[] pwd = this.lookupPassword(principal.getName());
        if (pwd == null) {
            throw new AccountNotFoundException("No account found for principal " + principal);
        }
        callback.setPassword(pwd);
    }

    protected final char[] lookupPassword(String name) {
        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(name);
        if (user == null) {
            return null;
        }
        return user.getPassword();
    }

    protected boolean compareCharArray(char[] a, char[] b) {
        boolean equal = false;
        if (a.length == b.length) {
            equal = true;
            for (int index = 0; equal && index < a.length; ++index) {
                equal = a[index] == b[index];
            }
        }
        return equal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        char[] orig = user.getPassword();
        this._userUpdate.lock();
        try {
            user.setPassword(password);
            this.savePasswordFile();
            boolean bl = true;
            Object var8_7 = null;
            this._userUpdate.unlock();
            return bl;
        }
        catch (IOException e) {
            try {
                this.getLogger().error((Object)("Unable to save password file due to '" + e.getMessage() + "', password change for user '" + principal + "' discarded"));
                user.restorePassword(orig);
                boolean bl = false;
                Object var8_8 = null;
                this._userUpdate.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this._userUpdate.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPasswordFile() throws IOException {
        try {
            HashMap<String, U> newUserMap;
            block5: {
                this._userUpdate.lock();
                newUserMap = new HashMap<String, U>();
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(this._passwordFile));
                    while ((line = reader.readLine()) != null) {
                        String[] result = this._regexp.split(line);
                        if (result == null || result.length < 2 || result[0].startsWith("#")) continue;
                        U user = this.createUserFromFileData(result);
                        this.getLogger().info((Object)("Created user:" + user));
                        newUserMap.put(user.getName(), user);
                    }
                    Object var7_6 = null;
                    if (reader == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (reader == null) throw throwable;
                    reader.close();
                    throw throwable;
                }
                reader.close();
            }
            this._userMap.clear();
            this._userMap.putAll(newUserMap);
            Object var9_9 = null;
            this._userUpdate.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this._userUpdate.unlock();
            throw throwable;
        }
    }

    protected abstract U createUserFromFileData(String[] var1);

    protected abstract Logger getLogger();

    protected File createTempFileOnSameFilesystem() {
        File tmp;
        File liveFile = this._passwordFile;
        while ((tmp = new File(liveFile.getPath() + this._random.nextInt() + ".tmp")).exists()) {
        }
        tmp.deleteOnExit();
        return tmp;
    }

    protected void swapTempFileToLive(File temp) throws IOException {
        File live = this._passwordFile;
        File old = new File(live.getAbsoluteFile() + ".old");
        if (old.exists()) {
            old.delete();
        }
        if (!live.renameTo(old)) {
            this.getLogger().error((Object)"Could not backup the existing password file");
            throw new IOException("Could not backup the existing password file");
        }
        if (!temp.renameTo(live)) {
            if (!old.renameTo(live)) {
                this.getLogger().error((Object)"Could not rename the new password file into place, and unable to restore original file");
                throw new IOException("Could not rename the new password file into place, and unable to restore original file");
            }
            this.getLogger().error((Object)"Could not rename the new password file into place");
            throw new IOException("Could not rename the new password file into place");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void savePasswordFile() throws IOException {
        try {
            this._userUpdate.lock();
            BufferedReader reader = null;
            PrintStream writer = null;
            File tmp = this.createTempFileOnSameFilesystem();
            try {
                try {
                    byte[] encodedPassword;
                    String line;
                    writer = new PrintStream(tmp);
                    reader = new BufferedReader(new FileReader(this._passwordFile));
                    while ((line = reader.readLine()) != null) {
                        String[] result = this._regexp.split(line);
                        if (result == null || result.length < 2 || result[0].startsWith("#")) {
                            writer.write(line.getBytes(DEFAULT_ENCODING));
                            writer.println();
                            continue;
                        }
                        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(result[0]);
                        if (user == null) {
                            writer.write(line.getBytes(DEFAULT_ENCODING));
                            writer.println();
                            continue;
                        }
                        if (user.isDeleted()) continue;
                        if (!user.isModified()) {
                            writer.write(line.getBytes(DEFAULT_ENCODING));
                            writer.println();
                            continue;
                        }
                        encodedPassword = user.getEncodedPassword();
                        writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                        writer.write(encodedPassword);
                        writer.println();
                        user.saved();
                    }
                    for (PasswordPrincipal user : this._userMap.values()) {
                        if (!user.isModified()) continue;
                        encodedPassword = user.getEncodedPassword();
                        writer.write((user.getName() + ":").getBytes(DEFAULT_ENCODING));
                        writer.write(encodedPassword);
                        writer.println();
                        user.saved();
                    }
                    Object var9_9 = null;
                }
                catch (IOException e) {
                    this.getLogger().error((Object)("Unable to create the new password file: " + e));
                    throw new IOException("Unable to create the new password file", e);
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    Object var11_13 = null;
                    if (writer == null) throw throwable;
                    writer.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Object var11_14 = null;
                    if (writer == null) throw throwable2;
                    writer.close();
                    throw throwable2;
                }
            }
            try {}
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            if (reader != null) {
                reader.close();
            }
            Object var11_11 = null;
            if (writer != null) {
                writer.close();
            }
            this.swapTempFileToLive(tmp);
            Object var13_18 = null;
            this._userUpdate.unlock();
            return;
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            this._userUpdate.unlock();
            throw throwable;
        }
    }

    protected abstract U createUserFromPassword(Principal var1, char[] var2);

    @Override
    public void reload() throws IOException {
        this.loadPasswordFile();
    }

    @Override
    public Map<String, AuthenticationProviderInitialiser> getMechanisms() {
        return this._saslServers;
    }

    @Override
    public List<Principal> getUsers() {
        return new LinkedList<Principal>(this._userMap.values());
    }

    @Override
    public Principal getUser(String username) {
        if (this._userMap.containsKey(username)) {
            return new UsernamePrincipal(username);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
        PasswordPrincipal user = (PasswordPrincipal)this._userMap.get(principal.getName());
        if (user == null) {
            throw new AccountNotFoundException(principal.getName());
        }
        try {
            this._userUpdate.lock();
            user.delete();
            try {
                this.savePasswordFile();
            }
            catch (IOException e) {
                this.getLogger().error((Object)("Unable to remove user '" + user.getName() + "' from password file."));
                boolean bl = false;
                Object var6_5 = null;
                this._userUpdate.unlock();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this._userUpdate.unlock();
            throw throwable;
        }
        this._userMap.remove(user.getName());
        Object var6_6 = null;
        this._userUpdate.unlock();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean createPrincipal(Principal principal, char[] password) {
        Throwable throwable2;
        boolean bl;
        if (this._userMap.get(principal.getName()) != null) {
            return false;
        }
        U user = this.createUserFromPassword(principal, password);
        this._userUpdate.lock();
        this._userMap.put(user.getName(), user);
        try {
            this.savePasswordFile();
            bl = true;
        }
        catch (IOException e) {
            try {
                this._userMap.remove(user.getName());
                boolean bl2 = false;
                Object var7_7 = null;
                this._userUpdate.unlock();
                return bl2;
            }
            catch (Throwable throwable2) {
                Object var7_8 = null;
                this._userUpdate.unlock();
            }
        }
        Object var7_6 = null;
        this._userUpdate.unlock();
        return bl;
        throw throwable2;
    }
}

