/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.anonymous.AnonymousInitialiser;
import org.apache.qpid.server.security.auth.sasl.anonymous.AnonymousSaslServer;

public class AnonymousAuthenticationManager
implements AuthenticationManager {
    private static final AnonymousInitialiser SASL_INITIALISER = new AnonymousInitialiser();
    private static final String ANONYMOUS = SASL_INITIALISER.getMechanismName();
    public static final String ANONYMOUS_USERNAME = "ANONYMOUS";
    public static final Principal ANONYMOUS_PRINCIPAL = new UsernamePrincipal("ANONYMOUS");
    public static final Subject ANONYMOUS_SUBJECT = new Subject();
    private static final AuthenticationResult ANONYMOUS_AUTHENTICATION;
    static final AnonymousAuthenticationManager INSTANCE;

    AnonymousAuthenticationManager() {
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return ANONYMOUS;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (ANONYMOUS.equals(mechanism)) {
            return new AnonymousSaslServer();
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                return ANONYMOUS_AUTHENTICATION;
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        return ANONYMOUS_AUTHENTICATION;
    }

    public void close() {
    }

    static {
        ANONYMOUS_SUBJECT.getPrincipals().add(ANONYMOUS_PRINCIPAL);
        ANONYMOUS_AUTHENTICATION = new AuthenticationResult(ANONYMOUS_PRINCIPAL);
        INSTANCE = new AnonymousAuthenticationManager();
    }
}

