/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.common.Closeable;
import org.apache.qpid.server.configuration.ServerConfiguration;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.plugin.QpidServiceLoader;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.IAuthenticationManagerRegistry;
import org.apache.qpid.server.security.group.GroupPrincipalAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationManagerRegistry
implements Closeable,
IAuthenticationManagerRegistry {
    private final Map<String, AuthenticationManager> _classToAuthManagerMap = new HashMap<String, AuthenticationManager>();
    private final SubjectCreator _defaultSubjectCreator;
    private final Map<Integer, SubjectCreator> _portToSubjectCreatorMap;
    private final List<IAuthenticationManagerRegistry.RegistryChangeListener> _listeners = Collections.synchronizedList(new ArrayList());
    private final QpidServiceLoader<AuthenticationManagerFactory> _authManagerFactoryServiceLoader;

    public AuthenticationManagerRegistry(ServerConfiguration serverConfiguration, GroupPrincipalAccessor groupPrincipalAccessor) throws ConfigurationException {
        this(serverConfiguration, groupPrincipalAccessor, new QpidServiceLoader<AuthenticationManagerFactory>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AuthenticationManagerRegistry(ServerConfiguration serverConfiguration, GroupPrincipalAccessor groupPrincipalAccessor, QpidServiceLoader<AuthenticationManagerFactory> authManagerFactoryServiceLoader) throws ConfigurationException {
        this._authManagerFactoryServiceLoader = authManagerFactoryServiceLoader;
        boolean willClose = true;
        try {
            this.createAuthManagers(serverConfiguration.getConfig());
            if (this._classToAuthManagerMap.isEmpty()) {
                throw new ConfigurationException("No authentication managers configured within the configuration file.");
            }
            this._defaultSubjectCreator = this.createDefaultSubectCreator(serverConfiguration, groupPrincipalAccessor);
            this._portToSubjectCreatorMap = this.createPortToSubjectCreatorMap(serverConfiguration, groupPrincipalAccessor);
            willClose = false;
            Object var6_5 = null;
            if (willClose) {
                this.close();
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (willClose) {
                this.close();
            }
            throw throwable;
        }
    }

    @Override
    public SubjectCreator getSubjectCreator(SocketAddress address) {
        SubjectCreator subjectCreator = address instanceof InetSocketAddress ? this._portToSubjectCreatorMap.get(((InetSocketAddress)address).getPort()) : null;
        return subjectCreator == null ? this._defaultSubjectCreator : subjectCreator;
    }

    public void close() {
        for (AuthenticationManager authManager : this._classToAuthManagerMap.values()) {
            authManager.close();
        }
    }

    private void createAuthManagers(Configuration config) {
        Configuration securityConfiguration = config.subset("security");
        for (AuthenticationManagerFactory factory : this._authManagerFactoryServiceLoader.atLeastOneInstanceOf(AuthenticationManagerFactory.class)) {
            AuthenticationManager plugin = factory.createInstance(securityConfiguration);
            if (plugin == null) continue;
            this.validateAndInitialiseAuthenticationManager(plugin);
        }
    }

    private void validateAndInitialiseAuthenticationManager(AuthenticationManager authenticationManager) {
        String authManagerName = authenticationManager.getClass().getSimpleName();
        if (this._classToAuthManagerMap.containsKey(authManagerName)) {
            throw new RuntimeException("Cannot configure more than one authentication manager with name " + authManagerName + ".");
        }
        authenticationManager.initialise();
        this._classToAuthManagerMap.put(authManagerName, authenticationManager);
    }

    private SubjectCreator createDefaultSubectCreator(ServerConfiguration serverConfiguration, GroupPrincipalAccessor groupAccessor) throws ConfigurationException {
        AuthenticationManager defaultAuthenticationManager;
        if (this._classToAuthManagerMap.size() == 1) {
            defaultAuthenticationManager = this._classToAuthManagerMap.values().iterator().next();
        } else if (serverConfiguration.getDefaultAuthenticationManager() != null) {
            defaultAuthenticationManager = this._classToAuthManagerMap.get(serverConfiguration.getDefaultAuthenticationManager());
            if (defaultAuthenticationManager == null) {
                throw new ConfigurationException("No authentication managers configured of type " + serverConfiguration.getDefaultAuthenticationManager() + " which is specified as the default.  Available managers are: " + this._classToAuthManagerMap.keySet());
            }
        } else {
            throw new ConfigurationException("If more than one authentication manager is configured a default MUST be specified.");
        }
        return new SubjectCreator(defaultAuthenticationManager, groupAccessor);
    }

    private Map<Integer, SubjectCreator> createPortToSubjectCreatorMap(ServerConfiguration serverConfiguration, GroupPrincipalAccessor groupPrincipalAccessor) throws ConfigurationException {
        HashMap<Integer, SubjectCreator> portToSubjectCreatorMap = new HashMap<Integer, SubjectCreator>();
        for (Map.Entry<Integer, String> portMapping : serverConfiguration.getPortAuthenticationMappings().entrySet()) {
            AuthenticationManager authenticationManager = this._classToAuthManagerMap.get(portMapping.getValue());
            if (authenticationManager == null) {
                throw new ConfigurationException("Unknown authentication manager class " + portMapping.getValue() + " configured for port " + portMapping.getKey());
            }
            SubjectCreator subjectCreator = new SubjectCreator(authenticationManager, groupPrincipalAccessor);
            portToSubjectCreatorMap.put(portMapping.getKey(), subjectCreator);
        }
        return portToSubjectCreatorMap;
    }

    @Override
    public Map<String, AuthenticationManager> getAvailableAuthenticationManagers() {
        return Collections.unmodifiableMap(new HashMap<String, AuthenticationManager>(this._classToAuthManagerMap));
    }

    @Override
    public void addRegistryChangeListener(IAuthenticationManagerRegistry.RegistryChangeListener listener) {
        this._listeners.add(listener);
    }
}

