/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;

public class KerberosAuthenticationManager
implements AuthenticationManager {
    private static final String GSSAPI_MECHANISM = "GSSAPI";
    private final CallbackHandler _callbackHandler = new GssApiCallbackHandler();

    KerberosAuthenticationManager() {
    }

    public void initialise() {
    }

    public String getMechanisms() {
        return GSSAPI_MECHANISM;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (GSSAPI_MECHANISM.equals(mechanism)) {
            try {
                return Sasl.createSaslServer(GSSAPI_MECHANISM, "AMQP", localFQDN, new HashMap(), this._callbackHandler);
            }
            catch (SaslException e) {
                e.printStackTrace(System.err);
                throw e;
            }
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                return new AuthenticationResult(new UsernamePrincipal(server.getAuthorizationID()));
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            e.printStackTrace(System.err);
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR);
    }

    public void close() {
    }

    private static class GssApiCallbackHandler
    implements CallbackHandler {
        private GssApiCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback);
                }
                ((AuthorizeCallback)callback).setAuthorized(true);
            }
        }
    }
}

