/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.security.auth.database.Base64MD5PasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.PlainPasswordFilePrincipalDatabase;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.PrincipalDatabaseAuthenticationManager;

public class PrincipalDatabaseAuthManagerFactory
implements AuthenticationManagerFactory {
    private static final Logger LOGGER = Logger.getLogger(PrincipalDatabaseAuthManagerFactory.class);

    public AuthenticationManager createInstance(Configuration configuration) {
        if (configuration.subset("pd-auth-manager").isEmpty()) {
            return null;
        }
        String clazz = configuration.getString("pd-auth-manager.principal-database.class");
        String passwordArgumentName = configuration.getString("pd-auth-manager.principal-database.attributes.attribute.name");
        String passwordFile = configuration.getString("pd-auth-manager.principal-database.attributes.attribute.value");
        PrincipalDatabase principalDatabase = this.createKnownImplementation(clazz);
        if (principalDatabase == null) {
            LOGGER.warn((Object)("Config for pd-auth-manager found but principal-database class specified in config " + clazz + " not recognised."));
            return null;
        }
        if (!"passwordFile".equals(passwordArgumentName) || passwordFile == null) {
            LOGGER.warn((Object)"Config for pd-auth-manager found but config incomplete - expected attributes not found.");
            return null;
        }
        try {
            principalDatabase.setPasswordFile(passwordFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return new PrincipalDatabaseAuthenticationManager(principalDatabase);
    }

    private PrincipalDatabase createKnownImplementation(String clazz) {
        if (PlainPasswordFilePrincipalDatabase.class.getName().equals(clazz)) {
            return new PlainPasswordFilePrincipalDatabase();
        }
        if (Base64MD5PasswordFilePrincipalDatabase.class.getName().equals(clazz)) {
            return new Base64MD5PasswordFilePrincipalDatabase();
        }
        return null;
    }
}

