/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.security.Principal;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.database.PrincipalDatabase;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.apache.qpid.server.security.auth.sasl.JCAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrincipalDatabaseAuthenticationManager
implements AuthenticationManager {
    public static final String PD_CLASS = "pd.class";
    public static final String PD_PASSWORD_FILE = "pd.passwordFile";
    private static final Logger _logger = Logger.getLogger(PrincipalDatabaseAuthenticationManager.class);
    private String _mechanisms;
    private final Map<String, CallbackHandler> _callbackHandlerMap = new HashMap<String, CallbackHandler>();
    private final Map<String, Map<String, ?>> _serverCreationProperties = new HashMap();
    private final PrincipalDatabase _principalDatabase;

    public PrincipalDatabaseAuthenticationManager(PrincipalDatabase pd) {
        this._principalDatabase = pd;
    }

    @Override
    public void initialise() {
        TreeMap<String, Class<? extends SaslServerFactory>> providerMap = new TreeMap<String, Class<? extends SaslServerFactory>>();
        this.initialiseAuthenticationMechanisms(providerMap, this._principalDatabase);
        if (providerMap.size() > 0) {
            if (Security.insertProviderAt(new JCAProvider("AMQSASLProvider-Server", providerMap), 1) == -1) {
                _logger.error((Object)"Unable to load custom SASL providers. Qpid custom SASL authenticators unavailable.");
            } else {
                _logger.info((Object)"Additional SASL providers successfully registered.");
            }
        } else {
            _logger.warn((Object)"No additional SASL providers registered.");
        }
    }

    private void initialiseAuthenticationMechanisms(Map<String, Class<? extends SaslServerFactory>> providerMap, PrincipalDatabase database) {
        if (database == null || database.getMechanisms().size() == 0) {
            _logger.warn((Object)"No Database or no mechanisms to initialise authentication");
            return;
        }
        for (Map.Entry<String, AuthenticationProviderInitialiser> mechanism : database.getMechanisms().entrySet()) {
            this.initialiseAuthenticationMechanism(mechanism.getKey(), mechanism.getValue(), providerMap);
        }
    }

    private void initialiseAuthenticationMechanism(String mechanism, AuthenticationProviderInitialiser initialiser, Map<String, Class<? extends SaslServerFactory>> providerMap) {
        this._mechanisms = this._mechanisms == null ? mechanism : this._mechanisms + " " + mechanism;
        this._callbackHandlerMap.put(mechanism, initialiser.getCallbackHandler());
        this._serverCreationProperties.put(mechanism, initialiser.getProperties());
        Class<? extends SaslServerFactory> factory = initialiser.getServerFactoryClassForJCARegistration();
        if (factory != null) {
            providerMap.put(mechanism, factory);
        }
        _logger.info((Object)("Initialised " + mechanism + " SASL provider successfully"));
    }

    @Override
    public String getMechanisms() {
        return this._mechanisms;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        Map<String, ?> properties = this._serverCreationProperties.get(mechanism);
        CallbackHandler callbackHandler = this._callbackHandlerMap.get(mechanism);
        return Sasl.createSaslServer(mechanism, "AMQP", localFQDN, properties, callbackHandler);
    }

    @Override
    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                String userId = server.getAuthorizationID();
                return new AuthenticationResult(new UsernamePrincipal(userId));
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    @Override
    public AuthenticationResult authenticate(String username, String password) {
        try {
            if (this._principalDatabase.verifyPassword(username, password.toCharArray())) {
                return new AuthenticationResult(new UsernamePrincipal(username));
            }
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (AccountNotFoundException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
    }

    public void close() {
        this._mechanisms = null;
        Security.removeProvider("AMQSASLProvider-Server");
    }

    public PrincipalDatabase getPrincipalDatabase() {
        return this._principalDatabase;
    }
}

