/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.log4j.Logger;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.sasl.plain.PlainPasswordCallback;

public class SimpleLDAPAuthenticationManager
implements AuthenticationManager {
    private static final Logger _logger = Logger.getLogger(SimpleLDAPAuthenticationManager.class);
    private static final String PLAIN_MECHANISM = "PLAIN";
    private final String _providerSearchURL;
    private final String _providerAuthURL;
    private final String _searchContext;
    private final String _searchFilter;
    private final String _ldapContextFactory;

    SimpleLDAPAuthenticationManager(String providerSearchUrl, String providerAuthUrl, String searchContext, String searchFilter, String ldapContextFactory) {
        this._providerSearchURL = providerSearchUrl;
        this._providerAuthURL = providerAuthUrl;
        this._searchContext = searchContext;
        this._searchFilter = searchFilter;
        this._ldapContextFactory = ldapContextFactory;
    }

    public void initialise() {
        this.validateInitialDirContext();
    }

    public String getMechanisms() {
        return PLAIN_MECHANISM;
    }

    public SaslServer createSaslServer(String mechanism, String localFQDN, Principal externalPrincipal) throws SaslException {
        if (PLAIN_MECHANISM.equals(mechanism)) {
            return Sasl.createSaslServer(PLAIN_MECHANISM, "AMQP", localFQDN, new HashMap(), new PlainCallbackHandler());
        }
        throw new SaslException("Unknown mechanism: " + mechanism);
    }

    public AuthenticationResult authenticate(SaslServer server, byte[] response) {
        try {
            byte[] challenge = server.evaluateResponse(response != null ? response : new byte[]{});
            if (server.isComplete()) {
                String authorizationID = server.getAuthorizationID();
                _logger.debug((Object)("Authenticated as " + authorizationID));
                return new AuthenticationResult(new UsernamePrincipal(authorizationID));
            }
            return new AuthenticationResult(challenge, AuthenticationResult.AuthenticationStatus.CONTINUE);
        }
        catch (SaslException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    public AuthenticationResult authenticate(String username, String password) {
        try {
            AuthenticationResult result = this.doLDAPNameAuthentication(this.getNameFromId(username), password);
            if (result.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS) {
                return new AuthenticationResult(new UsernamePrincipal(username));
            }
            return result;
        }
        catch (NamingException e) {
            return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private AuthenticationResult doLDAPNameAuthentication(String name, String password) {
        AuthenticationResult authenticationResult;
        InitialDirContext ctx;
        block12: {
            if (name == null) {
                return new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
            }
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", this._ldapContextFactory);
            env.put("java.naming.provider.url", this._providerAuthURL);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", name);
            env.put("java.naming.security.credentials", password);
            ctx = null;
            ctx = new InitialDirContext(env);
            authenticationResult = new AuthenticationResult(new UsernamePrincipal(name));
            Object var8_8 = null;
            if (ctx == null) break block12;
            try {
                ctx.close();
            }
            catch (Exception e2) {
                _logger.warn((Object)"Exception closing InitialDirContext", (Throwable)e2);
            }
        }
        return authenticationResult;
        catch (AuthenticationException ae) {
            AuthenticationResult authenticationResult2;
            block13: {
                authenticationResult2 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.CONTINUE);
                Object var8_9 = null;
                if (ctx == null) break block13;
                try {
                    ctx.close();
                }
                catch (Exception e2) {
                    _logger.warn((Object)"Exception closing InitialDirContext", (Throwable)e2);
                }
            }
            return authenticationResult2;
        }
        catch (NamingException e) {
            AuthenticationResult authenticationResult3;
            block14: {
                authenticationResult3 = new AuthenticationResult(AuthenticationResult.AuthenticationStatus.ERROR, e);
                Object var8_10 = null;
                if (ctx == null) break block14;
                {
                    catch (Throwable throwable) {
                        block15: {
                            Object var8_11 = null;
                            if (ctx == null) break block15;
                            try {
                                ctx.close();
                            }
                            catch (Exception e2) {
                                _logger.warn((Object)"Exception closing InitialDirContext", (Throwable)e2);
                            }
                        }
                        throw throwable;
                    }
                }
                try {
                    ctx.close();
                }
                catch (Exception e2) {
                    _logger.warn((Object)"Exception closing InitialDirContext", (Throwable)e2);
                }
            }
            return authenticationResult3;
        }
    }

    public void close() {
    }

    private void validateInitialDirContext() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this._ldapContextFactory);
        env.put("java.naming.provider.url", this._providerSearchURL);
        env.put("java.naming.security.authentication", "none");
        try {
            new InitialDirContext(env).close();
        }
        catch (NamingException e) {
            throw new RuntimeException("Unable to establish anonymous connection to the ldap server at " + this._providerSearchURL, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNameFromId(String id) throws NamingException {
        String string;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", this._ldapContextFactory);
        env.put("java.naming.provider.url", this._providerSearchURL);
        env.put("java.naming.security.authentication", "none");
        InitialDirContext ctx = null;
        ctx = new InitialDirContext(env);
        try {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setCountLimit(1L);
            searchControls.setSearchScope(2);
            NamingEnumeration<SearchResult> namingEnum = null;
            String name = null;
            namingEnum = ctx.search(this._searchContext, this._searchFilter, (Object[])new String[]{id}, searchControls);
            if (namingEnum.hasMore()) {
                SearchResult result = namingEnum.next();
                name = result.getNameInNamespace();
            }
            string = name;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                ctx.close();
            }
            catch (Exception e) {
                _logger.warn((Object)"Exception closing InitialDirContext", (Throwable)e);
            }
            throw throwable;
        }
        try {
            ctx.close();
        }
        catch (Exception e) {
            _logger.warn((Object)"Exception closing InitialDirContext", (Throwable)e);
        }
        return string;
    }

    private class PlainCallbackHandler
    implements CallbackHandler {
        private PlainCallbackHandler() {
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String name = null;
            String password = null;
            AuthenticationResult authenticated = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    String id = ((NameCallback)callback).getDefaultName();
                    try {
                        name = SimpleLDAPAuthenticationManager.this.getNameFromId(id);
                    }
                    catch (NamingException e) {
                        _logger.warn((Object)"SASL Authentication Exception", (Throwable)e);
                    }
                    if (password == null) continue;
                    authenticated = SimpleLDAPAuthenticationManager.this.doLDAPNameAuthentication(name, password);
                    continue;
                }
                if (callback instanceof PlainPasswordCallback) {
                    password = ((PlainPasswordCallback)callback).getPlainPassword();
                    if (name == null || (authenticated = SimpleLDAPAuthenticationManager.this.doLDAPNameAuthentication(name, password)).getStatus() != AuthenticationResult.AuthenticationStatus.SUCCESS) continue;
                    ((PlainPasswordCallback)callback).setAuthenticated(true);
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ((AuthorizeCallback)callback).setAuthorized(authenticated != null && authenticated.getStatus() == AuthenticationResult.AuthenticationStatus.SUCCESS);
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }
}

