/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager;

import org.apache.commons.configuration.Configuration;
import org.apache.qpid.server.plugin.AuthenticationManagerFactory;
import org.apache.qpid.server.security.auth.manager.AuthenticationManager;
import org.apache.qpid.server.security.auth.manager.SimpleLDAPAuthenticationManager;

public class SimpleLDAPAuthenticationManagerFactory
implements AuthenticationManagerFactory {
    private static final String DEFAULT_LDAP_CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";

    public AuthenticationManager createInstance(Configuration configuration) {
        Configuration subset = configuration.subset("simple-ldap-auth-manager");
        if (subset.isEmpty()) {
            return null;
        }
        String providerUrl = configuration.getString("simple-ldap-auth-manager.provider-url");
        String providerSearchUrl = configuration.getString("simple-ldap-auth-manager.provider-search-url", providerUrl);
        String providerAuthUrl = configuration.getString("simple-ldap-auth-manager.provider-auth-url", providerUrl);
        String searchContext = configuration.getString("simple-ldap-auth-manager.search-context");
        String searchFilter = configuration.getString("simple-ldap-auth-manager.search-filter");
        String ldapContextFactory = configuration.getString("simple-ldap-auth-manager.ldap-context-factory", DEFAULT_LDAP_CONTEXT_FACTORY);
        return new SimpleLDAPAuthenticationManager(providerSearchUrl, providerAuthUrl, searchContext, searchFilter, ldapContextFactory);
    }
}

