/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.rmi;

import java.net.SocketAddress;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.security.SubjectCreator;
import org.apache.qpid.server.security.auth.AuthenticationResult;
import org.apache.qpid.server.security.auth.SubjectAuthenticationResult;

public class RMIPasswordAuthenticator
implements JMXAuthenticator {
    static final String UNABLE_TO_LOOKUP = "The broker was unable to lookup the user details";
    static final String SHOULD_BE_STRING_ARRAY = "User details should be String[]";
    static final String SHOULD_HAVE_2_ELEMENTS = "User details should have 2 elements, username, password";
    static final String SHOULD_BE_NON_NULL = "Supplied username and password should be non-null";
    static final String INVALID_CREDENTIALS = "Invalid user details supplied";
    static final String USER_NOT_AUTHORISED_FOR_MANAGEMENT = "User not authorised for management";
    static final String CREDENTIALS_REQUIRED = "User details are required. Please ensure you are using an up to date management console to connect.";
    private final IApplicationRegistry _appRegistry;
    private final SocketAddress _socketAddress;

    public RMIPasswordAuthenticator(IApplicationRegistry appRegistry, SocketAddress socketAddress) {
        this._appRegistry = appRegistry;
        this._socketAddress = socketAddress;
    }

    public Subject authenticate(Object credentials) throws SecurityException {
        this.validateCredentials(credentials);
        String[] userCredentials = (String[])credentials;
        String username = userCredentials[0];
        String password = userCredentials[1];
        Subject authenticatedSubject = this.doAuthentication(username, password);
        this.doManagementAuthorisation(authenticatedSubject);
        return authenticatedSubject;
    }

    private void validateCredentials(Object credentials) {
        if (!(credentials instanceof String[])) {
            if (credentials == null) {
                throw new SecurityException(CREDENTIALS_REQUIRED);
            }
            throw new SecurityException(SHOULD_BE_STRING_ARRAY);
        }
        if (((String[])credentials).length != 2) {
            throw new SecurityException(SHOULD_HAVE_2_ELEMENTS);
        }
    }

    private Subject doAuthentication(String username, String password) {
        if (username == null || password == null) {
            throw new SecurityException(SHOULD_BE_NON_NULL);
        }
        SubjectCreator subjectCreator = this._appRegistry.getSubjectCreator(this._socketAddress);
        if (subjectCreator == null) {
            throw new SecurityException("Can't get subject creator for " + this._socketAddress);
        }
        SubjectAuthenticationResult result = subjectCreator.authenticate(username, password);
        if (AuthenticationResult.AuthenticationStatus.ERROR.equals((Object)result.getStatus())) {
            throw new SecurityException("Authentication manager failed", result.getCause());
        }
        if (AuthenticationResult.AuthenticationStatus.SUCCESS.equals((Object)result.getStatus())) {
            return result.getSubject();
        }
        throw new SecurityException(INVALID_CREDENTIALS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doManagementAuthorisation(Subject authenticatedSubject) {
        SecurityManager.setThreadSubject(authenticatedSubject);
        try {
            if (!this._appRegistry.getSecurityManager().accessManagement()) {
                throw new SecurityException(USER_NOT_AUTHORISED_FOR_MANAGEMENT);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            SecurityManager.setThreadSubject(null);
            throw throwable;
        }
        SecurityManager.setThreadSubject(null);
    }
}

