/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import java.io.IOException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.security.auth.UsernamePrincipal;
import org.apache.qpid.server.security.group.FileGroupDatabase;
import org.apache.qpid.server.security.group.GroupManager;
import org.apache.qpid.server.security.group.GroupPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroupManager
implements GroupManager {
    private final FileGroupDatabase _groupDatabase = new FileGroupDatabase();

    public FileGroupManager(String groupFile) throws ConfigurationException {
        try {
            this._groupDatabase.setGroupFile(groupFile);
        }
        catch (IOException e) {
            throw new ConfigurationException("Unable to set group file " + groupFile, (Throwable)e);
        }
    }

    @Override
    public Set<Principal> getGroupPrincipalsForUser(String userId) {
        Set<String> groups = this._groupDatabase.getGroupsForUser(userId);
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String groupName : groups) {
            principals.add((Principal)((Object)new GroupPrincipal(groupName)));
        }
        return principals;
    }

    @Override
    public Set<Principal> getUserPrincipalsForGroup(String group) {
        Set<String> users = this._groupDatabase.getUsersInGroup(group);
        if (users.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String user : users) {
            principals.add(new UsernamePrincipal(user));
        }
        return principals;
    }

    @Override
    public Set<Principal> getGroupPrincipals() {
        Set<String> groups = this._groupDatabase.getAllGroups();
        if (groups.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Principal> principals = new HashSet<Principal>();
        for (String groupName : groups) {
            principals.add((Principal)((Object)new GroupPrincipal(groupName)));
        }
        return principals;
    }

    @Override
    public void createGroup(String group) {
        this._groupDatabase.createGroup(group);
    }

    @Override
    public void removeGroup(String group) {
        this._groupDatabase.removeGroup(group);
    }

    @Override
    public void addUserToGroup(String user, String group) {
        this._groupDatabase.addUserToGroup(user, group);
    }

    @Override
    public void removeUserFromGroup(String user, String group) {
        this._groupDatabase.removeUserFromGroup(user, group);
    }
}

