/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.qpid.server.plugin.GroupManagerFactory;
import org.apache.qpid.server.security.group.FileGroupManager;
import org.apache.qpid.server.security.group.GroupManager;

public class FileGroupManagerFactory
implements GroupManagerFactory {
    private static final String GROUP_FILE_MARKER = "groupFile";
    private static final String FILE_ATTRIBUTE_VALUE = "file-group-manager.attributes.attribute.value";
    private static final String FILE_ATTRIBUTE_NAME = "file-group-manager.attributes.attribute.name";

    public GroupManager createInstance(Configuration configuration) {
        if (configuration.subset("file-group-manager").isEmpty()) {
            return null;
        }
        String groupFileArgumentName = configuration.getString(FILE_ATTRIBUTE_NAME);
        String groupFile = configuration.getString(FILE_ATTRIBUTE_VALUE);
        if (!GROUP_FILE_MARKER.equals(groupFileArgumentName)) {
            throw new RuntimeException("Config for file-group-manager found but file-group-manager.attributes.attribute.name has no value or " + groupFileArgumentName + " does not equal " + GROUP_FILE_MARKER);
        }
        if (groupFile == null) {
            throw new RuntimeException("Config for file-group-manager found but file-group-manager.attributes.attribute.value has no value. Filename expected.");
        }
        try {
            return new FileGroupManager(groupFile);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }
}

