/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.group;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.qpid.server.security.group.GroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupPrincipalAccessor {
    private final List<GroupManager> _groupManagerList;

    public GroupPrincipalAccessor(List<GroupManager> groupManagerList) {
        this._groupManagerList = groupManagerList;
    }

    public Set<Principal> getGroupPrincipals(String username) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (GroupManager groupManager : this._groupManagerList) {
            Set<Principal> groups = groupManager.getGroupPrincipalsForUser(username);
            if (groups == null) continue;
            principals.addAll(groups);
        }
        return Collections.unmodifiableSet(principals);
    }
}

