/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.derby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.AMQStoreException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.server.binding.Binding;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.message.EnqueableMessage;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.store.ConfigurationRecoveryHandler;
import org.apache.qpid.server.store.ConfiguredObjectHelper;
import org.apache.qpid.server.store.ConfiguredObjectRecord;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.EventManager;
import org.apache.qpid.server.store.MessageMetaDataType;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.MessageStoreRecoveryHandler;
import org.apache.qpid.server.store.State;
import org.apache.qpid.server.store.StateManager;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMemoryMessage;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.Transaction;
import org.apache.qpid.server.store.TransactionLogRecoveryHandler;
import org.apache.qpid.server.store.TransactionLogResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DerbyMessageStore
implements MessageStore {
    private static final Logger _logger = Logger.getLogger(DerbyMessageStore.class);
    private static final String SQL_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DB_VERSION_TABLE_NAME = "QPID_DB_VERSION";
    private static final String QUEUE_ENTRY_TABLE_NAME = "QPID_QUEUE_ENTRIES";
    private static final String META_DATA_TABLE_NAME = "QPID_MESSAGE_METADATA";
    private static final String MESSAGE_CONTENT_TABLE_NAME = "QPID_MESSAGE_CONTENT";
    private static final String LINKS_TABLE_NAME = "QPID_LINKS";
    private static final String BRIDGES_TABLE_NAME = "QPID_BRIDGES";
    private static final String XID_TABLE_NAME = "QPID_XIDS";
    private static final String XID_ACTIONS_TABLE_NAME = "QPID_XID_ACTIONS";
    private static final String CONFIGURED_OBJECTS_TABLE_NAME = "QPID_CONFIGURED_OBJECTS";
    private static final int DB_VERSION = 6;
    private static Class<Driver> DRIVER_CLASS;
    public static final String MEMORY_STORE_LOCATION = ":memory:";
    private final AtomicLong _messageId = new AtomicLong(0L);
    private AtomicBoolean _closed = new AtomicBoolean(false);
    private String _connectionURL;
    private static final String TABLE_EXISTANCE_QUERY = "SELECT 1 FROM SYS.SYSTABLES WHERE TABLENAME = ?";
    private static final String CREATE_DB_VERSION_TABLE = "CREATE TABLE QPID_DB_VERSION ( version int not null )";
    private static final String INSERT_INTO_DB_VERSION = "INSERT INTO QPID_DB_VERSION ( version ) VALUES ( ? )";
    private static final String CREATE_QUEUE_ENTRY_TABLE = "CREATE TABLE QPID_QUEUE_ENTRIES ( queue_id varchar(36) not null, message_id bigint not null, PRIMARY KEY (queue_id, message_id) )";
    private static final String INSERT_INTO_QUEUE_ENTRY = "INSERT INTO QPID_QUEUE_ENTRIES (queue_id, message_id) values (?,?)";
    private static final String DELETE_FROM_QUEUE_ENTRY = "DELETE FROM QPID_QUEUE_ENTRIES WHERE queue_id = ? AND message_id =?";
    private static final String SELECT_FROM_QUEUE_ENTRY = "SELECT queue_id, message_id FROM QPID_QUEUE_ENTRIES ORDER BY queue_id, message_id";
    private static final String CREATE_META_DATA_TABLE = "CREATE TABLE QPID_MESSAGE_METADATA ( message_id bigint not null, meta_data blob, PRIMARY KEY ( message_id ) )";
    private static final String CREATE_MESSAGE_CONTENT_TABLE = "CREATE TABLE QPID_MESSAGE_CONTENT ( message_id bigint not null, content blob , PRIMARY KEY (message_id) )";
    private static final String INSERT_INTO_MESSAGE_CONTENT = "INSERT INTO QPID_MESSAGE_CONTENT( message_id, content ) values (?, ?)";
    private static final String SELECT_FROM_MESSAGE_CONTENT = "SELECT content FROM QPID_MESSAGE_CONTENT WHERE message_id = ?";
    private static final String DELETE_FROM_MESSAGE_CONTENT = "DELETE FROM QPID_MESSAGE_CONTENT WHERE message_id = ?";
    private static final String INSERT_INTO_META_DATA = "INSERT INTO QPID_MESSAGE_METADATA( message_id , meta_data ) values (?, ?)";
    private static final String SELECT_FROM_META_DATA = "SELECT meta_data FROM QPID_MESSAGE_METADATA WHERE message_id = ?";
    private static final String DELETE_FROM_META_DATA = "DELETE FROM QPID_MESSAGE_METADATA WHERE message_id = ?";
    private static final String SELECT_ALL_FROM_META_DATA = "SELECT message_id, meta_data FROM QPID_MESSAGE_METADATA";
    private static final String CREATE_LINKS_TABLE = "CREATE TABLE QPID_LINKS ( id_lsb bigint not null, id_msb bigint not null, create_time bigint not null, arguments blob,  PRIMARY KEY ( id_lsb, id_msb ))";
    private static final String SELECT_FROM_LINKS = "SELECT create_time, arguments FROM QPID_LINKS WHERE id_lsb = ? and id_msb";
    private static final String DELETE_FROM_LINKS = "DELETE FROM QPID_LINKS WHERE id_lsb = ? and id_msb = ?";
    private static final String SELECT_ALL_FROM_LINKS = "SELECT id_lsb, id_msb, create_time, arguments FROM QPID_LINKS";
    private static final String FIND_LINK = "SELECT id_lsb, id_msb FROM QPID_LINKS WHERE id_lsb = ? and id_msb = ?";
    private static final String INSERT_INTO_LINKS = "INSERT INTO QPID_LINKS( id_lsb, id_msb, create_time, arguments ) values (?, ?, ?, ?)";
    private static final String CREATE_BRIDGES_TABLE = "CREATE TABLE QPID_BRIDGES ( id_lsb bigint not null, id_msb bigint not null, create_time bigint not null, link_id_lsb bigint not null, link_id_msb bigint not null, arguments blob,  PRIMARY KEY ( id_lsb, id_msb ))";
    private static final String SELECT_FROM_BRIDGES = "SELECT create_time, link_id_lsb, link_id_msb, arguments FROM QPID_BRIDGES WHERE id_lsb = ? and id_msb = ?";
    private static final String DELETE_FROM_BRIDGES = "DELETE FROM QPID_BRIDGES WHERE id_lsb = ? and id_msb = ?";
    private static final String SELECT_ALL_FROM_BRIDGES = "SELECT id_lsb, id_msb,  create_time, link_id_lsb, link_id_msb, arguments FROM QPID_BRIDGES WHERE link_id_lsb = ? and link_id_msb = ?";
    private static final String FIND_BRIDGE = "SELECT id_lsb, id_msb FROM QPID_BRIDGES WHERE id_lsb = ? and id_msb = ?";
    private static final String INSERT_INTO_BRIDGES = "INSERT INTO QPID_BRIDGES( id_lsb, id_msb, create_time, link_id_lsb, link_id_msb, arguments ) values (?, ?, ?, ?, ?, ?)";
    private static final String CREATE_XIDS_TABLE = "CREATE TABLE QPID_XIDS ( format bigint not null, global_id varchar(64) for bit data, branch_id varchar(64) for bit data,  PRIMARY KEY ( format, global_id, branch_id ))";
    private static final String INSERT_INTO_XIDS = "INSERT INTO QPID_XIDS ( format, global_id, branch_id ) values (?, ?, ?)";
    private static final String DELETE_FROM_XIDS = "DELETE FROM QPID_XIDS WHERE format = ? and global_id = ? and branch_id = ?";
    private static final String SELECT_ALL_FROM_XIDS = "SELECT format, global_id, branch_id FROM QPID_XIDS";
    private static final String CREATE_XID_ACTIONS_TABLE = "CREATE TABLE QPID_XID_ACTIONS ( format bigint not null, global_id varchar(64) for bit data not null, branch_id varchar(64) for bit data not null, action_type char not null, queue_id varchar(36) not null, message_id bigint not null,  PRIMARY KEY ( format, global_id, branch_id, action_type, queue_id, message_id))";
    private static final String INSERT_INTO_XID_ACTIONS = "INSERT INTO QPID_XID_ACTIONS ( format, global_id, branch_id, action_type, queue_id, message_id ) values (?,?,?,?,?,?) ";
    private static final String DELETE_FROM_XID_ACTIONS = "DELETE FROM QPID_XID_ACTIONS WHERE format = ? and global_id = ? and branch_id = ?";
    private static final String SELECT_ALL_FROM_XID_ACTIONS = "SELECT action_type, queue_id, message_id FROM QPID_XID_ACTIONS WHERE format = ? and global_id = ? and branch_id = ?";
    private static final String CREATE_CONFIGURED_OBJECTS_TABLE = "CREATE TABLE QPID_CONFIGURED_OBJECTS ( id VARCHAR(36) not null, object_type varchar(255), attributes blob,  PRIMARY KEY (id))";
    private static final String INSERT_INTO_CONFIGURED_OBJECTS = "INSERT INTO QPID_CONFIGURED_OBJECTS ( id, object_type, attributes) VALUES (?,?,?)";
    private static final String UPDATE_CONFIGURED_OBJECTS = "UPDATE QPID_CONFIGURED_OBJECTS set object_type =?, attributes = ? where id = ?";
    private static final String DELETE_FROM_CONFIGURED_OBJECTS = "DELETE FROM QPID_CONFIGURED_OBJECTS where id = ?";
    private static final String FIND_CONFIGURED_OBJECT = "SELECT object_type, attributes FROM QPID_CONFIGURED_OBJECTS where id = ?";
    private static final String SELECT_FROM_CONFIGURED_OBJECTS = "SELECT id, object_type, attributes FROM QPID_CONFIGURED_OBJECTS";
    private final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String DERBY_SINGLE_DB_SHUTDOWN_CODE = "08006";
    private static final String DERBY_STORE_TYPE = "DERBY";
    private final StateManager _stateManager;
    private final EventManager _eventManager = new EventManager();
    private long _totalStoreSize;
    private boolean _limitBusted;
    private long _persistentSizeLowThreshold;
    private long _persistentSizeHighThreshold;
    private MessageStoreRecoveryHandler _messageRecoveryHandler;
    private TransactionLogRecoveryHandler _tlogRecoveryHandler;
    private ConfigurationRecoveryHandler _configRecoveryHandler;
    private String _storeLocation;
    private ConfiguredObjectHelper _configuredObjectHelper = new ConfiguredObjectHelper();

    public DerbyMessageStore() {
        this._stateManager = new StateManager(this._eventManager);
    }

    @Override
    public void configureConfigStore(String name, ConfigurationRecoveryHandler configRecoveryHandler, Configuration storeConfiguration) throws Exception {
        this._stateManager.attainState(State.INITIALISING);
        this._configRecoveryHandler = configRecoveryHandler;
        this.commonConfiguration(name, storeConfiguration);
    }

    @Override
    public void configureMessageStore(String name, MessageStoreRecoveryHandler recoveryHandler, TransactionLogRecoveryHandler tlogRecoveryHandler, Configuration storeConfiguration) throws Exception {
        this._tlogRecoveryHandler = tlogRecoveryHandler;
        this._messageRecoveryHandler = recoveryHandler;
        this._stateManager.attainState(State.INITIALISED);
    }

    @Override
    public void activate() throws Exception {
        this._stateManager.attainState(State.ACTIVATING);
        this.recoverConfiguration(this._configRecoveryHandler);
        this.recoverMessages(this._messageRecoveryHandler);
        TransactionLogRecoveryHandler.DtxRecordRecoveryHandler dtxrh = this.recoverQueueEntries(this._tlogRecoveryHandler);
        this.recoverXids(dtxrh);
        this._stateManager.attainState(State.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commonConfiguration(String name, Configuration storeConfiguration) throws ClassNotFoundException, SQLException {
        File environmentPath;
        DerbyMessageStore.initialiseDriver();
        String databasePath = storeConfiguration.getString("environment-path", System.getProperty("QPID_WORK") + File.separator + "derbyDB");
        if (!(MEMORY_STORE_LOCATION.equals(databasePath) || (environmentPath = new File(databasePath)).exists() || environmentPath.mkdirs())) {
            throw new IllegalArgumentException("Environment path " + environmentPath + " could not be read or created. " + "Ensure the path is correct and that the permissions are correct.");
        }
        this._storeLocation = databasePath;
        this._persistentSizeHighThreshold = storeConfiguration.getLong("overfull-size", -1L);
        this._persistentSizeLowThreshold = storeConfiguration.getLong("underfull-size", this._persistentSizeHighThreshold);
        if (this._persistentSizeLowThreshold > this._persistentSizeHighThreshold || this._persistentSizeLowThreshold < 0L) {
            this._persistentSizeLowThreshold = this._persistentSizeHighThreshold;
        }
        this.createOrOpenDatabase(name, databasePath);
        Connection conn = this.newAutoCommitConnection();
        try {
            this._totalStoreSize = this.getSizeOnDisk(conn);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    private static synchronized void initialiseDriver() throws ClassNotFoundException {
        if (DRIVER_CLASS == null) {
            DRIVER_CLASS = Class.forName(SQL_DRIVER_NAME);
        }
    }

    private void createOrOpenDatabase(String name, String environmentPath) throws SQLException {
        this._connectionURL = "jdbc:derby" + (environmentPath.equals(MEMORY_STORE_LOCATION) ? environmentPath : ":" + environmentPath + "/") + name + ";create=true";
        Connection conn = this.newAutoCommitConnection();
        this.createVersionTable(conn);
        this.createConfiguredObjectsTable(conn);
        this.createQueueEntryTable(conn);
        this.createMetaDataTable(conn);
        this.createMessageContentTable(conn);
        this.createLinkTable(conn);
        this.createBridgeTable(conn);
        this.createXidTable(conn);
        this.createXidActionTable(conn);
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVersionTable(Connection conn) throws SQLException {
        if (!this.tableExists(DB_VERSION_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_DB_VERSION_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            PreparedStatement pstmt = conn.prepareStatement(INSERT_INTO_DB_VERSION);
            try {
                pstmt.setInt(1, 6);
                pstmt.execute();
                Object var6_7 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createConfiguredObjectsTable(Connection conn) throws SQLException {
        if (!this.tableExists(CONFIGURED_OBJECTS_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_CONFIGURED_OBJECTS_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createQueueEntryTable(Connection conn) throws SQLException {
        if (!this.tableExists(QUEUE_ENTRY_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_QUEUE_ENTRY_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMetaDataTable(Connection conn) throws SQLException {
        if (!this.tableExists(META_DATA_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_META_DATA_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMessageContentTable(Connection conn) throws SQLException {
        if (!this.tableExists(MESSAGE_CONTENT_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_MESSAGE_CONTENT_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLinkTable(Connection conn) throws SQLException {
        if (!this.tableExists(LINKS_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_LINKS_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBridgeTable(Connection conn) throws SQLException {
        if (!this.tableExists(BRIDGES_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_BRIDGES_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXidTable(Connection conn) throws SQLException {
        if (!this.tableExists(XID_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_XIDS_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXidActionTable(Connection conn) throws SQLException {
        if (!this.tableExists(XID_ACTIONS_TABLE_NAME, conn)) {
            Statement stmt = conn.createStatement();
            try {
                stmt.execute(CREATE_XID_ACTIONS_TABLE);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableExists(String tableName, Connection conn) throws SQLException {
        boolean bl;
        PreparedStatement stmt = conn.prepareStatement(TABLE_EXISTANCE_QUERY);
        try {
            stmt.setString(1, tableName);
            ResultSet rs = stmt.executeQuery();
            try {
                bl = rs.next();
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                rs.close();
                throw throwable;
            }
            rs.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return bl;
    }

    private void recoverConfiguration(ConfigurationRecoveryHandler recoveryHandler) throws AMQException {
        try {
            List<ConfiguredObjectRecord> configuredObjects = this.loadConfiguredObjects();
            ConfigurationRecoveryHandler.ExchangeRecoveryHandler erh = recoveryHandler.begin(this);
            this._configuredObjectHelper.recoverExchanges(erh, configuredObjects);
            ConfigurationRecoveryHandler.QueueRecoveryHandler qrh = erh.completeExchangeRecovery();
            this._configuredObjectHelper.recoverQueues(qrh, configuredObjects);
            ConfigurationRecoveryHandler.BindingRecoveryHandler brh = qrh.completeQueueRecovery();
            this._configuredObjectHelper.recoverBindings(brh, configuredObjects);
            brh.completeBindingRecovery();
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error recovering persistent state: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        block2: {
            this._closed.getAndSet(true);
            this._stateManager.attainState(State.CLOSING);
            try {
                Connection conn = DriverManager.getConnection(this._connectionURL + ";shutdown=true");
                conn.close();
                _logger.error((Object)"Unable to shut down the store");
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase(DERBY_SINGLE_DB_SHUTDOWN_CODE)) break block2;
                _logger.error((Object)("Exception whilst shutting down the store: " + e));
            }
        }
        this._stateManager.attainState(State.CLOSED);
    }

    public StoredMessage addMessage(StorableMessageMetaData metaData) {
        if (metaData.isPersistent()) {
            return new StoredDerbyMessage(this._messageId.incrementAndGet(), metaData);
        }
        return new StoredMemoryMessage(this._messageId.incrementAndGet(), metaData);
    }

    public StoredMessage getMessage(long messageNumber) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeMessage(long messageId) {
        try {
            Connection conn = this.newConnection();
            try {
                try {
                    PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_META_DATA);
                    try {
                        stmt.setLong(1, messageId);
                        int results = stmt.executeUpdate();
                        stmt.close();
                        if (results == 0) {
                            _logger.warn((Object)("Message metadata not found for message id " + messageId));
                        }
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Deleted metadata for message " + messageId));
                        }
                        stmt = conn.prepareStatement(DELETE_FROM_MESSAGE_CONTENT);
                        stmt.setLong(1, messageId);
                        results = stmt.executeUpdate();
                        Object var7_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                    conn.commit();
                }
                catch (SQLException e) {
                    try {
                        conn.rollback();
                        throw e;
                    }
                    catch (SQLException t) {
                        // empty catch block
                    }
                    throw e;
                }
                Object var9_11 = null;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error removing message with id " + messageId + " from database: " + e.getMessage(), e);
        }
    }

    @Override
    public void createExchange(Exchange exchange) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            ConfiguredObjectRecord configuredObject = this._configuredObjectHelper.createExchangeConfiguredObject(exchange);
            this.insertConfiguredObject(configuredObject);
        }
    }

    @Override
    public void removeExchange(Exchange exchange) throws AMQStoreException {
        int results = this.removeConfiguredObject(exchange.getId());
        if (results == 0) {
            throw new AMQStoreException("Exchange " + exchange.getName() + " with id " + exchange.getId() + " not found");
        }
    }

    @Override
    public void bindQueue(Binding binding) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            ConfiguredObjectRecord configuredObject = this._configuredObjectHelper.createBindingConfiguredObject(binding);
            this.insertConfiguredObject(configuredObject);
        }
    }

    @Override
    public void unbindQueue(Binding binding) throws AMQStoreException {
        int results = this.removeConfiguredObject(binding.getId());
        if (results == 0) {
            throw new AMQStoreException("Binding " + binding + " not found");
        }
    }

    @Override
    public void createQueue(AMQQueue queue) throws AMQStoreException {
        this.createQueue(queue, null);
    }

    @Override
    public void createQueue(AMQQueue queue, FieldTable arguments) throws AMQStoreException {
        _logger.debug((Object)("public void createQueue(AMQQueue queue = " + queue + "): called"));
        if (this._stateManager.isInState(State.ACTIVE)) {
            ConfiguredObjectRecord queueConfiguredObject = this._configuredObjectHelper.createQueueConfiguredObject(queue, arguments);
            this.insertConfiguredObject(queueConfiguredObject);
        }
    }

    @Override
    public void updateQueue(AMQQueue queue) throws AMQStoreException {
        ConfiguredObjectRecord queueConfiguredObject;
        if (this._stateManager.isInState(State.ACTIVE) && (queueConfiguredObject = this.loadConfiguredObject(queue.getId())) != null) {
            ConfiguredObjectRecord newQueueRecord = this._configuredObjectHelper.updateQueueConfiguredObject(queue, queueConfiguredObject);
            this.updateConfiguredObject(newQueueRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection newAutoCommitConnection() throws SQLException {
        Connection connection = this.newConnection();
        try {
            connection.setAutoCommit(true);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw sqlEx;
            }
            throw sqlEx;
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection newConnection() throws SQLException {
        Connection connection = DriverManager.getConnection(this._connectionURL);
        try {
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
        }
        catch (SQLException sqlEx) {
            try {
                connection.close();
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw sqlEx;
            }
            throw sqlEx;
        }
        return connection;
    }

    @Override
    public void removeQueue(AMQQueue queue) throws AMQStoreException {
        AMQShortString name = queue.getNameShortString();
        _logger.debug((Object)("public void removeQueue(AMQShortString name = " + name + "): called"));
        int results = this.removeConfiguredObject(queue.getId());
        if (results == 0) {
            throw new AMQStoreException("Queue " + name + " with id " + queue.getId() + " not found");
        }
    }

    private byte[] convertStringMapToBytes(Map<String, String> arguments) throws AMQStoreException {
        byte[] argumentBytes;
        if (arguments == null) {
            argumentBytes = new byte[]{};
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeInt(arguments.size());
                for (Map.Entry<String, String> arg : arguments.entrySet()) {
                    dos.writeUTF(arg.getKey());
                    dos.writeUTF(arg.getValue());
                }
            }
            catch (IOException e) {
                throw new AMQStoreException(e.getMessage(), (Throwable)e);
            }
            argumentBytes = bos.toByteArray();
        }
        return argumentBytes;
    }

    @Override
    public Transaction newTransaction() {
        return new DerbyTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(ConnectionWrapper connWrapper, TransactionLogResource queue, Long messageId) throws AMQStoreException {
        Connection conn = connWrapper.getConnection();
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Enqueuing message " + messageId + " on queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() : "") + queue.getId() + "[Connection" + conn + "]"));
            }
            PreparedStatement stmt = conn.prepareStatement(INSERT_INTO_QUEUE_ENTRY);
            try {
                stmt.setString(1, queue.getId().toString());
                stmt.setLong(2, messageId);
                stmt.executeUpdate();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Failed to enqueue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error writing enqueued message with id " + messageId + " for queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() : "") + " with id " + queue.getId() + " to database", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dequeueMessage(ConnectionWrapper connWrapper, TransactionLogResource queue, Long messageId) throws AMQStoreException {
        Connection conn = connWrapper.getConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_QUEUE_ENTRY);
            try {
                stmt.setString(1, queue.getId().toString());
                stmt.setLong(2, messageId);
                int results = stmt.executeUpdate();
                if (results != 1) {
                    throw new AMQStoreException("Unable to find message with id " + messageId + " on queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() : "") + " with id " + queue.getId());
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Dequeuing message " + messageId + " on queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() : "") + " with id " + queue.getId()));
                }
                Object var8_8 = null;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Failed to dequeue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error deleting enqueued message with id " + messageId + " for queue " + (queue instanceof AMQQueue ? ((AMQQueue)queue).getName() : "") + " with id " + queue.getId() + " from database", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeXid(ConnectionWrapper connWrapper, long format, byte[] globalId, byte[] branchId) throws AMQStoreException {
        Connection conn = connWrapper.getConnection();
        try {
            int results;
            PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_XIDS);
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                results = stmt.executeUpdate();
                if (results != 1) {
                    throw new AMQStoreException("Unable to find message with xid");
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            stmt = conn.prepareStatement(DELETE_FROM_XID_ACTIONS);
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                results = stmt.executeUpdate();
                Object var12_12 = null;
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Failed to dequeue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error deleting enqueued message with xid", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordXid(ConnectionWrapper connWrapper, long format, byte[] globalId, byte[] branchId, Transaction.Record[] enqueues, Transaction.Record[] dequeues) throws AMQStoreException {
        Connection conn = connWrapper.getConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement(INSERT_INTO_XIDS);
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                stmt.executeUpdate();
                Object var11_10 = null;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            stmt = conn.prepareStatement(INSERT_INTO_XID_ACTIONS);
            try {
                stmt.setLong(1, format);
                stmt.setBytes(2, globalId);
                stmt.setBytes(3, branchId);
                if (enqueues != null) {
                    stmt.setString(4, "E");
                    for (Transaction.Record record : enqueues) {
                        stmt.setString(5, record.getQueue().getId().toString());
                        stmt.setLong(6, record.getMessage().getMessageNumber());
                        stmt.executeUpdate();
                    }
                }
                if (dequeues != null) {
                    stmt.setString(4, "D");
                    for (Transaction.Record record : dequeues) {
                        stmt.setString(5, record.getQueue().getId().toString());
                        stmt.setLong(6, record.getMessage().getMessageNumber());
                        stmt.executeUpdate();
                    }
                }
                Object var15_18 = null;
            }
            catch (Throwable throwable) {
                Object var15_19 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            {
            }
        }
        catch (SQLException e) {
            _logger.error((Object)("Failed to enqueue: " + e.getMessage()), (Throwable)e);
            throw new AMQStoreException("Error writing xid ", (Throwable)e);
        }
    }

    public void commitTran(ConnectionWrapper connWrapper) throws AMQStoreException {
        try {
            try {
                Connection conn = connWrapper.getConnection();
                conn.commit();
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)"commit tran completed");
                }
                conn.close();
            }
            catch (SQLException e) {
                throw new AMQStoreException("Error commit tx: " + e.getMessage(), (Throwable)e);
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            throw throwable;
        }
    }

    public StoreFuture commitTranAsync(ConnectionWrapper connWrapper) throws AMQStoreException {
        this.commitTran(connWrapper);
        return StoreFuture.IMMEDIATE_FUTURE;
    }

    public void abortTran(ConnectionWrapper connWrapper) throws AMQStoreException {
        if (connWrapper == null) {
            throw new AMQStoreException("Fatal internal error: transactional context is empty at abortTran");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("abort tran called: " + connWrapper.getConnection()));
        }
        try {
            Connection conn = connWrapper.getConnection();
            conn.rollback();
            conn.close();
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error aborting transaction: " + e.getMessage(), (Throwable)e);
        }
    }

    public Long getNewMessageId() {
        return this._messageId.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMetaData(Connection conn, long messageId, StorableMessageMetaData metaData) throws SQLException {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Adding metadata for message " + messageId));
        }
        PreparedStatement stmt = conn.prepareStatement(INSERT_INTO_META_DATA);
        try {
            stmt.setLong(1, messageId);
            int bodySize = 1 + metaData.getStorableSize();
            byte[] underlying = new byte[bodySize];
            underlying[0] = (byte)metaData.getType().ordinal();
            ByteBuffer buf = ByteBuffer.wrap(underlying);
            buf.position(1);
            buf = buf.slice();
            metaData.writeToBuffer(0, buf);
            ByteArrayInputStream bis = new ByteArrayInputStream(underlying);
            try {
                stmt.setBinaryStream(2, (InputStream)bis, underlying.length);
                int result = stmt.executeUpdate();
                if (result == 0) {
                    throw new RuntimeException("Unable to add meta data for message " + messageId);
                }
                Object var12_10 = null;
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                try {
                    bis.close();
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                throw throwable;
            }
            try {
                bis.close();
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            stmt.close();
            throw throwable;
        }
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverMessages(MessageStoreRecoveryHandler recoveryHandler) throws SQLException {
        Connection conn = this.newAutoCommitConnection();
        try {
            MessageStoreRecoveryHandler.StoredMessageRecoveryHandler messageHandler = recoveryHandler.begin();
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(SELECT_ALL_FROM_META_DATA);
                try {
                    long maxId = 0L;
                    while (rs.next()) {
                        long messageId = rs.getLong(1);
                        Blob dataAsBlob = rs.getBlob(2);
                        if (messageId > maxId) {
                            maxId = messageId;
                        }
                        byte[] dataAsBytes = dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
                        ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                        buf.position(1);
                        buf = buf.slice();
                        MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                        StorableMessageMetaData metaData = type.getFactory().createMetaData(buf);
                        StoredDerbyMessage message = new StoredDerbyMessage(messageId, metaData, true);
                        messageHandler.message(message);
                    }
                    this._messageId.set(maxId);
                    messageHandler.completeMessageRecovery();
                    Object var17_14 = null;
                }
                catch (Throwable throwable) {
                    Object var17_15 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var19_17 = null;
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            Object var21_20 = null;
        }
        catch (Throwable throwable) {
            Object var21_21 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionLogRecoveryHandler.DtxRecordRecoveryHandler recoverQueueEntries(TransactionLogRecoveryHandler recoveryHandler) throws SQLException {
        TransactionLogRecoveryHandler.DtxRecordRecoveryHandler dtxRecordRecoveryHandler;
        Connection conn = this.newAutoCommitConnection();
        try {
            TransactionLogRecoveryHandler.QueueEntryRecoveryHandler queueEntryHandler = recoveryHandler.begin(this);
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(SELECT_FROM_QUEUE_ENTRY);
                try {
                    while (rs.next()) {
                        String id = rs.getString(1);
                        long messageId = rs.getLong(2);
                        queueEntryHandler.queueEntry(UUID.fromString(id), messageId);
                    }
                    Object var10_8 = null;
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var12_11 = null;
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            dtxRecordRecoveryHandler = queueEntryHandler.completeQueueEntryRecovery();
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return dtxRecordRecoveryHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverXids(TransactionLogRecoveryHandler.DtxRecordRecoveryHandler dtxrh) throws SQLException {
        Connection conn = this.newAutoCommitConnection();
        try {
            ArrayList<Xid> xids = new ArrayList<Xid>();
            Statement stmt = conn.createStatement();
            try {
                ResultSet rs = stmt.executeQuery(SELECT_ALL_FROM_XIDS);
                try {
                    while (rs.next()) {
                        long format = rs.getLong(1);
                        byte[] globalId = rs.getBytes(2);
                        byte[] branchId = rs.getBytes(3);
                        xids.add(new Xid(format, globalId, branchId));
                    }
                    Object var11_10 = null;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var13_14 = null;
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            for (Xid xid : xids) {
                Object var20_23;
                ArrayList<RecordImpl> enqueues = new ArrayList<RecordImpl>();
                ArrayList dequeues = new ArrayList();
                PreparedStatement pstmt = conn.prepareStatement(SELECT_ALL_FROM_XID_ACTIONS);
                try {
                    Object var18_22;
                    pstmt.setLong(1, xid.getFormat());
                    pstmt.setBytes(2, xid.getGlobalId());
                    pstmt.setBytes(3, xid.getBranchId());
                    ResultSet rs = pstmt.executeQuery();
                    try {
                        while (rs.next()) {
                            String actionType = rs.getString(1);
                            UUID queueId = UUID.fromString(rs.getString(2));
                            long messageId = rs.getLong(3);
                            RecordImpl record = new RecordImpl(queueId, messageId);
                            ArrayList<RecordImpl> records = "E".equals(actionType) ? enqueues : dequeues;
                            records.add(record);
                        }
                        var18_22 = null;
                    }
                    catch (Throwable throwable) {
                        var18_22 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    var20_23 = null;
                }
                catch (Throwable throwable) {
                    var20_23 = null;
                    pstmt.close();
                    throw throwable;
                }
                pstmt.close();
                dtxrh.dtxRecord(xid.getFormat(), xid.getGlobalId(), xid.getBranchId(), enqueues.toArray(new RecordImpl[enqueues.size()]), dequeues.toArray(new RecordImpl[dequeues.size()]));
            }
            dtxrh.completeDtxRecordRecovery();
            Object var22_26 = null;
        }
        catch (Throwable throwable) {
            Object var22_27 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    StorableMessageMetaData getMetaData(long messageId) throws SQLException {
        StorableMessageMetaData storableMessageMetaData;
        Connection conn = this.newAutoCommitConnection();
        try {
            ResultSet rs;
            PreparedStatement stmt = conn.prepareStatement(SELECT_FROM_META_DATA);
            try {
                stmt.setLong(1, messageId);
                rs = stmt.executeQuery();
                try {
                    StorableMessageMetaData metaData;
                    if (!rs.next()) throw new RuntimeException("Meta data not found for message with id " + messageId);
                    Blob dataAsBlob = rs.getBlob(1);
                    byte[] dataAsBytes = dataAsBlob.getBytes(1L, (int)dataAsBlob.length());
                    ByteBuffer buf = ByteBuffer.wrap(dataAsBytes);
                    buf.position(1);
                    buf = buf.slice();
                    MessageMetaDataType type = MessageMetaDataType.values()[dataAsBytes[0]];
                    storableMessageMetaData = metaData = type.getFactory().createMetaData(buf);
                    Object var13_11 = null;
                }
                catch (Throwable throwable) {
                    Object var13_12 = null;
                    rs.close();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                stmt.close();
                throw throwable;
            }
            rs.close();
            Object var15_13 = null;
            stmt.close();
            Object var17_15 = null;
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return storableMessageMetaData;
    }

    private void addContent(Connection conn, long messageId, ByteBuffer src) {
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)("Adding content for message " + messageId));
        }
        PreparedStatement stmt = null;
        try {
            try {
                src = src.slice();
                byte[] chunkData = new byte[src.limit()];
                src.duplicate().get(chunkData);
                stmt = conn.prepareStatement(INSERT_INTO_MESSAGE_CONTENT);
                stmt.setLong(1, messageId);
                ByteArrayInputStream bis = new ByteArrayInputStream(chunkData);
                stmt.setBinaryStream(2, (InputStream)bis, chunkData.length);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                this.closeConnection(conn);
                throw new RuntimeException("Error adding content for message " + messageId + ": " + e.getMessage(), e);
            }
            Object var9_8 = null;
            this.closePreparedStatement(stmt);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.closePreparedStatement(stmt);
            throw throwable;
        }
    }

    public int getContent(long messageId, int offset, ByteBuffer dst) {
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = this.newAutoCommitConnection();
            stmt = conn.prepareStatement(SELECT_FROM_MESSAGE_CONTENT);
            stmt.setLong(1, messageId);
            ResultSet rs = stmt.executeQuery();
            int written = 0;
            if (rs.next()) {
                Blob dataAsBlob = rs.getBlob(1);
                int size = (int)dataAsBlob.length();
                byte[] dataAsBytes = dataAsBlob.getBytes(1L, size);
                if (offset > size) {
                    throw new RuntimeException("Offset " + offset + " is greater than message size " + size + " for message id " + messageId + "!");
                }
                written = size - offset;
                if (written > dst.remaining()) {
                    written = dst.remaining();
                }
                dst.put(dataAsBytes, offset, written);
            }
            int n = written;
            Object var13_13 = null;
            this.closePreparedStatement(stmt);
            this.closeConnection(conn);
            return n;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException("Error retrieving content from offset " + offset + " for message " + messageId + ": " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                this.closePreparedStatement(stmt);
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    private void closeConnection(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                _logger.error((Object)"Problem closing connection", (Throwable)e);
            }
        }
    }

    private void closePreparedStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException e) {
                _logger.error((Object)"Problem closing prepared statement", (Throwable)e);
            }
        }
    }

    @Override
    public void addEventListener(EventListener eventListener, Event ... events) {
        this._eventManager.addEventListener(eventListener, events);
    }

    @Override
    public String getStoreLocation() {
        return this._storeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertConfiguredObject(ConfiguredObjectRecord configuredObject) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            try {
                Connection conn = this.newAutoCommitConnection();
                try {
                    PreparedStatement stmt = conn.prepareStatement(FIND_CONFIGURED_OBJECT);
                    try {
                        stmt.setString(1, configuredObject.getId().toString());
                        ResultSet rs = stmt.executeQuery();
                        try {
                            if (!rs.next()) {
                                PreparedStatement insertStmt = conn.prepareStatement(INSERT_INTO_CONFIGURED_OBJECTS);
                                try {
                                    insertStmt.setString(1, configuredObject.getId().toString());
                                    insertStmt.setString(2, configuredObject.getType());
                                    if (configuredObject.getAttributes() == null) {
                                        insertStmt.setNull(3, 2004);
                                    } else {
                                        byte[] attributesAsBytes = configuredObject.getAttributes().getBytes(this.UTF8_CHARSET);
                                        ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                                        insertStmt.setBinaryStream(3, (InputStream)bis, attributesAsBytes.length);
                                    }
                                    insertStmt.execute();
                                    Object var9_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_10 = null;
                                    insertStmt.close();
                                    throw throwable;
                                }
                                insertStmt.close();
                                {
                                }
                            }
                            Object var11_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            rs.close();
                            throw throwable;
                        }
                        rs.close();
                        Object var13_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_16 = null;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                    Object var15_18 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                {
                }
            }
            catch (SQLException e) {
                throw new AMQStoreException("Error inserting of configured object " + configuredObject + " into database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeConfiguredObject(UUID id) throws AMQStoreException {
        int results = 0;
        try {
            Connection conn = this.newAutoCommitConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(DELETE_FROM_CONFIGURED_OBJECTS);
                try {
                    stmt.setString(1, id.toString());
                    results = stmt.executeUpdate();
                    Object var6_6 = null;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
                Object var8_9 = null;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            {
            }
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error deleting of configured object with id " + id + " from database: " + e.getMessage(), (Throwable)e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfiguredObject(ConfiguredObjectRecord configuredObject) throws AMQStoreException {
        if (this._stateManager.isInState(State.ACTIVE)) {
            try {
                Connection conn = this.newAutoCommitConnection();
                try {
                    PreparedStatement stmt = conn.prepareStatement(FIND_CONFIGURED_OBJECT);
                    try {
                        stmt.setString(1, configuredObject.getId().toString());
                        ResultSet rs = stmt.executeQuery();
                        try {
                            if (rs.next()) {
                                PreparedStatement stmt2 = conn.prepareStatement(UPDATE_CONFIGURED_OBJECTS);
                                try {
                                    stmt2.setString(1, configuredObject.getType());
                                    if (configuredObject.getAttributes() != null) {
                                        byte[] attributesAsBytes = configuredObject.getAttributes().getBytes(this.UTF8_CHARSET);
                                        ByteArrayInputStream bis = new ByteArrayInputStream(attributesAsBytes);
                                        stmt2.setBinaryStream(2, (InputStream)bis, attributesAsBytes.length);
                                    } else {
                                        stmt2.setNull(2, 2004);
                                    }
                                    stmt2.setString(3, configuredObject.getId().toString());
                                    stmt2.execute();
                                    Object var9_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var9_10 = null;
                                    stmt2.close();
                                    throw throwable;
                                }
                                stmt2.close();
                                {
                                }
                            }
                            Object var11_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var11_13 = null;
                            rs.close();
                            throw throwable;
                        }
                        rs.close();
                        Object var13_15 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_16 = null;
                        stmt.close();
                        throw throwable;
                    }
                    stmt.close();
                    Object var15_18 = null;
                }
                catch (Throwable throwable) {
                    Object var15_19 = null;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                {
                }
            }
            catch (SQLException e) {
                throw new AMQStoreException("Error updating configured object " + configuredObject + " in database: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredObjectRecord loadConfiguredObject(UUID id) throws AMQStoreException {
        ConfiguredObjectRecord result = null;
        try {
            Connection conn = this.newAutoCommitConnection();
            try {
                PreparedStatement stmt = conn.prepareStatement(FIND_CONFIGURED_OBJECT);
                try {
                    stmt.setString(1, id.toString());
                    ResultSet rs = stmt.executeQuery();
                    try {
                        if (rs.next()) {
                            String type = rs.getString(1);
                            Blob blob = rs.getBlob(2);
                            String attributes = null;
                            if (blob != null) {
                                attributes = this.blobToString(blob);
                            }
                            result = new ConfiguredObjectRecord(id, type, attributes);
                        }
                        Object var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                    Object var12_13 = null;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    stmt.close();
                    throw throwable;
                }
                stmt.close();
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                conn.close();
                throw throwable;
            }
            conn.close();
            {
            }
        }
        catch (SQLException e) {
            throw new AMQStoreException("Error loading of configured object with id " + id + " from database: " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String blobToString(Blob blob) throws SQLException {
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        return new String(bytes, this.UTF8_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ConfiguredObjectRecord> loadConfiguredObjects() throws SQLException {
        ArrayList<ConfiguredObjectRecord> results = new ArrayList<ConfiguredObjectRecord>();
        Connection conn = this.newAutoCommitConnection();
        try {
            PreparedStatement stmt = conn.prepareStatement(SELECT_FROM_CONFIGURED_OBJECTS);
            try {
                ResultSet rs = stmt.executeQuery();
                try {
                    while (rs.next()) {
                        String id = rs.getString(1);
                        String objectType = rs.getString(2);
                        String attributes = this.blobToString(rs.getBlob(3));
                        results.add(new ConfiguredObjectRecord(UUID.fromString(id), objectType, attributes));
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    rs.close();
                    throw throwable;
                }
                rs.close();
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void storedSizeChange(int delta) {
        if (this.getPersistentSizeHighThreshold() > 0L) {
            DerbyMessageStore derbyMessageStore = this;
            synchronized (derbyMessageStore) {
                long newSize = this._totalStoreSize += (long)(3 * delta);
                Connection conn = null;
                try {
                    if (!this._limitBusted && newSize > this.getPersistentSizeHighThreshold()) {
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (this._totalStoreSize > this.getPersistentSizeHighThreshold()) {
                            this._limitBusted = true;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
                        }
                    } else if (this._limitBusted && newSize < this.getPersistentSizeLowThreshold()) {
                        long oldSize = this._totalStoreSize;
                        conn = this.newAutoCommitConnection();
                        this._totalStoreSize = this.getSizeOnDisk(conn);
                        if (oldSize <= this._totalStoreSize) {
                            this.reduceSizeOnDisk(conn);
                            this._totalStoreSize = this.getSizeOnDisk(conn);
                        }
                        if (this._totalStoreSize < this.getPersistentSizeLowThreshold()) {
                            this._limitBusted = false;
                            this._eventManager.notifyEvent(Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
                        }
                    }
                }
                catch (SQLException e) {
                    this.closeConnection(conn);
                    throw new RuntimeException("Exception will processing store size change", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reduceSizeOnDisk(Connection conn) {
        CallableStatement cs = null;
        PreparedStatement stmt = null;
        try {
            try {
                ArrayList<String> tables;
                ArrayList<String> schemas;
                block9: {
                    String tableQuery = "SELECT S.SCHEMANAME, T.TABLENAME FROM SYS.SYSSCHEMAS S, SYS.SYSTABLES T WHERE S.SCHEMAID = T.SCHEMAID AND T.TABLETYPE='T'";
                    stmt = conn.prepareStatement(tableQuery);
                    ResultSet rs = null;
                    schemas = new ArrayList<String>();
                    tables = new ArrayList<String>();
                    try {
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            schemas.add(rs.getString(1));
                            tables.add(rs.getString(2));
                        }
                        Object var9_9 = null;
                        if (rs == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (rs == null) throw throwable;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                }
                cs = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
                int i = 0;
                while (true) {
                    if (i >= schemas.size()) {
                        Object var11_13 = null;
                        this.closePreparedStatement(stmt);
                        this.closePreparedStatement(cs);
                        return;
                    }
                    cs.setString(1, (String)schemas.get(i));
                    cs.setString(2, (String)tables.get(i));
                    cs.setShort(3, (short)0);
                    cs.execute();
                    ++i;
                }
            }
            catch (SQLException e) {
                this.closeConnection(conn);
                throw new RuntimeException("Error reducing on disk size", e);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.closePreparedStatement(stmt);
            this.closePreparedStatement(cs);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long getSizeOnDisk(Connection conn) {
        PreparedStatement stmt = null;
        try {
            try {
                long size;
                block7: {
                    String sizeQuery = "SELECT SUM(T2.NUMALLOCATEDPAGES * T2.PAGESIZE) TOTALSIZE    FROM         SYS.SYSTABLES systabs,        TABLE (SYSCS_DIAG.SPACE_TABLE(systabs.tablename)) AS T2    WHERE systabs.tabletype = 'T'";
                    stmt = conn.prepareStatement(sizeQuery);
                    ResultSet rs = null;
                    size = 0L;
                    try {
                        rs = stmt.executeQuery();
                        while (rs.next()) {
                            size = rs.getLong(1);
                        }
                        Object var8_7 = null;
                        if (rs == null) break block7;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (rs == null) throw throwable;
                        rs.close();
                        throw throwable;
                    }
                    rs.close();
                }
                long l = size;
                Object var10_11 = null;
                this.closePreparedStatement(stmt);
                return l;
            }
            catch (SQLException e) {
                this.closeConnection(conn);
                throw new RuntimeException("Error establishing on disk size", e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.closePreparedStatement(stmt);
            throw throwable;
        }
    }

    private long getPersistentSizeLowThreshold() {
        return this._persistentSizeLowThreshold;
    }

    private long getPersistentSizeHighThreshold() {
        return this._persistentSizeHighThreshold;
    }

    @Override
    public String getStoreType() {
        return DERBY_STORE_TYPE;
    }

    private class StoredDerbyMessage
    implements StoredMessage {
        private final long _messageId;
        private final boolean _isRecovered;
        private StorableMessageMetaData _metaData;
        private volatile SoftReference<StorableMessageMetaData> _metaDataRef;
        private byte[] _data;
        private volatile SoftReference<byte[]> _dataRef;

        StoredDerbyMessage(long messageId, StorableMessageMetaData metaData) {
            this(messageId, metaData, false);
        }

        StoredDerbyMessage(long messageId, StorableMessageMetaData metaData, boolean isRecovered) {
            this._messageId = messageId;
            this._isRecovered = isRecovered;
            if (!this._isRecovered) {
                this._metaData = metaData;
            }
            this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
        }

        public StorableMessageMetaData getMetaData() {
            StorableMessageMetaData metaData;
            StorableMessageMetaData storableMessageMetaData = metaData = this._metaData == null ? this._metaDataRef.get() : this._metaData;
            if (metaData == null) {
                try {
                    metaData = DerbyMessageStore.this.getMetaData(this._messageId);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                this._metaDataRef = new SoftReference<StorableMessageMetaData>(metaData);
            }
            return metaData;
        }

        public long getMessageNumber() {
            return this._messageId;
        }

        public void addContent(int offsetInMessage, ByteBuffer src) {
            src = src.slice();
            if (this._data == null) {
                this._data = new byte[src.remaining()];
                this._dataRef = new SoftReference<byte[]>(this._data);
                src.duplicate().get(this._data);
            } else {
                byte[] oldData = this._data;
                this._data = new byte[oldData.length + src.remaining()];
                this._dataRef = new SoftReference<byte[]>(this._data);
                System.arraycopy(oldData, 0, this._data, 0, oldData.length);
                src.duplicate().get(this._data, oldData.length, src.remaining());
            }
        }

        public int getContent(int offsetInMessage, ByteBuffer dst) {
            byte[] data;
            byte[] byArray = data = this._dataRef == null ? null : this._dataRef.get();
            if (data != null) {
                int length = Math.min(dst.remaining(), data.length - offsetInMessage);
                dst.put(data, offsetInMessage, length);
                return length;
            }
            return DerbyMessageStore.this.getContent(this._messageId, offsetInMessage, dst);
        }

        public ByteBuffer getContent(int offsetInMessage, int size) {
            ByteBuffer buf = ByteBuffer.allocate(size);
            this.getContent(offsetInMessage, buf);
            buf.position(0);
            return buf;
        }

        public synchronized StoreFuture flushToStore() {
            Connection conn = null;
            try {
                block5: {
                    try {
                        if (this.stored()) break block5;
                        conn = DerbyMessageStore.this.newConnection();
                        this.store(conn);
                        conn.commit();
                        DerbyMessageStore.this.storedSizeChange(this.getMetaData().getContentSize());
                    }
                    catch (SQLException e) {
                        if (_logger.isDebugEnabled()) {
                            _logger.debug((Object)("Error when trying to flush message " + this._messageId + " to store: " + e));
                        }
                        throw new RuntimeException(e);
                    }
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                DerbyMessageStore.this.closeConnection(conn);
                throw throwable;
            }
            DerbyMessageStore.this.closeConnection(conn);
            return StoreFuture.IMMEDIATE_FUTURE;
        }

        public void remove() {
            int delta = this.getMetaData().getContentSize();
            DerbyMessageStore.this.removeMessage(this._messageId);
            DerbyMessageStore.this.storedSizeChange(-delta);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void store(Connection conn) throws SQLException {
            if (!this.stored()) {
                try {
                    DerbyMessageStore.this.storeMetaData(conn, this._messageId, this._metaData);
                    DerbyMessageStore.this.addContent(conn, this._messageId, this._data == null ? ByteBuffer.allocate(0) : ByteBuffer.wrap(this._data));
                    Object var3_2 = null;
                    this._metaData = null;
                    this._data = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this._metaData = null;
                    this._data = null;
                    throw throwable;
                }
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Storing message " + this._messageId + " to store"));
                }
            }
        }

        private boolean stored() {
            return this._metaData == null || this._isRecovered;
        }
    }

    private class DerbyTransaction
    implements Transaction {
        private final ConnectionWrapper _connWrapper;
        private int _storeSizeIncrease;

        private DerbyTransaction() {
            try {
                this._connWrapper = new ConnectionWrapper(DerbyMessageStore.this.newConnection());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }

        public void enqueueMessage(TransactionLogResource queue, EnqueableMessage message) throws AMQStoreException {
            StoredMessage storedMessage = message.getStoredMessage();
            if (storedMessage instanceof StoredDerbyMessage) {
                try {
                    ((StoredDerbyMessage)storedMessage).store(this._connWrapper.getConnection());
                }
                catch (SQLException e) {
                    throw new AMQStoreException("Exception on enqueuing message " + DerbyMessageStore.this._messageId, (Throwable)e);
                }
            }
            this._storeSizeIncrease += storedMessage.getMetaData().getContentSize();
            DerbyMessageStore.this.enqueueMessage(this._connWrapper, queue, message.getMessageNumber());
        }

        public void dequeueMessage(TransactionLogResource queue, EnqueableMessage message) throws AMQStoreException {
            DerbyMessageStore.this.dequeueMessage(this._connWrapper, queue, message.getMessageNumber());
        }

        public void commitTran() throws AMQStoreException {
            DerbyMessageStore.this.commitTran(this._connWrapper);
            DerbyMessageStore.this.storedSizeChange(this._storeSizeIncrease);
        }

        public StoreFuture commitTranAsync() throws AMQStoreException {
            StoreFuture storeFuture = DerbyMessageStore.this.commitTranAsync(this._connWrapper);
            DerbyMessageStore.this.storedSizeChange(this._storeSizeIncrease);
            return storeFuture;
        }

        public void abortTran() throws AMQStoreException {
            DerbyMessageStore.this.abortTran(this._connWrapper);
        }

        public void removeXid(long format, byte[] globalId, byte[] branchId) throws AMQStoreException {
            DerbyMessageStore.this.removeXid(this._connWrapper, format, globalId, branchId);
        }

        public void recordXid(long format, byte[] globalId, byte[] branchId, Transaction.Record[] enqueues, Transaction.Record[] dequeues) throws AMQStoreException {
            DerbyMessageStore.this.recordXid(this._connWrapper, format, globalId, branchId, enqueues, dequeues);
        }
    }

    private static class RecordImpl
    implements Transaction.Record,
    TransactionLogResource,
    EnqueableMessage {
        private long _messageNumber;
        private UUID _queueId;

        public RecordImpl(UUID queueId, long messageNumber) {
            this._messageNumber = messageNumber;
            this._queueId = queueId;
        }

        public TransactionLogResource getQueue() {
            return this;
        }

        public EnqueableMessage getMessage() {
            return this;
        }

        public long getMessageNumber() {
            return this._messageNumber;
        }

        public boolean isPersistent() {
            return true;
        }

        public StoredMessage getStoredMessage() {
            throw new UnsupportedOperationException();
        }

        public UUID getId() {
            return this._queueId;
        }
    }

    private static final class Xid {
        private final long _format;
        private final byte[] _globalId;
        private final byte[] _branchId;

        public Xid(long format, byte[] globalId, byte[] branchId) {
            this._format = format;
            this._globalId = globalId;
            this._branchId = branchId;
        }

        public long getFormat() {
            return this._format;
        }

        public byte[] getGlobalId() {
            return this._globalId;
        }

        public byte[] getBranchId() {
            return this._branchId;
        }
    }

    private static final class ConnectionWrapper {
        private final Connection _connection;

        public ConnectionWrapper(Connection conn) {
            this._connection = conn;
        }

        public Connection getConnection() {
            return this._connection;
        }
    }
}

