/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.subscription;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.AMQException;
import org.apache.qpid.common.AMQPFilterTypes;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQConstant;
import org.apache.qpid.server.AMQChannel;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.flow.FlowCreditManager;
import org.apache.qpid.server.flow.FlowCreditManager_0_10;
import org.apache.qpid.server.protocol.AMQProtocolSession;
import org.apache.qpid.server.subscription.ClientDeliveryMethod;
import org.apache.qpid.server.subscription.RecordDeliveryMethod;
import org.apache.qpid.server.subscription.Subscription;
import org.apache.qpid.server.subscription.SubscriptionFactory;
import org.apache.qpid.server.subscription.SubscriptionImpl;
import org.apache.qpid.server.subscription.Subscription_0_10;
import org.apache.qpid.server.transport.ServerSession;
import org.apache.qpid.transport.MessageAcceptMode;
import org.apache.qpid.transport.MessageAcquireMode;
import org.apache.qpid.transport.MessageFlowMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionFactoryImpl
implements SubscriptionFactory {
    private static final AtomicLong SUB_ID_GENERATOR = new AtomicLong(0L);
    public static final SubscriptionFactoryImpl INSTANCE = new SubscriptionFactoryImpl();

    @Override
    public Subscription createSubscription(int channelId, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager) throws AMQException {
        AMQChannel channel = protocolSession.getChannel(channelId);
        if (channel == null) {
            throw new AMQException(AMQConstant.NOT_FOUND, "channel :" + channelId + " not found in protocol session");
        }
        ClientDeliveryMethod clientMethod = channel.getClientDeliveryMethod();
        RecordDeliveryMethod recordMethod = channel.getRecordDeliveryMethod();
        return this.createSubscription(channel, protocolSession, consumerTag, acks, filters, noLocal, creditManager, clientMethod, recordMethod);
    }

    @Override
    public Subscription createSubscription(AMQChannel channel, AMQProtocolSession protocolSession, AMQShortString consumerTag, boolean acks, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod clientMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        Boolean isBrowserObj;
        boolean isBrowser = filters != null ? (isBrowserObj = (Boolean)filters.get(AMQPFilterTypes.NO_CONSUME.getValue())) != null && isBrowserObj != false : false;
        if (isBrowser) {
            return new SubscriptionImpl.BrowserSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod, SubscriptionFactoryImpl.getNextSubscriptionId());
        }
        if (acks) {
            return new SubscriptionImpl.AckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod, SubscriptionFactoryImpl.getNextSubscriptionId());
        }
        return new SubscriptionImpl.NoAckSubscription(channel, protocolSession, consumerTag, filters, noLocal, creditManager, clientMethod, recordMethod, SubscriptionFactoryImpl.getNextSubscriptionId());
    }

    @Override
    public SubscriptionImpl.GetNoAckSubscription createBasicGetNoAckSubscription(AMQChannel channel, AMQProtocolSession session, AMQShortString consumerTag, FieldTable filters, boolean noLocal, FlowCreditManager creditManager, ClientDeliveryMethod deliveryMethod, RecordDeliveryMethod recordMethod) throws AMQException {
        return new SubscriptionImpl.GetNoAckSubscription(channel, session, null, null, false, creditManager, deliveryMethod, recordMethod, SubscriptionFactoryImpl.getNextSubscriptionId());
    }

    @Override
    public Subscription_0_10 createSubscription(ServerSession session, String destination, MessageAcceptMode acceptMode, MessageAcquireMode acquireMode, MessageFlowMode flowMode, FlowCreditManager_0_10 creditManager, FilterManager filterManager, Map<String, Object> arguments) {
        return new Subscription_0_10(session, destination, acceptMode, acquireMode, flowMode, creditManager, filterManager, arguments, SubscriptionFactoryImpl.getNextSubscriptionId());
    }

    private static long getNextSubscriptionId() {
        return SUB_ID_GENERATOR.getAndIncrement();
    }
}

