/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.server.binding.BindingFactory;
import org.apache.qpid.server.configuration.ExchangeConfiguration;
import org.apache.qpid.server.configuration.QueueConfiguration;
import org.apache.qpid.server.configuration.VirtualHostConfiguration;
import org.apache.qpid.server.connection.ConnectionRegistry;
import org.apache.qpid.server.connection.IConnectionRegistry;
import org.apache.qpid.server.exchange.DefaultExchangeFactory;
import org.apache.qpid.server.exchange.DefaultExchangeRegistry;
import org.apache.qpid.server.exchange.Exchange;
import org.apache.qpid.server.exchange.ExchangeFactory;
import org.apache.qpid.server.exchange.ExchangeRegistry;
import org.apache.qpid.server.logging.actors.CurrentActor;
import org.apache.qpid.server.logging.messages.VirtualHostMessages;
import org.apache.qpid.server.logging.subjects.MessageStoreLogSubject;
import org.apache.qpid.server.model.UUIDGenerator;
import org.apache.qpid.server.protocol.AMQConnectionModel;
import org.apache.qpid.server.protocol.AMQSessionModel;
import org.apache.qpid.server.protocol.v1_0.LinkRegistry;
import org.apache.qpid.server.queue.AMQQueue;
import org.apache.qpid.server.queue.AMQQueueFactory;
import org.apache.qpid.server.queue.DefaultQueueRegistry;
import org.apache.qpid.server.queue.QueueRegistry;
import org.apache.qpid.server.registry.IApplicationRegistry;
import org.apache.qpid.server.security.SecurityManager;
import org.apache.qpid.server.stats.StatisticsCounter;
import org.apache.qpid.server.store.Event;
import org.apache.qpid.server.store.EventListener;
import org.apache.qpid.server.store.HAMessageStore;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.OperationalLoggingListener;
import org.apache.qpid.server.txn.DtxRegistry;
import org.apache.qpid.server.virtualhost.HouseKeepingTask;
import org.apache.qpid.server.virtualhost.State;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.server.virtualhost.VirtualHostConfigRecoveryHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHostImpl
implements VirtualHost,
IConnectionRegistry.RegistryChangeListener,
EventListener {
    private static final Logger _logger = Logger.getLogger(VirtualHostImpl.class);
    private static final int HOUSEKEEPING_SHUTDOWN_TIMEOUT = 5;
    private final String _name;
    private final UUID _id;
    private final long _createTime = System.currentTimeMillis();
    private final ScheduledThreadPoolExecutor _houseKeepingTasks;
    private final IApplicationRegistry _appRegistry;
    private final SecurityManager _securityManager;
    private final VirtualHostConfiguration _vhostConfig;
    private final QueueRegistry _queueRegistry;
    private final ExchangeRegistry _exchangeRegistry;
    private final ExchangeFactory _exchangeFactory;
    private final ConnectionRegistry _connectionRegistry;
    private final BindingFactory _bindingFactory;
    private final DtxRegistry _dtxRegistry;
    private final MessageStore _messageStore;
    private volatile State _state = State.INITIALISING;
    private StatisticsCounter _messagesDelivered;
    private StatisticsCounter _dataDelivered;
    private StatisticsCounter _messagesReceived;
    private StatisticsCounter _dataReceived;
    private final Map<String, LinkRegistry> _linkRegistry = new HashMap<String, LinkRegistry>();
    private boolean _blocked;

    public VirtualHostImpl(IApplicationRegistry appRegistry, VirtualHostConfiguration hostConfig) throws Exception {
        if (hostConfig == null) {
            throw new IllegalArgumentException("HostConfig cannot be null");
        }
        if (hostConfig.getName() == null || hostConfig.getName().length() == 0) {
            throw new IllegalArgumentException("Illegal name (" + hostConfig.getName() + ") for virtualhost.");
        }
        this._appRegistry = appRegistry;
        this._vhostConfig = hostConfig;
        this._name = this._vhostConfig.getName();
        this._dtxRegistry = new DtxRegistry();
        this._id = UUIDGenerator.generateVhostUUID(this._name);
        CurrentActor.get().message(VirtualHostMessages.CREATED(this._name));
        this._securityManager = new SecurityManager(this._appRegistry.getSecurityManager(), this._vhostConfig.getConfig());
        this._connectionRegistry = new ConnectionRegistry();
        this._connectionRegistry.addRegistryChangeListener(this);
        this._houseKeepingTasks = new ScheduledThreadPoolExecutor(this._vhostConfig.getHouseKeepingThreadCount());
        this._queueRegistry = new DefaultQueueRegistry(this);
        this._exchangeFactory = new DefaultExchangeFactory(this);
        this._exchangeRegistry = new DefaultExchangeRegistry(this);
        this._bindingFactory = new BindingFactory(this);
        this._messageStore = this.initialiseMessageStore(hostConfig.getMessageStoreClass());
        this.configureMessageStore(hostConfig);
        this.activateNonHAMessageStore();
        this.initialiseStatistics();
        this._messageStore.addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_OVERFULL);
        this._messageStore.addEventListener(this, Event.PERSISTENT_MESSAGE_SIZE_UNDERFULL);
    }

    @Override
    public IConnectionRegistry getConnectionRegistry() {
        return this._connectionRegistry;
    }

    @Override
    public VirtualHostConfiguration getConfiguration() {
        return this._vhostConfig;
    }

    @Override
    public UUID getId() {
        return this._id;
    }

    public boolean isDurable() {
        return false;
    }

    private void initialiseHouseKeeping(long period) {
        if (period != 0L) {
            this.scheduleHouseKeepingTask(period, new VirtualHostHouseKeepingTask());
        }
    }

    private void shutdownHouseKeeping() {
        this._houseKeepingTasks.shutdown();
        try {
            if (!this._houseKeepingTasks.awaitTermination(5L, TimeUnit.SECONDS)) {
                this._houseKeepingTasks.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            _logger.warn((Object)"Interrupted during Housekeeping shutdown:", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void removeHouseKeepingTasks() {
        BlockingQueue<Runnable> taskQueue = this._houseKeepingTasks.getQueue();
        for (Runnable runnable : taskQueue) {
            this._houseKeepingTasks.remove(runnable);
        }
    }

    @Override
    public void scheduleHouseKeepingTask(long period, HouseKeepingTask task) {
        this._houseKeepingTasks.scheduleAtFixedRate(task, period / 2L, period, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> scheduleTask(long delay, Runnable task) {
        return this._houseKeepingTasks.schedule(task, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getHouseKeepingTaskCount() {
        return this._houseKeepingTasks.getTaskCount();
    }

    @Override
    public long getHouseKeepingCompletedTaskCount() {
        return this._houseKeepingTasks.getCompletedTaskCount();
    }

    @Override
    public int getHouseKeepingPoolSize() {
        return this._houseKeepingTasks.getCorePoolSize();
    }

    @Override
    public void setHouseKeepingPoolSize(int newSize) {
        this._houseKeepingTasks.setCorePoolSize(newSize);
    }

    @Override
    public int getHouseKeepingActiveCount() {
        return this._houseKeepingTasks.getActiveCount();
    }

    private MessageStore initialiseMessageStore(String messageStoreClass) throws Exception {
        Class<?> clazz = Class.forName(messageStoreClass);
        Object o = clazz.newInstance();
        if (!(o instanceof MessageStore)) {
            throw new ClassCastException("Message store factory class must implement " + MessageStore.class + ". Class " + clazz + " does not.");
        }
        MessageStore messageStore = (MessageStore)o;
        MessageStoreLogSubject storeLogSubject = new MessageStoreLogSubject(this, clazz.getSimpleName());
        OperationalLoggingListener.listen(messageStore, storeLogSubject);
        messageStore.addEventListener(new BeforeActivationListener(), Event.BEFORE_ACTIVATE);
        messageStore.addEventListener(new AfterActivationListener(), Event.AFTER_ACTIVATE);
        messageStore.addEventListener(new BeforeCloseListener(), Event.BEFORE_CLOSE);
        messageStore.addEventListener(new BeforePassivationListener(), Event.BEFORE_PASSIVATE);
        return messageStore;
    }

    private void configureMessageStore(VirtualHostConfiguration hostConfig) throws Exception {
        VirtualHostConfigRecoveryHandler recoveryHandler = new VirtualHostConfigRecoveryHandler(this);
        this._messageStore.configureConfigStore(this.getName(), recoveryHandler, hostConfig.getStoreConfiguration());
        this._messageStore.configureMessageStore(this.getName(), recoveryHandler, recoveryHandler, hostConfig.getStoreConfiguration());
    }

    private void activateNonHAMessageStore() throws Exception {
        if (!(this._messageStore instanceof HAMessageStore)) {
            this._messageStore.activate();
        }
    }

    private void initialiseModel(VirtualHostConfiguration config) throws ConfigurationException, AMQException {
        String[] queueNames;
        _logger.debug((Object)("Loading configuration for virtualhost: " + config.getName()));
        List exchangeNames = config.getExchanges();
        for (String exchangeName : exchangeNames) {
            this.configureExchange(config.getExchangeConfiguration(exchangeName));
        }
        for (String queueNameObj : queueNames = config.getQueueNames()) {
            String queueName = String.valueOf(queueNameObj);
            this.configureQueue(config.getQueueConfiguration(queueName));
        }
    }

    private void configureExchange(ExchangeConfiguration exchangeConfiguration) throws AMQException {
        AMQShortString exchangeName = new AMQShortString(exchangeConfiguration.getName());
        Exchange exchange = this._exchangeRegistry.getExchange(exchangeName);
        if (exchange == null) {
            AMQShortString type = new AMQShortString(exchangeConfiguration.getType());
            boolean durable = exchangeConfiguration.getDurable();
            boolean autodelete = exchangeConfiguration.getAutoDelete();
            Exchange newExchange = this._exchangeFactory.createExchange(exchangeName, type, durable, autodelete, 0);
            this._exchangeRegistry.registerExchange(newExchange);
            if (newExchange.isDurable()) {
                this._messageStore.createExchange(newExchange);
            }
        }
    }

    private void configureQueue(QueueConfiguration queueConfiguration) throws AMQException, ConfigurationException {
        String exchangeName;
        Exchange exchange;
        AMQQueue queue = AMQQueueFactory.createAMQQueueImpl(queueConfiguration, this);
        String queueName = queue.getName();
        if (queue.isDurable()) {
            this.getMessageStore().createQueue(queue);
        }
        if ((exchange = this._exchangeRegistry.getExchange(exchangeName = queueConfiguration.getExchange())) == null) {
            throw new ConfigurationException("Attempt to bind queue '" + queueName + "' to unknown exchange:" + exchangeName);
        }
        Exchange defaultExchange = this._exchangeRegistry.getDefaultExchange();
        List routingKeys = queueConfiguration.getRoutingKeys();
        for (Object routingKeyNameObj : routingKeys) {
            String routingKey = String.valueOf(routingKeyNameObj);
            if (exchange.equals(defaultExchange) && !queueName.equals(routingKey)) {
                throw new ConfigurationException("Illegal attempt to bind queue '" + queueName + "' to the default exchange with a key other than the queue name: " + routingKey);
            }
            this.configureBinding(queue, exchange, routingKey);
        }
        if (!exchange.equals(defaultExchange)) {
            this.configureBinding(queue, exchange, queueName);
        }
        this.configureBinding(queue, defaultExchange, queueName);
    }

    private void configureBinding(AMQQueue queue, Exchange exchange, String routingKey) throws AMQException {
        if (_logger.isInfoEnabled()) {
            _logger.info((Object)("Binding queue:" + queue + " with routing key '" + routingKey + "' to exchange:" + exchange.getName()));
        }
        this._bindingFactory.addBinding(routingKey, queue, exchange, null);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public long getCreateTime() {
        return this._createTime;
    }

    @Override
    public QueueRegistry getQueueRegistry() {
        return this._queueRegistry;
    }

    @Override
    public ExchangeRegistry getExchangeRegistry() {
        return this._exchangeRegistry;
    }

    @Override
    public ExchangeFactory getExchangeFactory() {
        return this._exchangeFactory;
    }

    @Override
    public MessageStore getMessageStore() {
        return this._messageStore;
    }

    @Override
    public SecurityManager getSecurityManager() {
        return this._securityManager;
    }

    @Override
    public void close() {
        this._connectionRegistry.close();
        this._queueRegistry.stopAllAndUnregisterMBeans();
        this._dtxRegistry.close();
        if (this._messageStore != null) {
            try {
                this._messageStore.close();
            }
            catch (Exception e) {
                _logger.error((Object)"Failed to close message store", (Throwable)e);
            }
        }
        this._state = State.STOPPED;
        CurrentActor.get().message(VirtualHostMessages.CLOSED());
    }

    @Override
    public UUID getBrokerId() {
        return this._appRegistry.getBrokerId();
    }

    @Override
    public IApplicationRegistry getApplicationRegistry() {
        return this._appRegistry;
    }

    @Override
    public BindingFactory getBindingFactory() {
        return this._bindingFactory;
    }

    @Override
    public void registerMessageDelivered(long messageSize) {
        this._messagesDelivered.registerEvent(1L);
        this._dataDelivered.registerEvent(messageSize);
        this._appRegistry.registerMessageDelivered(messageSize);
    }

    @Override
    public void registerMessageReceived(long messageSize, long timestamp) {
        this._messagesReceived.registerEvent(1L, timestamp);
        this._dataReceived.registerEvent(messageSize, timestamp);
        this._appRegistry.registerMessageReceived(messageSize, timestamp);
    }

    @Override
    public StatisticsCounter getMessageReceiptStatistics() {
        return this._messagesReceived;
    }

    @Override
    public StatisticsCounter getDataReceiptStatistics() {
        return this._dataReceived;
    }

    @Override
    public StatisticsCounter getMessageDeliveryStatistics() {
        return this._messagesDelivered;
    }

    @Override
    public StatisticsCounter getDataDeliveryStatistics() {
        return this._dataDelivered;
    }

    @Override
    public void resetStatistics() {
        this._messagesDelivered.reset();
        this._dataDelivered.reset();
        this._messagesReceived.reset();
        this._dataReceived.reset();
        for (AMQConnectionModel connection : this._connectionRegistry.getConnections()) {
            connection.resetStatistics();
        }
    }

    @Override
    public void initialiseStatistics() {
        this._messagesDelivered = new StatisticsCounter("messages-delivered-" + this.getName());
        this._dataDelivered = new StatisticsCounter("bytes-delivered-" + this.getName());
        this._messagesReceived = new StatisticsCounter("messages-received-" + this.getName());
        this._dataReceived = new StatisticsCounter("bytes-received-" + this.getName());
    }

    @Override
    public synchronized LinkRegistry getLinkRegistry(String remoteContainerId) {
        LinkRegistry linkRegistry = this._linkRegistry.get(remoteContainerId);
        if (linkRegistry == null) {
            linkRegistry = new LinkRegistry();
            this._linkRegistry.put(remoteContainerId, linkRegistry);
        }
        return linkRegistry;
    }

    @Override
    public DtxRegistry getDtxRegistry() {
        return this._dtxRegistry;
    }

    public String toString() {
        return this._name;
    }

    @Override
    public State getState() {
        return this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block() {
        ConnectionRegistry connectionRegistry = this._connectionRegistry;
        synchronized (connectionRegistry) {
            if (!this._blocked) {
                this._blocked = true;
                for (AMQConnectionModel conn : this._connectionRegistry.getConnections()) {
                    conn.block();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unblock() {
        ConnectionRegistry connectionRegistry = this._connectionRegistry;
        synchronized (connectionRegistry) {
            if (this._blocked) {
                this._blocked = false;
                for (AMQConnectionModel conn : this._connectionRegistry.getConnections()) {
                    conn.unblock();
                }
            }
        }
    }

    @Override
    public void connectionRegistered(AMQConnectionModel connection) {
        if (this._blocked) {
            connection.block();
        }
    }

    @Override
    public void connectionUnregistered(AMQConnectionModel connection) {
    }

    @Override
    public void event(Event event) {
        switch (event) {
            case PERSISTENT_MESSAGE_SIZE_OVERFULL: {
                this.block();
                break;
            }
            case PERSISTENT_MESSAGE_SIZE_UNDERFULL: {
                this.unblock();
            }
        }
    }

    private void reportIfError(State state) {
        if (state == State.ERRORED) {
            CurrentActor.get().message(VirtualHostMessages.ERRORED());
        }
    }

    private class VirtualHostHouseKeepingTask
    extends HouseKeepingTask {
        public VirtualHostHouseKeepingTask() {
            super(VirtualHostImpl.this);
        }

        public void execute() {
            for (AMQQueue q : VirtualHostImpl.this._queueRegistry.getQueues()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Checking message status for queue: " + q.getName()));
                }
                try {
                    q.checkMessageStatus();
                }
                catch (Exception e) {
                    _logger.error((Object)("Exception in housekeeping for queue: " + q.getNameShortString().toString()), (Throwable)e);
                }
            }
            for (AMQConnectionModel connection : VirtualHostImpl.this.getConnectionRegistry().getConnections()) {
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)("Checking for long running open transactions on connection " + connection));
                }
                for (AMQSessionModel session : connection.getSessionModels()) {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Checking for long running open transactions on session " + session));
                    }
                    try {
                        session.checkTransactionStatus(VirtualHostImpl.this._vhostConfig.getTransactionTimeoutOpenWarn(), VirtualHostImpl.this._vhostConfig.getTransactionTimeoutOpenClose(), VirtualHostImpl.this._vhostConfig.getTransactionTimeoutIdleWarn(), VirtualHostImpl.this._vhostConfig.getTransactionTimeoutIdleClose());
                    }
                    catch (Exception e) {
                        _logger.error((Object)("Exception in housekeeping for connection: " + connection.toString()), (Throwable)e);
                    }
                }
            }
        }
    }

    private final class BeforeCloseListener
    implements EventListener {
        private BeforeCloseListener() {
        }

        public void event(Event event) {
            VirtualHostImpl.this.shutdownHouseKeeping();
        }
    }

    private final class BeforePassivationListener
    implements EventListener {
        private BeforePassivationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(Event event) {
            State finalState = State.ERRORED;
            try {
                VirtualHostImpl.this._connectionRegistry.close("Virtual host is being passivated");
                VirtualHostImpl.this.removeHouseKeepingTasks();
                VirtualHostImpl.this._queueRegistry.stopAllAndUnregisterMBeans();
                VirtualHostImpl.this._exchangeRegistry.clearAndUnregisterMbeans();
                VirtualHostImpl.this._dtxRegistry.close();
                finalState = State.PASSIVE;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                VirtualHostImpl.this._state = finalState;
                VirtualHostImpl.this.reportIfError(VirtualHostImpl.this._state);
                throw throwable;
            }
            VirtualHostImpl.this._state = finalState;
            VirtualHostImpl.this.reportIfError(VirtualHostImpl.this._state);
        }
    }

    private final class AfterActivationListener
    implements EventListener {
        private AfterActivationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(Event event) {
            State finalState = State.ERRORED;
            try {
                VirtualHostImpl.this.initialiseHouseKeeping(VirtualHostImpl.this._vhostConfig.getHousekeepingCheckPeriod());
                finalState = State.ACTIVE;
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                VirtualHostImpl.this._state = finalState;
                VirtualHostImpl.this.reportIfError(VirtualHostImpl.this._state);
                throw throwable;
            }
            VirtualHostImpl.this._state = finalState;
            VirtualHostImpl.this.reportIfError(VirtualHostImpl.this._state);
        }
    }

    private final class BeforeActivationListener
    implements EventListener {
        private BeforeActivationListener() {
        }

        public void event(Event event) {
            try {
                VirtualHostImpl.this._exchangeRegistry.initialise();
                VirtualHostImpl.this.initialiseModel(VirtualHostImpl.this._vhostConfig);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialise virtual host after state change", e);
            }
        }
    }
}

